.\" ====================================================================
.\"  @Troff-man-file{
.\"     author          = "Nelson H. F. Beebe",
.\"     version         = "0.06",
.\"     date            = "11 October 1994",
.\"     time            = "00:34:53 MDT",
.\"     filename        = "bibcheck.man",
.\"     address         = "Center for Scientific Computing
.\"                        Department of Mathematics
.\"                        University of Utah
.\"                        Salt Lake City, UT 84112
.\"                        USA",
.\"     telephone       = "+1 801 581 5254",
.\"     FAX             = "+1 801 581 4148",
.\"     checksum        = "31602 174 628 5114",
.\"     email           = "beebe@math.utah.edu (Internet)",
.\"     codetable       = "ISO/ASCII",
.\"     keywords        = "bibliography, syntax checking, heuristic
.\"                        checking, BibTeX",
.\"     supported       = "yes",
.\"     docstring       = "This file contains the UNIX manual pages
.\"                        for the bibcheck utility, a program for
.\"                        applying heuristic checks to BibTeX data
.\"                        base files to ferret out possible errors.
.\"
.\"                        The checksum field above contains a CRC-16
.\"                        checksum as the first value, followed by the
.\"                        equivalent of the standard UNIX wc (word
.\"                        count) utility output of lines, words, and
.\"                        characters.  This is produced by Robert
.\"                        Solovay's checksum utility.",
.\"  }
.\" ====================================================================
.if t .ds Bi B\s-2IB\s+2T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Bi BibTeX
.if t .ds La L\\h'-0.24m'\\v'-0.15v'\\s-2A\\s+2\\h'-0.15m'\\v'0.15v'T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds La LaTeX
.if t .ds Te T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Te TeX
.TH BIBCHECK 1 "11 October 1994" "Version 0.06"
.\"======================================================================
.SH NAME
bibcheck \- check a BibTeX bibliography file
.\"======================================================================
.SH SYNOPSIS
.BR bibcheck " <infile >outfile"
.nf
or
.fi
.BR bibcheck " BibTeXfile(s) >outfile"
.\"======================================================================
.SH DESCRIPTION
.B bibcheck
applies heuristic checks to \*(Bi\& files to
ferret out possible errors, portability problems,
and stylistic problems, often finding ones that
are quite difficult to spot by manual
proofreading.
.PP
Some of the checks made are
.TP \w'\(bu'u+2n
\(bu
duplicate
.I @String
abbreviations;
\(bu
duplicate citation labels;
\(bu
use of comma instead of
.I and
in author/editor names;
\(bu
ellipses represented by consecutive dots, rather
than by a \*(Te\& control sequence;
.TP
\(bu
horizontal tabs instead of spaces;
.TP
\(bu
unprotected special characters (ampersand,
percent, sharp sign) that would have special
significance to \*(Te\&;
.TP
\(bu
subscripts or superscripts outside of math mode;
.TP
\(bu
unclosed math mode;
.TP
\(bu
space before punctuation;
.TP
\(bu
spaces missing after initials;
.TP
\(bu
tildes (\*(Te\&'s tie command should be rare
in \*(Bi\& files, because \*(Bi\& normally
supplies needed ones);
.TP
\(bu
non-standard characters in citation labels;
.TP
\(bu
spurious blank lines;
.TP
\(bu
braced partial words;
.TP
\(bu
unbraced mixed-case words in titles;
.TP
\(bu
hyphens instead of en-dashes in page-number
ranges;
.TP
\(bu
quotation marks inside strings;
.TP
\(bu
trailing white space.
.PP
Warning messages identify the file name and line
number, in a format recognized by the GNU Emacs
.I compile
command, so that you can run it from within an
Emacs session, and then position rapidly to the
source file locations where the messages were
raised.
.PP
.BR lacheck (1)
performs similar checks on \*(La\& files; its
great utility was the inspiration for this
program.
.\"======================================================================
.SH CAVEATS
\*(Bi\& has loose syntactical requirements that
the current simple implementation of
.B bibcheck
does not support.  In particular, outer
parentheses may
.I not
be used in place of braces following ``@keyword''
patterns.  If you have such a file, you can use
.BR bibclean (1)
to prettyprint it into a form that
.B bibcheck
can handle successfully.
.\"======================================================================
.SH "SEE ALSO"
.BR bibclean (1),
.BR bibextract (1),
.BR biblex (1),
.BR biborder (1),
.BR bibparse (1),
.BR bibsort (1),
.BR bibtex (1),
.BR bibunlex (1),
.BR emacs (1),
.BR lacheck (1),
.BR nawk (1).
.\"======================================================================
.SH AUTHOR
.nf
Nelson H. F. Beebe, Ph.D.
Center for Scientific Computing
Department of Mathematics
University of Utah
Salt Lake City, UT 84112
Tel: +1 801 581 5254
FAX: +1 801 581 4148
Email: <beebe@math.utah.edu>
.fi
.\"==============================[The End]==============================
