.\" ====================================================================
.\"  @Troff-man-file{
.\"     author          = "Nelson H. F. Beebe",
.\"     version         = "0.08",
.\"     date            = "25 November 1994",
.\"     time            = "10:49:56 MST",
.\"     filename        = "bibcheck.man",
.\"     address         = "Center for Scientific Computing
.\"                        Department of Mathematics
.\"                        University of Utah
.\"                        Salt Lake City, UT 84112
.\"                        USA",
.\"     telephone       = "+1 801 581 5254",
.\"     FAX             = "+1 801 581 4148",
.\"     checksum        = "21447 253 785 6190",
.\"     email           = "beebe@math.utah.edu (Internet)",
.\"     codetable       = "ISO/ASCII",
.\"     keywords        = "bibliography, syntax checking, heuristic
.\"                        checking, BibTeX",
.\"     supported       = "yes",
.\"     docstring       = "This file contains the UNIX manual pages
.\"                        for the bibcheck utility, a program for
.\"                        applying heuristic checks to BibTeX data
.\"                        base files to ferret out possible errors.
.\"
.\"                        The checksum field above contains a CRC-16
.\"                        checksum as the first value, followed by the
.\"                        equivalent of the standard UNIX wc (word
.\"                        count) utility output of lines, words, and
.\"                        characters.  This is produced by Robert
.\"                        Solovay's checksum utility.",
.\"  }
.\" ====================================================================
.if t .ds Bi B\s-2IB\s+2T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Bi BibTeX
.if t .ds La L\\h'-0.24m'\\v'-0.15v'\\s-2A\\s+2\\h'-0.15m'\\v'0.15v'T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds La LaTeX
.if t .ds Te T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Te TeX
.TH BIBCHECK 1 "25 November 1994" "Version 0.08"
.\"======================================================================
.SH NAME
bibcheck \- check a BibTeX bibliography file
.\"======================================================================
.SH SYNOPSIS
.B bibcheck
[
.B \-author
]
[
.B \-copyright
]
[
.B \-debug
]
[
.B \-help
]
[
.B \-version
]
<infile >outfile
.nf
or
.fi
.B bibcheck
[
.B \-author
]
[
.B \-copyright
]
[
.B \-debug
]
[
.B \-help
]
[
.B \-version
]
BibTeXfile(s) >outfile
.\"======================================================================
.SH DESCRIPTION
.B bibcheck
applies heuristic checks to \*(Bi\& files to
ferret out possible errors, portability problems,
and stylistic problems, often finding ones that
are quite difficult to spot by manual
proofreading.
.PP
Some of the checks made are
.TP \w'\(bu'u+1n
\(bu
unrecognized token;
.TP
\(bu
duplicate
.I @String
abbreviations;
.TP
\(bu
duplicate citation labels;
.TP
\(bu
duplicate keywords in a single bibliographic
entry;
.TP
\(bu
unbalanced braces in value strings;
.TP
\(bu
use of comma instead of
.I and
in author/editor names;
.TP
\(bu
ellipses represented by consecutive dots, rather
than by a \*(Te\& control sequence;
.TP
\(bu
horizontal tabs instead of spaces;
.TP
\(bu
unprotected special characters (ampersand,
percent, sharp sign) that would have special
significance to \*(Te\&;
.TP
\(bu
subscripts or superscripts outside of math mode;
.TP
\(bu
unclosed math mode;
.TP
\(bu
space before punctuation;
.TP
\(bu
spaces or periods missing after initials;
.TP
\(bu
tildes (\*(Te\&'s tie command should be rare
in \*(Bi\& files, because \*(Bi\& normally
supplies needed ones);
.TP
\(bu
non-standard characters in citation labels;
.TP
\(bu
spurious blank lines;
.TP
\(bu
braced partial words;
.TP
\(bu
unbraced mixed-case words in titles;
.TP
\(bu
hyphens instead of en-dashes in page-number
ranges;
.TP
\(bu
typewriter quotation marks inside strings;
.TP
\(bu
omitted protecting braces inside quotation marks;
.TP
\(bu
trailing white space.
.PP
Warning messages identify the file name and line
number, in a format recognized by the GNU Emacs
.I compile
command, so that you can run it from within an
.BR emacs (1)
session, and then position rapidly to the
source file locations where the messages were
raised.
.PP
.BR lacheck (1)
performs similar checks on \*(La\& files; its
great utility was the inspiration for this
program.
.\"======================================================================
.SH OPTIONS
Command-line options may be abbreviated to a
unique leading prefix, and letter case is ignored.
.PP
To avoid confusion with options, if a filename
begins with a hyphen, it must be disguised by a
leading absolute or relative directory path, e.g.
.I /tmp/-foo.bib
or
.IR ./-foo.bib .
.\"-----------------------------------------------
.TP \w'\-copyright'u+3n
.B \-author
Display an author credit on
.IR stdout .
.\"-----------------------------------------------
.TP
.B \-copyright
Display a copyright message on
.IR stdout .
.\"-----------------------------------------------
.TP
.B \-debug
Display a token stream on
.IR stdout ,
suitable for possible input to
.BR bibunlex (1),
or for identifying the cause of a reported parsing
error.
.\"-----------------------------------------------
.TP
.B \-help
Display a usage message on
.IR stdout .
.\"-----------------------------------------------
.TP
.B \-version
Display a program version message on
.IR stdout .
.\"======================================================================
.SH "SEE ALSO"
.BR bibclean (1),
.BR bibdup (1),
.BR bibextract (1),
.BR bibindex (1),
.BR bibjoin (1),
.BR biblabel (1),
.BR biblex (1),
.BR biblook (1),
.BR biborder (1),
.BR bibparse (1),
.BR bibsort (1),
.BR bibtex (1),
.BR bibunlex (1),
.BR emacs (1),
.BR lacheck (1);
.\"======================================================================
.SH AUTHOR
.nf
Nelson H. F. Beebe, Ph.D.
Center for Scientific Computing
Department of Mathematics
University of Utah
Salt Lake City, UT 84112
Tel: +1 801 581 5254
FAX: +1 801 581 4148
Email: <beebe@math.utah.edu>
.fi
.\"==============================[The End]==============================
