.\" ====================================================================
.\"  @Troff-man-file{
.\"     author          = "Nelson H. F. Beebe",
.\"     version         = "0.10",
.\"     date            = "22 April 2000",
.\"     time            = "13:07:43 MDT",
.\"     filename        = "bibcheck.man",
.\"     address         = "Center for Scientific Computing
.\"                        Department of Mathematics
.\"                        University of Utah
.\"                        Salt Lake City, UT 84112
.\"                        USA",
.\"     telephone       = "+1 801 581 5254",
.\"     FAX             = "+1 801 581 4148",
.\"     checksum        = "14979 271 867 6750",
.\"     email           = "beebe@math.utah.edu (Internet)",
.\"     codetable       = "ISO/ASCII",
.\"     keywords        = "bibliography, syntax checking, heuristic
.\"                        checking, BibTeX",
.\"     supported       = "yes",
.\"     docstring       = "This file contains the UNIX manual pages
.\"                        for the bibcheck utility, a program for
.\"                        applying heuristic checks to BibTeX data
.\"                        base files to ferret out possible errors.
.\"
.\"                        The checksum field above contains a CRC-16
.\"                        checksum as the first value, followed by the
.\"                        equivalent of the standard UNIX wc (word
.\"                        count) utility output of lines, words, and
.\"                        characters.  This is produced by Robert
.\"                        Solovay's checksum utility.",
.\"  }
.\" ====================================================================
.if t .ds Bi B\s-2IB\s+2T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Bi BibTeX
.if t .ds La L\\h'-0.24m'\\v'-0.15v'\\s-2A\\s+2\\h'-0.15m'\\v'0.15v'T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds La LaTeX
.if t .ds Te T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Te TeX
.TH BIBCHECK 1 "22 April 2000" "Version 0.10"
.\"======================================================================
.SH NAME
bibcheck \- check a BibTeX bibliography file
.\"======================================================================
.SH SYNOPSIS
.B bibcheck
[
.B \-author
]
[
.B \-copyright
]
[
.B \-debug
]
[
.B \-help
]
[
.B \-version
]
<infile >outfile
.nf
or
.fi
.B bibcheck
[
.B \-author
]
[
.B \-copyright
]
[
.B \-debug
]
[
.B \-help
]
[
.B \-version
]
BibTeXfile(s) >outfile
.\"======================================================================
.SH DESCRIPTION
.B bibcheck
applies heuristic checks to \*(Bi\& files to
ferret out possible errors, portability problems,
and stylistic problems, often finding ones that
are quite difficult to spot by manual
proofreading.
.PP
Some of the checks made are
.TP \w'\(bu'u+1n
\(bu
unrecognized token;
.TP
\(bu
duplicate
.I @String
abbreviations;
.TP
\(bu
duplicate citation labels;
.TP
\(bu
duplicate keywords in a single bibliographic
entry;
.TP
\(bu
unbalanced braces in value strings;
.TP
\(bu
use of comma instead of
.I and
in author/editor names;
.TP
\(bu
ellipses represented by consecutive dots, rather
than by a \*(Te\& control sequence;
.TP
\(bu
horizontal tabs instead of spaces;
.TP
\(bu
unprotected special characters (ampersand,
percent, sharp sign) that would have special
significance to \*(Te\&;
.TP
\(bu
subscripts or superscripts outside of math mode;
.TP
\(bu
unclosed math mode;
.TP
\(bu
space before punctuation;
.TP
\(bu
spaces or periods missing after initials;
.TP
\(bu
tildes (\*(Te\&'s tie command should be rare
in \*(Bi\& files, because \*(Bi\& normally
supplies needed ones);
.TP
\(bu
non-standard characters in citation labels;
.TP
\(bu
spurious blank lines;
.TP
\(bu
braced partial words;
.TP
\(bu
unbraced mixed-case words in titles;
.TP
\(bu
hyphens instead of en-dashes in page-number
ranges;
.TP
\(bu
typewriter quotation marks inside strings;
.TP
\(bu
omitted protecting braces inside quotation marks;
.TP
\(bu
trailing white space.
.PP
Warning messages identify the file name and line
number, in a format recognized by the GNU Emacs
.I compile
command, so that you can run it from within an
.BR emacs (1)
session, and then position rapidly to the
source file locations where the messages were
raised.
.PP
.BR lacheck (1)
performs similar checks on \*(La\& files; its
great utility was the inspiration for this
program.
.\"======================================================================
.SH OPTIONS
Command-line options may be abbreviated to a
unique leading prefix, and letter case is ignored.
.PP
The leading hyphen that distinguishes an option
from a filename may be doubled, for compatibility
with GNU and POSIX conventions.  Thus,
.B \-author
and
.B \-\-author
are equivalent.
.PP
To avoid confusion with options, if a filename
begins with a hyphen, it must be disguised by a
leading absolute or relative directory path, e.g.
.I /tmp/-foo.bib
or
.IR ./-foo.bib .
.\"-----------------------------------------------
.TP \w'\-copyright'u+3n
.B \-author
Display an author credit on
.IR stderr ,
and exit with a success status code.
.\"-----------------------------------------------
.TP
.B \-copyright
Display a copyright message on
.IR stderr ,
and exit with a success status code.
.\"-----------------------------------------------
.TP
.B \-debug
Display a token stream on
.IR stdout ,
suitable for possible input to
.BR bibunlex (1),
or for identifying the cause of a reported parsing
error.
.\"-----------------------------------------------
.TP
.B \-help
Display a usage message on
.IR stderr ,
and exit with a success status code.
.\"-----------------------------------------------
.TP
.B \-version
Display a program version message on
.IR stderr ,
and exit with a success status code.
.\"======================================================================
.SH "SEE ALSO"
.BR bibclean (1),
.BR bibdup (1),
.BR bibextract (1),
.BR bibindex (1),
.BR bibjoin (1),
.BR biblabel (1),
.BR biblex (1),
.BR biblook (1),
.BR biborder (1),
.BR bibparse (1),
.BR bibsearch (1),
.BR bibsort (1),
.BR bibsplit (1),
.BR bibtex (1),
.BR bibunlex (1),
.BR emacs (1),
.BR lacheck (1).
.\"======================================================================
.SH AUTHOR
.nf
Nelson H. F. Beebe
Center for Scientific Computing
University of Utah
Department of Mathematics, 322 INSCC
155 S 1400 E RM 233
Salt Lake City, UT 84112-0090
USA
Email: \fCbeebe@math.utah.edu\fP, \fCbeebe@acm.org\fP, \fCbeebe@computer.org\fP,
       \fCbeebe@ieee.org\fP (Internet)
WWW URL: \fChttp://www.math.utah.edu/~beebe\fP
Telephone: +1 801 581 5254
FAX: +1 801 585 1640, +1 801 581 4148
.fi
.\"=====================================================================
.SH COPYRIGHT
.nf
\fC########################################################################
########################################################################
########################################################################
###                                                                  ###
###             bibcheck: check a BibTeX bibliography file           ###
###                                                                  ###
###              Copyright (C) 2000 Nelson H. F. Beebe               ###
###                                                                  ###
### This program is covered by the GNU General Public License (GPL), ###
### version 2 or later, available as the file COPYING in the program ###
### source distribution, and on the Internet at                      ###
###                                                                  ###
###               ftp://ftp.gnu.org/gnu/GPL                          ###
###                                                                  ###
###               http://www.gnu.org/copyleft/gpl.html               ###
###                                                                  ###
### This program is free software; you can redistribute it and/or    ###
### modify it under the terms of the GNU General Public License as   ###
### published by the Free Software Foundation; either version 2 of   ###
### the License, or (at your option) any later version.              ###
###                                                                  ###
### This program is distributed in the hope that it will be useful,  ###
### but WITHOUT ANY WARRANTY; without even the implied warranty of   ###
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    ###
### GNU General Public License for more details.                     ###
###                                                                  ###
### You should have received a copy of the GNU General Public        ###
### License along with this program; if not, write to the Free       ###
### Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   ###
### MA 02111-1307 USA                                                ###
########################################################################
########################################################################
########################################################################\fP
.fi
.\"======================================================================
.SH AVAILABILITY
Internet source distributions of
.B bibcheck
are available at the World-Wide Web Uniform
Resource Locator addresses
.PP
.RS
.nf
\fPftp://ftp.math.utah.edu/pub/tex/bib/bibcheck-x.yy.jar
ftp://ftp.math.utah.edu/pub/tex/bib/bibcheck-x.yy.tar.gz
ftp://ftp.math.utah.edu/pub/tex/bib/bibcheck-x.yy.zip
ftp://ftp.math.utah.edu/pub/tex/bib/bibcheck-x.yy.zoo
.PP
http://www.math.utah.edu/pub/tex/bib/bibcheck-x.yy.jar
http://www.math.utah.edu/pub/tex/bib/bibcheck-x.yy.tar.gz
http://www.math.utah.edu/pub/tex/bib/bibcheck-x.yy.zip
http://www.math.utah.edu/pub/tex/bib/bibcheck-x.yy.zoo\fC
.fi
.RE
.PP
where
.I x.yy
is the current version (0.10 for the version whose
documentation you are now reading).
.PP
That site is mirrored to several other Internet
archives, so you may also be able to find it
elsewhere on the Internet; try searching for the
string
.I bibcheck
at one or more of the popular Web search sites,
such as
.PP
.RS
.nf
\&\fChttp://altavista.digital.com/
http://search.microsoft.com/us/default.asp
http://www.dejanews.com/
http://www.dogpile.com/index.html
http://www.euroseek.net/page?ifl=uk
http://www.excite.com/
http://www.go2net.com/search.html
http://www.google.com/
http://www.hotbot.com/
http://www.infoseek.com/
http://www.inktomi.com/
http://www.lycos.com/
http://www.northernlight.com/
http://www.snap.com/
http://www.stpt.com/
http://www.yahoo.com/\fP
.fi
.RE
.\"==============================[The End]==============================
