#ifndef CUSTOM_H_DEFINED_
#define CUSTOM_H_DEFINED_

/***********************************************************************
This file is included by config.h, but is not part of that file
because it must be protected from autoconf twiddling.  Its purpose is
to provide workarounds for limitations of autoconf.
***********************************************************************/

#if (defined(__LCC__) || defined(__cplusplus) || defined(c_plusplus))
/* lcc is a strictly Standard C conforming compiler.  However, because
of an lcc 3.4b header file bug on Sun Solaris 2.x, configure will
conclude that STDC_HEADERS and HAVE_STDC should NOT be defined.  We
therefore override any choices made in config.h.

If a C++ compiler is used, override possibly erroneous conclusions
made by configure about header files and prototypes. */

#undef STDC_HEADERS
#define STDC_HEADERS 1

#undef HAVE_STDC
#define HAVE_STDC 1

#undef ARGS
#define ARGS(plist)	plist

#undef VOID
#define VOID		void

#undef VOIDP
#define VOIDP		void*

#undef const

#endif

#if defined(M_I86)
#define CONST		/* bug workaround for IBM PC Microsoft C compilers */
#else /* NOT M_I86 */
#define CONST const
#endif /* M_I86 */

/***********************************************************************
Put any other local customizations here, when configure does not
automatically generate the config.h settings that you want.  Please
report them back to the package author, <beebe@math.utah.edu>, for
inclusion in future releases.
***********************************************************************/

#endif /* CUSTOM_H_DEFINED_ */
