/* -*-C-*- strdup.c */
/*-->strdup*/
/**********************************************************************/
/******************************* strdup *******************************/
/**********************************************************************/

#include <config.h>
#include "xstdlib.h"
#include "xstring.h"
#include "xunistd.h"

RCSID("$Id: strdup.c,v 1.5 1993/12/29 18:26:46 beebe Exp beebe $")

char*
#if defined(HAVE_STDC)
Strdup(
const char  *s
)
#else
Strdup(s)				/* allocate new copy of s, or die */
const char  *s;
#endif
{
    register char  *p;

    p = (char*)malloc((size_t)(strlen(s) + 1));
    if (p == (char*)NULL)
    {
	(void)fprintf(stderr,"Out of memory in Strdup()\n");
	exit(EXIT_FAILURE);
    }
    (void)strcpy(p,s);
    return (p);
}
