/* -*-C-*- xstddef.h */
/**********************************************************************/
/****************************** stddef ********************************/
/**********************************************************************/

/* $Id: xstddef.h,v 1.6 1993/12/29 18:40:00 beebe Exp beebe $ */

#ifndef XSTDDEF_H_DEFINED_
#define XSTDDEF_H_DEFINED_

/***********************************************************************
This file provides some miscellaneous type and constant definitions. It
will include <stddef.h> in a Standard C environment instead.
[09-Oct-1995]
***********************************************************************/

#if    HAVE_STDDEF_H
#include <stddef.h>		/* get the host version */
#else

#ifndef NULL
#if    KCC_20
/* has its own version in stdio.h */
#else  /* NOT KCC_20 */
#define NULL			((VOIDP) 0L)
#endif /* KCC_20 */
#endif /* NULL */

#ifndef offsetof
#define offsetof(type,ident)	((size_t)(&((type*) NULL)->ident))
#endif /* offsetof */

extern volatile int		errno;	/* UNIX style error code */

#endif /* HAVE_STDDEF_H */

#endif /* XSTDDEF_H_DEFINED_ */
