#ifndef BIBYYDCL_H_DEFINED_
#define BIBYYDCL_H_DEFINED_

/***********************************************************************
This file contains function prototypes of lex library functions.

We need them because most current lex implementations do not generate
prototypes in the output C code, making it impossible to compile the
code with C++ compilers.

There are also variations in the types of some of these functions
which we must handle by preprocessor conditionals below.
***********************************************************************/

#if !(defined(__cplusplus) || defined(c_plusplus) || defined(FLEX_SCANNER))
int			yyback ARGS((int *p_, int m_));
void			yyerror ARGS((const char *s_));
int			yyinput ARGS((void));
int			yywrap ARGS((void));
int			yylex ARGS((void));
int			yylook ARGS((void));

#if HAVE_INT_YYOUTPUT
int			yyoutput ARGS((int c_));
#else
#if HAVE_VOID_YYOUTPUT
void			yyoutput ARGS((int c_));
#endif
#endif

#if HAVE_INT_YYUNPUT
int			yyunput ARGS((int c_));
#else
#if HAVE_VOID_YYUNPUT
void			yyunput ARGS((int c_));
#endif
#endif

#endif /* !(defined(__cplusplus) || defined(c_plusplus) || defined(FLEX_SCANNER)) */

#endif /* BIBYYDCL_H_DEFINED_ */
