/* -*-C-*- strnic.c */
/*-->strnicmp*/
/**********************************************************************/
/***************************** strnicmp *******************************/
/**********************************************************************/

#include <config.h>
#include "xctype.h"
#include "xstdlib.h"
#include "xstring.h"

RCSID("$Id: strnic.c,v 1.6 1993/12/29 18:27:48 beebe Exp beebe $")


/***********************************************************************
Compare strings ignoring case, stopping after n characters, or at
end-of-string, whichever comes first.
***********************************************************************/

int
#if defined(HAVE_STDC)
strnicmp(
const char	*s1,
const char	*s2,
size_t		n
)
#else
strnicmp(s1,s2,n)
const char	*s1;
const char	*s2;
size_t		n;
#endif
{
    int	   c1;
    int	   c2;

    for (; (n > 0) && *s1 && *s2; ++s1, ++s2, --n)
    {
	c1 = 0xff & (islower(*s1) ? (int)*s1 : tolower(*s1));
	c2 = 0xff & (islower(*s2) ? (int)*s2 : tolower(*s2));
	if (c1 < c2)
	    return (-1);
	else if (c1 > c2)
	    return (1);
    }
    if (n <= 0)		   /* first n characters match */
	return (0);
    else if (*s1 == '\0')
	return ((*s2 == '\0') ? 0 : -1);
    else /* (*s2 == '\0') */
	return (1);
}
