.\" ====================================================================
.\"  @Troff-man-file{
.\"     author          = "Nelson H. F. Beebe",
.\"     version         = "1.05",
.\"     date            = "01 August 1992",
.\"     time            = "17:48:42 MDT",
.\"     filename        = "bibclean.1",
.\"     address         = "Center for Scientific Computing
.\"                        Department of Mathematics
.\"                        South Physics Building
.\"                        University of Utah
.\"                        Salt Lake City, UT 84112
.\"                        USA
.\"                        Tel: +1 801 581 5254
.\"                        FAX: +1 801 581 4148",
.\"     checksum        = "32271 124 560 4123",
.\"     email           = "beebe@sandy.math.utah.edu (Internet)",
.\"     codetable       = "ISO/ASCII",
.\"     keywords        = "bibliography, BibTeX, prettyprint",
.\"     supported       = "yes",
.\"     docstring       = "This file is the UNIX nroff/troff manual page
.\"                        documentation for bibclean, a prettyprinter
.\"                        and syntax checker for BibTeX bibliography
.\"                        data base files.
.\"
.\"                        The checksum field above contains a CRC-16
.\"                        checksum as the first value, followed by the
.\"                        equivalent of the standard UNIX wc (word
.\"                        count) utility output of lines, words, and
.\"                        characters.  This is produced by Robert
.\"                        Solovay's checksum utility.",
.\"  }
.\" ====================================================================
.if t .ds Bi B\s-2IB\s+2T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Bi BibTeX
.TH BIBCLEAN 1 "01 August 1992" "Version 1.05"
.SH NAME
bibclean \- prettyprint a \*(Bi\& bibliography data base file
.SH SYNOPSIS
.nf
.B "bibclean [\-author] [\-help] ['\-?'] [\-keep-initials]"
.B "         [\-version] <infile >outfile"
.fi
.SH DESCRIPTION
.I bibclean
prettyprints a \*(Bi\& file on stdin to stdout, and
checks the brace balance and bibliography entry
syntax as well.  It can be used to detect problems
in \*(Bi\& files that sometimes confuse even \*(Bi\&
itself, and importantly, can be used to normalize
the appearance of collections of \*(Bi\& files.
.PP
Here is a summary of the formatting actions:
.IP
\*(Bi\& items are formatted into a consistent
structure with one
.I "key = \"value\""
pair per line, and the initial @ and trailing
right brace in column 1.
.IP
Text outside \*(Bi\& entries is passed through
verbatim..
.IP
Outer parentheses around entries are
converted to braces.
.IP
Long string values are split at a
blank and continued onto the next line with
leading indentation.
.IP
Tabs are expanded into blank
strings; their use is discouraged because they
inhibit portability, and can suffer corruption in
electronic mail.
.IP
Personal names in
.I author
and
.I editor
field values are normalized to the form ``P. D. Q.
Bach'', from ``P.D.Q. Bach'' and ``Bach, P.D.Q.''.
.PP
The standardized format of the output of
.I bibclean
facilitates the later application of
simple filters to process the text for extraction
of items, and also is the one expected by the GNU
Emacs \*(Bi\& support functions.
.SH OPTIONS
Command-line switches may be abbreviated to a
unique leading prefix, and letter case is not
significant.
.TP \w'\-keep-initials'u+2n
.B \-author
Display an author credit on
.IR stderr .
Sometimes the executable is separated from its
documentation and source code; this option
provides a way to recover from that.
.TP
.BR \-help or \-?
Display a short help message on
.IR stderr .
.TP
.B \-keep-initials
Do not insert a space after a period following author initials.
.TP
.B \-version
Display the program version number on
.IR stderr .
.SH "SEE ALSO"
bibtex(1), latex(1), tex(1)
.SH AUTHOR
.nf
Nelson H. F. Beebe
Center for Scientific Computing
Department of Mathematics
220 South Physics Building
University of Utah
Salt Lake City, UT 84112
USA
Tel: +1 801 581 5254
Email: <beebe@math.utah.edu>
.fi
