/* -*-C-*- xstddef.h */
/**********************************************************************/
/****************************** stddef ********************************/
/**********************************************************************/

/* $Id: xstddef.h,v 1.4 1992/07/10 18:07:04 beebe Exp beebe $ 
 * $Log: xstddef.h,v $
 * Revision 1.4  1992/07/10  18:07:04  beebe
 * Remove Lattice C support.
 * Change definition of NULL.
 *
 * Revision 1.3  1992/03/06  14:58:06  beebe
 * Complete two-month long development of version 3.0.114.  See
 * 00revhst.txt for details.
 *
 * Revision 1.2  1992/02/29  19:42:20  beebe
 * Update for version 3.0.114 [29-Feb-1992] following two-month
 * major overhaul and compilation testing on numerous machines.
 *
 * Revision 1.2  1992/02/29  19:42:20  beebe
 * Update for version 3.0.114 [29-Feb-1992] following two-month
 * major overhaul and compilation testing on numerous machines.
 *
 */

#ifndef STDDEF_H_DEFINED__
#define STDDEF_H_DEFINED__

/***********************************************************************
This file provides some miscellaneous type and constant definitions. It
will include <stddef.h> in a Standard C environment instead.  It is
intended to be included only by os.h.
[14-Dec-1988]
***********************************************************************/

#if    STDC || HAVE_STDDEF_H
#include <stddef.h>		/* get the host version */
#else  /* NOT (STDC || HAVE_STDDEF_H) */

#ifndef NULL
#if    KCC_20
/* has its own version in stdio.h */
#else  /* NOT KCC_20 */
#define NULL			((VOIDP) 0L)
#endif /* KCC_20 */
#endif /* NULL */

#ifndef offsetof
#define offsetof(type,ident)	((size_t)(&((type*) NULL)->ident))
#endif /* offsetof */

/* os.h has already included <sys/types.h>, so most systems should
already have size_t defined.  Here is a reasonable value to use if
it is not yet known. */
#if 0
typedef long			size_t;
#endif /* 0 */


#if    STDC
#else  /* NOT STDC */
typedef long			ptrdiff_t;
#endif /* STDC */

extern volatile int		errno;	/* UNIX style error code */

#endif /* STDC || HAVE_STDDEF_H */

#endif /* STDDEF_H_DEFINED__ */
