/* -*-C-*- xstdlib.h */
/**********************************************************************/
/****************************** stdlib ********************************/
/**********************************************************************/

/* $Id: xstdlib.h,v 1.5 1992/07/10 18:07:27 beebe Exp beebe $
 * $Log: xstdlib.h,v $
 * Revision 1.5  1992/07/10  18:07:27  beebe
 * Remove Lattice C support.
 * Add some preprocessor statement comments.
 *
 * Revision 1.4  1992/03/10  00:33:39  beebe
 * *** empty log message ***
 *
 * Revision 1.3  1992/03/06  14:58:06  beebe
 * Complete two-month long development of version 3.0.114.  See
 * 00revhst.txt for details.
 *
 * Revision 1.2  1992/02/29  19:42:20  beebe
 * Update for version 3.0.114 [29-Feb-1992] following two-month
 * major overhaul and compilation testing on numerous machines.
 *
 * Revision 1.2  1992/02/29  19:42:20  beebe
 * Update for version 3.0.114 [29-Feb-1992] following two-month
 * major overhaul and compilation testing on numerous machines.
 *
 */

#ifndef STDLIB_H_DEFINED__
#define STDLIB_H_DEFINED__

/***********************************************************************
This file provides function prototype definitions for the C library.  It
can be used for environments where no system stdlib.h file is available,
such as for GNU gcc in non-ANSI UNIX C implementations.	 Note that some
older implementations may have different function return values, so some
care should be exercised in using this file.

Functions are ordered alphabetically below in two groups, each of two
sections, one with ANSI-style prototypes, and one with old-style
prototypes.

The first group contains the functions that belong to ANSI stdlib.h.

The second group contains miscellaneous other library functions that
have prototypes in other ANSI header files, but often lack prototypes in
typical non-ANSI C implementations.

[29-Jan-1992]
***********************************************************************/

#if    STDC || HAVE_STDLIB_H

#include <stdlib.h>			/* get the host version */

#if sun					/* SunOS 4.1 stdlib.h is incomplete */
double		strtod ARGS((const char *nptr__,  char** endptr__));
char		*strtok ARGS((char *s__, const char *sepchars__));
long		strtol ARGS((const char *nptr__,  char** endptr__,
		    int base__));
unsigned long	strtoul ARGS((const char *nptr__,  char** endptr__,
		    int base__));
#endif /* sun */

#if    _AIX370
unsigned long	strtoul ARGS((const char *nptr__,  char** endptr__,
		    int base__));
#endif /* _AIX370 */

#if    _AIX
#include <unistd.h>	/* for EXIT_SUCCESS and EXIT_FAILURE */
			/* which SHOULD be in stdlib.h, but are not */
			/* on some AIX mainframe and PS/2 implementations */
#endif /* _AIX */

#else  /* NOT (STDC || HAVE_STDLIB_H) */

#include "xtypes.h"

/* Here is the contents of Standard C's stdlib.h.  Standard C reserves
names beginning with the regular expressions __ and _[A-Z] for
implementors.  To avoid conflict with such names, we use trailing
double underscores instead for private names. */

typedef int 				onexit_t;
typedef struct { int quot; int rem; }	div_t;
typedef struct { long quot; long rem; } ldiv_t;
typedef	unsigned int			wchar_t;

#ifdef ungetc
#undef ungetc		/* Turbo C macro conflicts with prototypes below */
#endif /* ungetc */

void		abort ARGS((void));
int		abs ARGS((int j__));
int		atexit ARGS((void (*func)(void)));
double		atof ARGS((const char *nptr__));
int		atoi ARGS((const char *nptr__));
long		atol ARGS((const char *nptr__));
char		*bsearch ARGS((const void *key__,  const void *base__,
		    size_t nmemb__, size_t size__,
		    int (*compar)(const void*, const void* )));
void		*calloc ARGS((size_t nmemb__,  size_t size__));
div_t		div ARGS((int numer__,  int denom__));
void		exit ARGS((int status__));
void		free ARGS((void *ptr__));
char		*getenv ARGS((const char *name__));
long		labs ARGS((long j__));
ldiv_t		ldiv ARGS((long numer__,  long denom__));
void		*malloc ARGS((size_t size__));

#ifndef MB_CUR_MAX
#define	MB_CUR_MAX 4			/* this is SYSTEM-DEPENDENT */
#endif /* MB_CUR_MAX */

int		mblen ARGS((const char *s__, size_t n__));
size_t		mbstowcs ARGS((wchar_t *pwcs__, const char *s__, size_t n__));
int		mbtowc ARGS((wchar_t *pwc__, const char *s__, size_t n__));


onexit_t	onexit ARGS((onexit_t (*func)(void)));

#ifndef NULL
#if    KCC_20
/* has its own version in stdio.h */
#else  /* NOT KCC_20 */
#define NULL			((VOIDP) 0L)	/* this is SYSTEM-DEPENDENT */
#endif /* KCC_20 */
#endif /* NULL */

void		qsort ARGS((void *base__,  size_t nmemb__,  size_t size__,
			int (*compar)(const void* , const void* )));
int		rand ARGS((void));

#ifndef RAND_MAX
#define	RAND_MAX 32767			/* this is SYSTEM-DEPENDENT */
#endif /* RAND_MAX */

void		*realloc ARGS((void *ptr__,  size_t size__));
void		srand ARGS((unsigned int seed__));
double		strtod ARGS((const char *nptr__,  char** endptr__));
char		*strtok ARGS((char *s__, const char *sepchars__));
long		strtol ARGS((const char *nptr__,  char** endptr__,
		    int base__));
unsigned long	strtoul ARGS((const char *nptr__,  char** endptr__,
		    int base__));
int		system ARGS((const char *string__));
size_t		wcstombs ARGS((char *s__, const wchar_t *pwcs__, size_t n__));
int		wctomb ARGS((char *s__, wchar_t wchar__));

#endif /* STDC || HAVE_STDLIB_H */

#if    VMS

/***********************************************************************
Under VAX VMS 3.x  and  4.x, exit(n) and return(n)  treat n as a VAX VMS
status code, where odd n means success, and even n means failure.  Under
VMS 5.x, return(n)  still acts this way, but  exit(n) means success if n
== 0,  and failure  if n !=  0,  bringing it into  agreement  with other
exit() implementations.  Prior to VMS 5.x, EXIT_FAILURE and EXIT_SUCCESS
were not defined in stdlib.h; they  are in VMS 5.x.   The code here will
therefore leave the new definitions unchanged,  and supply them on older
VMS systems.
***********************************************************************/

#ifndef EXIT_FAILURE
#define EXIT_FAILURE	((1 << 28) + 2) /* (suppresses %NONAME-E-NOMSG) */
#endif /* EXIT_FAILURE */

#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS	(1)
#endif /* EXIT_SUCCESS */

#else  /* NOT VMS */

#ifndef EXIT_FAILURE
#define EXIT_FAILURE	(1)
#endif /* EXIT_FAILURE */

#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS	(0)
#endif /* EXIT_SUCCESS */

#endif /* VMS */

#endif /* STDLIB_H_DEFINED__ */
