/* -*-C-*- xstring.h */
/**********************************************************************/
/****************************** string ********************************/
/**********************************************************************/

/* $Id: xstring.h,v 1.5 1992/07/10 18:08:22 beebe Exp beebe $
 * $Log: xstring.h,v $
 * Revision 1.5  1992/07/10  18:08:22  beebe
 * Remove Lattice C support.
 * Change definition of NULL.
 *
 * Revision 1.4  1992/03/06  14:58:06  beebe
 * Complete two-month long development of version 3.0.114.  See
 * 00revhst.txt for details.
 *
 * Revision 1.3  1992/03/06  14:55:54  beebe
 * Complete two-month long development of version 3.0.114.  See
 * 00revhst.txt for details.
 *
 * Revision 1.3  1992/03/06  14:55:54  beebe
 * Complete two-month long development of version 3.0.114.  See
 * 00revhst.txt for details.
 *
 * Revision 1.3  1992/03/06  14:54:22  beebe
 * Complete two-month long development of version 3.0.114.  See
 *
 * Revision 1.2  1992/02/29  19:42:20  beebe
 * Update for version 3.0.114 [29-Feb-1992] following two-month
 * major overhaul and compilation testing on numerous machines.
 *
 */

#ifndef STRING_H_DEFINED__	/* file ignored if included more than once */
#define STRING_H_DEFINED__

#ifndef OS_H_DEFINED__
#include "os.h"
#endif /* OS_H_DEFINED__ */

/* Standard C, System V, and BSD 4.3 call this <string.h>.  BSD 4.1 called it
<strings.h> */

#if    STDC
#include <string.h>		/* get the host version */
#else /* NOT STDC */

#include "xtypes.h"

/* Strictly, size_t must be defined in Standard C's string.h, but
since it is usually typedef'ed, e.g. "typedef long size_t" or "typedef
int size_t", sometimes with the unsigned attribute, we have no way of
checking here for a prior definition, so we can do nothing for it. */

#ifndef NULL
#if    KCC_20
/* has its own version in stdio.h */
#else  /* NOT KCC_20 */
#define NULL			((VOIDP) 0L)	/* this is SYSTEM-DEPENDENT */
#endif /* KCC_20 */
#endif /* NULL */


/* Some UNIX systems have the memxxx() functions in <memory.h>.
Standard C puts them in <string.h>. */

VOIDP		memccpy ARGS((VOIDP dest__,  const VOIDP src__,  int c__,
		    size_t n__));	/* Extension to Standard C */
VOIDP		memchr	ARGS((const VOIDP s__,  int c__,  size_t n__));
int		memcmp	ARGS((const VOIDP s1__,  const VOIDP s2__,
		    size_t n__));
VOIDP		memcpy	ARGS((VOIDP dest__,  const VOIDP src__,  size_t n__));
int		memicmp ARGS((const VOIDP s1__,  const VOIDP s2__,
		    size_t n__));	/* Extension to Standard C */
VOIDP		memmove ARGS((VOIDP dest__,  const VOIDP src__,  size_t n__));
VOIDP		memset	ARGS((VOIDP s__,  int c__,  size_t n__));
char		*strcat ARGS((char *s1__,  const char *s2__));
char		*strchr ARGS((const char *s__,  int character__));
int		strcmp ARGS((const char *s1__,  const char *s2__));
int		strcoll ARGS((const char *s1__, const char *s2__));
char		*strcpy ARGS((char *s1__,  const char *s2__));
size_t		strcspn ARGS((const char *s1__,  const char *s2__));
char		*strerror ARGS((int errnum__,  ...));
size_t		strlen ARGS((const char *s__));
char		*strncat ARGS((char *s1__,  const char *s2__,  size_t n__));
int		strncmp ARGS((const char *s1__,  const char *s2__,
		    size_t n__));
char		*strncpy ARGS((char *s1__,  const char *s2__,  size_t n__));
char		*strpbrk ARGS((const char *s1__,  const char *s2__));
char		*strrchr ARGS((const char *s__,  int character__));
size_t		strspn ARGS((const char *s1__,  const char *s2__));
char		*strstr ARGS((const char *s1__,  const char *s2__));
char		*strtok ARGS((char *s1__,  const char *s2__));
size_t		strxfrm ARGS((char *to__, const char *from__, 
		    size_t maxsize__));
#endif /* STDC */

/* Define a few additional functions used in the DVI driver family */

char 		*strdup ARGS((const char * s__));
int		stricmp ARGS((const char *, const char *));
char		*stristr ARGS((const char *s__, const char *sub__));
int		strnicmp ARGS((const char *s1__, const char *s2__, size_t n__));

#endif /* STRING_H_DEFINED__ */
