/* -*-C-*- machdefs.h */
/*-->machdefs*/
/**********************************************************************/
/****************************** machdefs ******************************/
/**********************************************************************/

#ifndef MACHDEFS_H_DEFINED_
#define MACHDEFS_H_DEFINED_

/* $Id: machdefs.h,v 1.8 1992/10/08 01:42:01 beebe Exp beebe $
 * $Log: machdefs.h,v $
 * Revision 1.8  1992/10/08  01:42:01  beebe
 * Update for C++.
 *
 * Revision 1.7  1992/07/10  15:50:06  beebe
 * Remove support for Lattice C.
 *
 * Revision 1.6  1992/03/10  14:13:53  beebe
 * *** empty log message ***
 *
 * Revision 1.5  1992/02/29  19:42:20  beebe
 * Update for version 3.0.114 [29-Feb-1992] following two-month
 * major overhaul and compilation testing on numerous machines.
 *
 * Revision 1.5  1992/02/29  19:42:20  beebe
 * Update for version 3.0.114 [29-Feb-1992] following two-month
 * major overhaul and compilation testing on numerous machines.
 *
 * Revision 1.4  1992/01/22  02:37:14  beebe
 * *** empty log message ***
 *
 * Revision 1.3  1992/01/22  02:04:26  beebe
 * Add Revision Control System keyword comments.
 *
 */

/***********************************************************************

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
This file should contain definitions for symbols used for all operating
system / implementation dependencies, and if the driver family has
already been implemented on your machine, this should be the only file
requiring changes.  If you choose to accept the default search paths,
then no changes should be necessary.

How to change this file, or the associated osxxx.h files:
	* Check os.h to see if your operating system and C language
	  implementation will be recognized automatically.  If so, then
	  you may choose to change:
		* the help string: DVIHELP
		* the search path variables: DVIFONTS, DVIINPUTS,
		  TEXFONTS, and TEXINPUTS
		* the font file name formats: FONTFMT and TFMFMT
		* the file system map file: FSMAPFILE
		* the TeX-to-PostScript font remapping file: PSMAPFILE
	  Note that ALL of these can be set at run-time from the
	  environment, the command line, and the startup file, so such
	  changes are not mandatory.  DVIFONTS and DVIINPUTS are
	  normally empty; if specified, they override TEXFONTS and
	  TEXINPUTS (see code in main() following the initglob() call).

	* If you are adding support for a new operating system, create a
	  new symbol OS_xxx for it in os.h, add a new
	  #if OS_xxx ...
	  #endif
	  section below, and a separate file, osxxx.h, to contain the
	  changes.

	* If you are adding a new implementation for an existing
	  operating system, create a new symbol for it in os.h and add
	  appropriate conditionals inside the corresponding osxxx.h
	  file.

	* If you must replace a standard C library function (usually
	  because of bugs in the library version), replace instances of
	  its use in the source code with an upper-case equivalent (e.g.
	  ungetc --> UNGETC), then define the upper-case name below in
	  the generic section, plus the separate operating-system
	  specific osxxx.h files.

	* ENV_xxx variables names are intentionally chosen below to be
	  identical across all architectures, since this reduces
	  confusion for users who work in hetergeneous environments.
	  Change them only at the risk of confounding users of the
	  drivers.

	* The following variables can be set by compile-time
	  preprocessor variable assignments:

		DEV_CANON_II
		DVIFONTS
		DVIINITFILE
		DVIINPUTS
		ENV_DVIFONTS
		ENV_DVIHELP
		ENV_DVIINPUTS
		ENV_FONTFMT
		ENV_FONTMAGS
		ENV_FSMAPFILE
		ENV_PSMAPFILE
		ENV_SPOOLFMT
		ENV_SYSPATH
		ENV_TEXFONTS
		ENV_TEXINPUTS
		ENV_TFMFMT
		FONTFMT
		FSMAPFILE
		PSMAPFILE
		HIRES
		SUBEXT
		SUBNAME
		TEXFONTS
		TEXINPUTS
		TFMFMT

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

List of symbols actually used for #if's [22-Jan-1992]

Flags and strings:
	ALLOW_INTERRUPT	-- allow interactive interrupt
	ARITHRSHIFT	-- implementation uses arithmetic (not logical)
			   right shift
	BUFSIZE		-- stdio.h default buffer size (osvmcms.h only)
	CACHE_FONTS	-- implement font caching in memory to reduce
			   I/O, especially important for networked file
			   systems.
	DISKFULL	-- test for stdio errors
	DVIEXT		-- DVI file extension
	DVIFONTS	-- TeX font file path list
	DVIHELP		-- how to find documentation (for usage())
	DVIINITFILE	-- startup file name
	DVIINPUTS	-- directory path list for non-font files
	DVIPREFIX	-- prefix to standard 3-character extension of
			   output and log files
	ENV_DVIFONTS	-- environment variable name for DVIFONTS
	ENV_DVIINPUTS	-- environment variable name for DVIINPUTS
	ENV_DVIHELP	-- environment variable name for DVIHELP
	ENV_FONTFMT	-- environment variable name for FONTFMT
	ENV_FONTMAGS	-- environment variable name for FONTMAGS
	ENV_FSMAPFILE	-- environment variable name for FSMAPFILE
	ENV_PSMAPFILE	-- environment variable name for PSMAPFILE
	ENV_SPOOLFMT	-- environment variable name for SPOOLFMT
	ENV_SYSPATH	-- environment variable name for system search
			   path
	ENV_TEXFONTS	-- environment variable name for TEXFONTS
	ENV_TEXINPUTS	-- environment variable name for TEXINPUTS
	ENV_TFMFMT	-- environment variable name for TFMFMT
	ERRSUFFIX	-- error file extension
	EXTSEPARATOR	-- string that separates a file name and
			   extension
	FILE_BASE	-- macros for memory-mapped font support
	FILE_CNT
	FILE_PTR
	FONTFMT		-- font name format list
	FONTMAGS	-- font magnification list
	FOPEN_		-- name of fopen() or its replacement; UNIX
			   <sys/file.h> defines FOPEN, so we add a
			   trailing underscore
	FSEEK		-- name of fseek() or its replacement
	FSMAPFILE	-- file system map file
	FTELL		-- name of ftell() or its replacement
	GETENV		-- name of getenv() or its replacement
	HOST_WORD_SIZE	-- host integer word size in bits
	LINT_ARGS	-- select argument type checking (only for IBM
			   PC DOS Microsoft C 4.0)
	MALLOC		-- name of malloc() or its replacement
	MAXDRIFT	-- default value for maxdrift option (can be
			   changed at run time)
	MAXOPENFONTS	-- limit on number of open font files (can be
			   changed at run time)
	OPTION_CHAR	-- command-line option prefix character
			   (normally '-')
	PSMAPFILE	-- TeX-to-PostScript font remapping file
	PS_MAXWIDTH	-- approximate line width limit for PostScript
			   output
	PS_SHORTLINES	-- shorter output lines in PostScript
	PS_XONXOFFBUG	-- PostScript version 23.0 Xon/Xoff bug
			   workaround
	PXLID		-- TeX PXL file ID
	READ		-- name of read() or its replacement
	REWIND		-- name of rewind() or its replacement
	SEGMEM		-- segmented memory (Intel); bitmap is raster
			   vector
	SPOOLFMT	-- DVI spool command format
	SUBEXT		-- font substitution file extension
	SUBNAME		-- font substitution file name
	SYSPATH		-- system search path environment variable name
	TEXFONTS	-- TeX font file path list
	TEXINPUTS	-- TeX input file path list
	TFMEXT		-- TFM file extension
	TFMFMT		-- TFM file format
	UNGETC		-- name of ungetc() or its replacement

Alternate library routines are supplied on some systems for misfeature
workarounds.

Standard C reserves preprocessor symbols beginning with an underscore
followed by an upper-case letter, or another underscore, for
implementation flags, and requires __STDC__ to be non-zero if the
implementation is standard conforming.  Such macros, once defined, are
permanent, and may not be changed by the user.  Not all compilers
enforce this, but GNU gcc does.

In pre-Standard C implementations, os.h defines __STDC__ to be zero.
However, because some almost Standard-C-conformant compilers define
__STDC__ as an unchangeable 0, we use a private symbol, STDC, instead.

GNU gcc unfortunately defines __STDC__ to be non-zero, but in most
implementations, still only provides a compiler, but neither a run-time
library, nor system header files, which are likely to be written in
pre-Standard C.  We therefore have to jump through a few hoops to deal
with it (gcc's author refuses to fix the error).  The compiler is
excellent, produces code for many different architectures, and is free,
so we put up with this idiosyncrasy.

	__STDC__		-- Standard C conformant compiler and
				   library
	__GNUC__		-- GNU C compiler
	__MSDOS__, __TURBOC__	-- Turbo C on PC DOS
	__COMPILER_KCC__	-- SRI's KCC on TOPS-20
	MSDOS, _QC		-- Microsoft C and Quick C

Use of these symbols, other than STDC, should be restricted to os.h, and
possibly typedefs.h, xstddef.h, and xstdlib.h.

These private symbols for C implementations are always defined to be
zero or non-zero:

	UNIX_ATT	-- AT&T UNIX (System III, V), AIX, HPUX, ...
	UNIX_BSD	-- Berkeley 4.xBSD, ULTRIX
	IBM_PC_MICROSOFT-- IBM PC Microsoft version 3.x or later C
			   compiler
	IBM_PC_TURBO	-- IBM PC Turbo C version 2.0 or later C
			   compiler
	KCC_20		-- SRI's KCC Compiler on TOPS-20
	PCC_20		-- Portable C Compiler on TOPS-20
	STDC		-- Standard C (or almost Standard C) conformant
			   compiler and library
	UNIXPC		-- UNIX PC (System V based)

Operating systems (one is always non-zero, rest are zero):

	OS_ATARI	-- Atari 520ST+ TOS (similar to MS DOS)
	OS_PCDOS	-- IBM (and clones) PC DOS and MS DOS
	OS_PRIMOS	-- Prime Primos
	OS_RMX		-- Intel RMX 286
	OS_TOPS20	-- DEC-20 TOPS-20
	OS_UNIX		-- UNIX (almost any variant)
	OS_VAXVMS	-- VAX VMS
	OS_VMCMS	-- IBM VM/CMS with Waterloo C compiler

Device names (defined in each DVIxxx.C file) (only one is non-zero for a
given output device):

	DEV_APOLLO		-- Apollo workstation display
	DEV_BBNBITGRAPH		-- BBN BitGraph terminal
	DEV_BROTHER_HL8		-- Brother HL8 laser printer
	DEV_CANON		-- Canon LBP-8 A2 laser printer
				   (original driver)
	DEV_CANON_A2		-- Canon LBP-8 A2 laser printer (new
				   driver)
	DEV_CANON_II		-- Canon LBP-II laser printer
	DEV_CUBICOMP		-- Cubicomp PC-10 color frame buffer
	DEV_DOTMATRIX		-- many dot-matrix printers
	DEV_DPLZR1230		-- Dataproducts LZR-1230 (HPLJ+
				   emulation)
	DEV_GRAYSCREEN		-- Gray-scale screen display
	DEV_HPJETPLUS		-- Hewlett-Packard Laser Jet Plus
				   (downloaded fonts)
	DEV_IBMRT_CONSOLE	-- IBM RT display console
	DEV_IMPRESS		-- imPRESS (IMAGEN laser printer)
	DEV_KYOCERA		-- Kyocera F-1010 laser printer
	DEV_POSTSCRIPT		-- Adobe PostScript (Apple LaserWriter
				   laser printer, and many others)
	DEV_SUNWINDOWS		-- SunWindows (or SunView) on Sun
				   Microsystems workstations
	DEV_UNIXPC		-- AT&T UNIX PC display console
	DEV_VGASCREEN		-- IBM PC with VGA screen

IBM VM/CMS note:

DVI driver implementation attempts so far with the IBM and SAS/Lattice C
compilers have been unsuccessful.  The port using Waterloo C was done by
Shashi Sathaye <SYSSHASH@UKCC.UKY.EDU> at the Computing Center,
University of Kentucky, Lexington, KY 40503.  Since no Make
implementation yet exists for VM/CMS, the compilations must be done
manually:

	CW dvixxx
	global txtlib clib
	load dvixxx

***********************************************************************/

/**********************************************************************
Define all symbols for devices, operating systems, and implementations
to be explicitly 0, unless it is expected that they might be set at
compile time.
***********************************************************************/

#define ALLOW_INTERRUPT	0
#define ARITHRSHIFT	1 /* most C compilers use arithmetic right shift */

#define DISKFULL(fp)	(ferror(fp) && (errno == ENOSPC))
#define DVIEXT		".dvi"

#ifndef DVIFONTS			/* can be set at compile time */
#define DVIFONTS	""
#endif /* DVIFONTS */

#ifndef DVIINITFILE			/* can be set at compile time */
#define DVIINITFILE	"dvi.ini"
#endif /* DVIINITFILE */

#ifndef DVIINPUTS			/* can be set at compile time */
#define DVIINPUTS	""
#endif /* DVIINPUTS */

#define DVIPREFIX	"dvi-"

/***********************************************************************
The ENV_xxx values are strings to be passed to GETENV() to obtain
run-time modifications of various strings.  In the interests of
consistency across all supported architectures, we keep these identical,
in one letter case, and with no special characters.  Any local changes
should therefore be made by compile-time definitions.
***********************************************************************/

#ifndef ENV_DVIFONTS			/* can override at compile time */
#define ENV_DVIFONTS	"DVIFONTS"
#endif /* ENV_DVIFONTS */

#ifndef ENV_DVIHELP			/* can override at compile time */
#define ENV_DVIHELP	"DVIHELP"
#endif /* ENV_DVIHELP */

#ifndef ENV_DVIINPUTS			/* can override at compile time */
#define ENV_DVIINPUTS	"DVIINPUTS"
#endif /* ENV_DVIINPUTS */

#ifndef ENV_FONTFMT			/* can override at compile time */
#define ENV_FONTFMT	"FONTFMT"
#endif /* ENV_FONTFMT */

#ifndef ENV_FONTMAGS			/* can override at compile time */
#define ENV_FONTMAGS	"FONTMAGS"
#endif /* ENV_FONTMAGS */

#ifndef ENV_FSMAPFILE			/* can override at compile time */
#define ENV_FSMAPFILE	"FSMAPFILE"
#endif /* ENV_FSMAPFILE */

#ifndef ENV_PSMAPFILE			/* can override at compile time */
#define ENV_PSMAPFILE	"PSMAPFILE"
#endif /* ENV_PSMAPFILE */

#ifndef ENV_SPOOLFMT			/* can override at compile time */
#define ENV_SPOOLFMT	"SPOOLFMT"
#endif /* ENV_SPOOLFMT */

#ifndef ENV_TEXFONTS			/* can override at compile time */
#define ENV_TEXFONTS	"TEXFONTS"
#endif /* ENV_TEXFONTS */

#ifndef ENV_TEXINPUTS			/* can override at compile time */
#define ENV_TEXINPUTS	"TEXINPUTS"
#endif /* ENV_TEXINPUTS */

#ifndef ENV_TFMFMT			/* can override at compile time */
#define ENV_TFMFMT	"TFMFMT"
#endif /* ENV_TFMFMT */

#define ERRSUFFIX	"err"		/* most systems use "dviname.err" */
#define EXTSEPARATOR	"."		/* most systems use "file.ext" */

/***********************************************************************
The following definitions work for at least PCC-20, BSD 4.2 and 4.3, and
HPUX; VAX VMS has an extra level of indirection.  Check the definition
of fileno(fp) in stdio.h; on PCC-20, it is
	#define fileno(p) ((p)->_file)
***********************************************************************/
#define FILE_CNT(fp)	(fp)->_cnt
#define FILE_BASE(fp)	(fp)->_base
#define FILE_PTR(fp)	(fp)->_ptr

#define FONTMAGS	""
#define FOPEN_		fopen
#define FSEEK		fseek
#define FTELL		ftell
#define GETENV		getenv
#define MALLOC(n)	malloc(n)
#define MAXDRIFT	2		/* we insist that
					abs|(hh-pixel_round(h))<=MAXDRIFT| */

/***********************************************************************
MAXOPENFONTS should be 7 less than the system limit on open files,
allowing for files open on stdin, stdout, stderr, .dvi, .dvi-log,
.dvi-xxx, and the font substitution file, plus MAXOPENFONTS font files.
It may be additionally limited by the amount of memory available for
buffers (e.g.  IBM PC); in such a case, the dvixxx.c files will redefine
it.
***********************************************************************/

#define MAXOPENFONTS	((OPENMAX) - 7)

#ifndef OPTION_CHAR
/***********************************************************************
This character prefixes command-line option switches.  The default
follows UNIX traditions.  Note that if you redefine this, you should
update all documentation to match.  There is no compelling reason to
change this for any supported operating system, but sometimes people
want to anyway.
***********************************************************************/
#define OPTION_CHAR	'-'
#endif /* OPTION_CHAR */

#define isoption(c)	(((c) == OPTION_CHAR) || ((c) == '@'))

#define PS_XONXOFFBUG	0
#define PXLID		0

/***********************************************************************
For font caching to succeed, read() must return the requested number of
bytes, and preferably do this with one system call and no double
buffering.
***********************************************************************/

#define READ		read

/***********************************************************************
In many implementations, rewind(fp) is defined as equivalent to
fseek(fp,0L,0).  In some, however (e.g.  PCC-20, and probably others
based on PCC), it additionally discards input buffer contents, which may
cause unnecessary I/O, and in the case of font caching, clears the
cache.  Defining it in terms of fseek() should be okay, but the
implementation of fseek() should be checked.
***********************************************************************/

#define REWIND(fp)	(void)FSEEK(fp,0L,0)

#ifndef SEGMEM
#define SEGMEM		0		/* permit defining at compile time */
					/* for debugging SEGMEM code on UNIX */
#endif /* SEGMEM */

#define SPOOLFMT	"DVISPOOL %s\n"

#define SYSPATH		""

#define TFMEXT		".tfm"

#define UNGETC		ungetc

/**********************************************************************/
/* Clear all implementation/operating-system flags--reset later in
dvixxx.c */

#define DEV_APOLLO		0
#define DEV_BBNBITGRAPH		0
#define	DEV_BROTHER_HL8		0
#define DEV_CANON		0
#define DEV_CANON_A2		0

#ifndef DEV_CANON_II	/* compile-time option for dvican.c and dvica2.c */
#define DEV_CANON_II		0
#endif /* DEV_CANON_II */

#define DEV_CUBICOMP		0
#define DEV_DOTMATRIX		0
#define DEV_DPLZR1230		0
#define DEV_GRAYSCREEN		0
#define DEV_HPJETPLUS		0
#define DEV_KYOCERA		0
#define DEV_IMPRESS		0
#define DEV_POSTSCRIPT		0
#define DEV_SUNWINDOWS		0
#define DEV_UNIXPC		0
#define DEV_VGASCREEN		0
#define CACHE_FONTS		0

/***********************************************************************
O/S-specific changes are relegated to separate files for each system, so
that we only need to read one of them at compile time, reducing by about
800 the number of lines read for each compilation unit.
***********************************************************************/

#if    OS_ATARI
#include "osatari.h"
#endif /* OS_ATARI */

#if    OS_PCDOS
#include "ospcdos.h"
#endif /* OS_PCDOS */

#if    OS_PRIMOS
#include "osprimos.h"
#endif /* OS_PRIMOS */

#if    OS_RMX
#include "osrmx.h"
#endif /* OS_RMX */

#if    OS_TOPS20
#include "ostops20.h"
#endif /* OS_TOPS20 */

#if    OS_UNIX
#include "osunix.h"
#endif /* OS_UNIX */

#if    OS_VAXVMS
#include "osvaxvms.h"
#endif /* OS_VAXVMS */

#if    OS_VMCMS
#include "osvmcms.h"
#endif /* OS_VMCMS */

#endif /* MACHDEFS_H_DEFINED_ */
