/* -*-C-*- ostops20.h */
/*-->ostops20*/
/**********************************************************************/
/******************************* ostops20 *****************************/
/**********************************************************************/

#ifndef OSTOPS20_H_DEFINED_
#define OSTOPS20_H_DEFINED_

/* $Id: ostops20.h,v 1.4 1992/10/08 01:42:01 beebe Exp beebe $
 * $Log: ostops20.h,v $
 * Revision 1.4  1992/10/08  01:42:01  beebe
 * Update for C++.
 *
 * Revision 1.3  1992/03/10  14:13:53  beebe
 * *** empty log message ***
 *
 * Revision 1.2  1992/02/29  19:42:20  beebe
 * Update for version 3.0.114 [29-Feb-1992] following two-month
 * major overhaul and compilation testing on numerous machines.
 *
 * Revision 1.2  1992/02/29  19:42:20  beebe
 * Update for version 3.0.114 [29-Feb-1992] following two-month
 * major overhaul and compilation testing on numerous machines.
 *
 * Revision 1.1  1992/02/29  19:13:19  beebe
 * Initial revision
 *
 * Revision 1.1  1992/02/29  19:13:19  beebe
 * Initial revision
 *
 */

/***********************************************************************
**
**  Adapted for the DEC-20 TOPS-20  operating system with Jay  Lepreau's
**  PCC-20  by  Nelson  H.F.	Beebe,  College  of  Science   Computer,
**  University of Utah, Salt Lake City, UT 84112, Tel: (801) 581-5254.
**
**  The PCC_20 switch is  used to get around  variations on the  DEC-20.
**  The major one is  that text files have  7-bit bytes, while the  .DVI
**  file and the font files have 8-bit bytes.  For the latter, we use  a
**  routine f20open which provides  the necessary interface for  opening
**  with a  different byte size.  PCC-20 follows many other C  compilers
**  in that only the first 8 characters of identifiers are looked at, so
**  massive substitutions  were  necessary  in the  file  commands.h  to
**  shorten the long names there.
**
**  The PCC_20 switch is also used  to get variant font directory  names
**  and to select TOPS-20 jsys  code.  TOPS-20 is a wonderous  operating
**  system with  capabilities far  beyond  most of  its  contemporaries.
**  Like Topsy, it  just grew, and  consequently, its many  capabilities
**  are not  well  integrated.	 The terminal  control  jsys'es  (MTOPR,
**  RFMOD, SFMOD, STPAR, RFCOC, SFCOC and TLINK) are particularly poorly
**  done -- RFMOD returns  the JFN mode word,  particular bits of  which
**  must be set by SFMOD,  STPAR, and TLINK.  Why  could there not be  a
**  "return  the  terminal  state"  and  "restore  the  terminal  state"
**  jsys'es?  Some of this  may in fact be  already integrated into  the
**  PCC-20 C run-time library, but since it is totally undocumented  (an
**  all-too common problem with C),  it is essentially unusable in  that
**  form.
**
**  The OS_TOPS20 switch is used in one place to get ioctl.h included at
**  the right point, and in several places to get error messages  output
**  with Tops-20 conventions in  column 1: query  (?)  causes batch  job
**  abort, percent (%) flags a warning.
**
***********************************************************************/

#if    KCC_20
/* KCC wants all #if symbols defined before use. */

#ifdef CACHE_FONTS
#undef CACHE_FONTS
#endif /* CACHE_FONTS */

#define CACHE_FONTS 0			/* cannot support this yet */
#endif /* KCC_20 */

#if    PCC_20

#ifdef ARITHRSHIFT
#undef ARITHRSHIFT
#endif /* ARITHRSHIFT */

#define ARITHRSHIFT	0		/* PCC-20 uses logical right shift */

#if    PCC_20

#ifdef CACHE_FONTS
#undef CACHE_FONTS
#endif /* CACHE_FONTS */

#define CACHE_FONTS	1
#endif /* PCC_20 */

#ifdef DISKFULL
#undef DISKFULL
#endif /* DISKFULL */

#define DISKFULL(fp)	ferror(fp)	/* PCC-20 does not always set errno */
#endif /* PCC_20 */

#define DVIHELP	"help dvi\nor\ntype hlp:dvi.hlp\nor\nxinfo g(dvi)"

#ifndef ENV_SYSPATH			/* can override at compile time */
#define ENV_SYSPATH	"SYS"
#endif /* ENV_SYSPATH */

#ifdef ERRSUFFIX
#undef ERRSUFFIX
#endif /* ERRSUFFIX */

#define ERRSUFFIX	"err.-1"	/* to force new generation */

#ifndef FONTFMT				/* can be set at compile time */
#define FONTFMT		"%n.%dpk;%n.%dgf;%n.%mpxl;%n.vf;%n.tfm"
#endif /* FONTFMT */

#ifdef FOPEN_
#undef FOPEN_
#endif /* FOPEN_ */

#define FOPEN_		f20open		/* private version for 8-bit binary */

#ifndef FSMAPFILE			/* can be set at compile time */
#define FSMAPFILE	"texfiles.map"
#endif /* FSMAPFILE */

#define HOST_WORD_SIZE	36

#ifndef PSMAPFILE			/* can be set at compile time */
#define PSMAPFILE	"psfonts.map"
#endif /* PSMAPFILE */

#ifndef PS_MAXWIDTH
#define PS_MAXWIDTH	72
#endif /* PS_MAXWIDTH */

#ifndef PS_SHORTLINES
#define PS_SHORTLINES	1
#endif /* PS_SHORTLINES */

#if    PCC_20

#ifdef READ
#undef READ
#endif /* READ */

#define READ		_read		/* fast version with one system call */
					/* and single buffering */
#endif /* PCC_20 */

#define SEP_COMP " ;,|"	/* separators between filename components */
#define SEP_PATH ":>"	/* separators between directory path and filename */
			/* first char is what we default to */

#undef SPOOLFMT
#define SPOOLFMT	"DVISPOOL: %s\n"

#ifndef SUBEXT				/* can be set at compile time */
#define SUBEXT		".sub"
#endif /* SUBEXT */

#ifndef SUBNAME				/* can be set at compile time */
#define SUBNAME		"texfonts"
#endif /* SUBNAME */

#ifndef TEXFONTS			/* can be set at compile time */
#define TEXFONTS	ENV_TEXFONTS
#endif /* TEXFONTS */

#ifndef TEXINPUTS			/* can be set at compile time */
#define TEXINPUTS	ENV_TEXINPUTS
#endif /* TEXINPUTS */

#ifndef TFMFMT				/* can be set at compile time */
#define TFMFMT		"%n.tfm"
#endif /* TFMFMT */

/**********************************************************************/
/* The following definitions (down to the endif) are taken from */
/* monsym.h.   It is too big for CPP to handle, so this kludge is */
/* necessary until CPP's tables can be enlarged. */

/* selected fields for CHFDB% */
#define CF_nud		01:35-0		/* no update directory */
#define CF_dsp		0777:35-17	/* fdb displacement */
#define CF_jfn		0777777:35-35	/* jfn */

#define FBbyv		011		/* retention+bytesize+mode,,# of pages*/
#define FB_ret		077:35-5	/* retention count */

/* tty mode definitions */

#define MOrlw		030		/* read width */
#define MOslw		031		/* set width */
#define MOrll		032		/* read length */
#define MOsll		033		/* set length */

#define MOsnt		034		/* set tty non-terminal status */
#define MOsmn		01		/* no system messages(i.e. suppress) */
#define MOsmy		00		/* yes system messages(default) */
#define MOrnt		035		/* read tty non-terminal status */

/* fields of jfn mode word */

#define TT_osp		01:35-0		/* output suppress */
#define TT_mff		01:35-1		/* mechanical formfeed present */
#define TT_tab		01:35-2		/* mechanical tab present */
#define TT_lca		01:35-3		/* lower case capabilities present */
#define TT_len		0177:35-10	/* page length */
#define TT_wid		0177:35-17	/* page width */
#define TT_wak		017:35-23	/* wakeup field */
#define TT_wk0		01:35-18	/* wakeup class 0 (unused) */
#define TT_ign		01:35-19	/* ignore tt_wak on sfmod */
#define TT_wkf		01:35-20	/* wakeup on formating control chars */
#define TT_wkn		01:35-21	/* wakeup on non-formatting controls */
#define TT_wkp		01:35-22	/* wakeup on punctuation */
#define TT_wka		01:35-23	/* wakeup on alphanumerics */
#define TT_eco		01:35-24	/* echos on */
#define TT_ecm		01:35-25	/* echo mode */
#define TT_alk		01:35-26	/* allow links */
#define TT_aad		01:35-27	/* allow advice (not implemented) */
#define TT_dam		03:35-29	/* data mode */
#define TTbin		00		/* binary */
#define TTasc		01		/* ascii */
#define TTato		02		/* ascii and translate output only */
#define TTate		03		/* ascii and translate echos only */
#define TT_uoc		01:35-30	/* upper case output control */
#define TT_lic		01:35-31	/* lower case input control */
#define TT_dum		03:35-33	/* duplex mode */
#define TTfdx		00		/* full duplex */
#define TT0dx		01		/* not used, reserved */
#define TThdx		02		/* half duplex (character) */
#define TTldx		03		/* line half duplex */
#define TT_pgm		01:35-34	/* page mode */
#define TT_car		01:35-35	/* carrier state */

/* tlink */

#define TL_cro		01:35-0		/* clear remote to object link */
#define TL_cor		01:35-1		/* clear object to remote link */
#define TL_eor		01:35-2		/* establist object to remote link */
#define TL_ero		01:35-3		/* establish remote to object link */
#define TL_sab		01:35-4		/* set accept bit for object */
#define TL_abs		01:35-5		/* accept bit state */
#define TL_sta		01:35-6		/* set or clear advice */
#define TL_aad		01:35-7		/* accept advice */
#define TL_obj		0777777:35-35	/* object designator */


#endif /* OSTOPS20_H_DEFINED_ */
