/* -*-C-*- osvaxvms.h */
/*-->osvaxvms*/
/**********************************************************************/
/******************************* osvaxvms *****************************/
/**********************************************************************/

#ifndef OSVAXVMS_H_DEFINED_
#define OSVAXVMS_H_DEFINED_

/* $Id: osvaxvms.h,v 1.4 1992/10/08 01:42:01 beebe Exp beebe $
 * $Log: osvaxvms.h,v $
 * Revision 1.4  1992/10/08  01:42:01  beebe
 * Update for C++.
 *
 * Revision 1.3  1992/03/10  14:13:53  beebe
 * *** empty log message ***
 *
 * Revision 1.2  1992/02/29  19:42:20  beebe
 * Update for version 3.0.114 [29-Feb-1992] following two-month
 * major overhaul and compilation testing on numerous machines.
 *
 * Revision 1.2  1992/02/29  19:42:20  beebe
 * Update for version 3.0.114 [29-Feb-1992] following two-month
 * major overhaul and compilation testing on numerous machines.
 *
 * Revision 1.1  1992/02/29  19:13:22  beebe
 * Initial revision
 *
 * Revision 1.1  1992/02/29  19:13:22  beebe
 * Initial revision
 *
 */

/***********************************************************************
** Several standard UNIX library functions do not work properly with VMS
** C, or are not implemented:
**
**	exit()		-- wrong conventions for return code
**	fseek()		-- fails on record-oriented files
**	ftell()		-- fails on record-oriented files
**	getchar()	-- waits for <CR> to be typed
**	getenv()	-- colon- and case-sensitive
**	tell()		-- not implemented
**	ungetc()	-- fails for any character with high-order bit set
**	unlink()	-- not implemented (equivalent available)
**
** The  file  VAXVMS.C  contains   workarounds;  it  must  be   compiled
** separately and loaded with each of the DVI drivers.
***********************************************************************/

#include <jpidef.h>			/* need for getjpi() in openfont() */

#define DVIHELP		"help dvi\nor\ntype tex_inputs:dvi.hlp"

#ifndef ENV_SYSPATH			/* can override at compile time */
#define ENV_SYSPATH	"SYS$SYSTEM"
#endif /* ENV_SYSPATH */

#ifdef ERRSUFFIX
#undef ERRSUFFIX
#endif /* ERRSUFFIX */

#define ERRSUFFIX	"err;-1"	/* to force new generation */

#define FILE_CNT(fp)	(*fp)->_cnt
#define FILE_BASE(fp)	(*fp)->_base
#define FILE_PTR(fp)	(*fp)->_ptr

#ifndef FONTFMT				/* can be set at compile time */
#define FONTFMT "%n.%dpk;[%d]%n.pk;%n.%dgf;[%d]%n.gf;%n.%mpxl;[%m]%n.pxl;\
%n.vf;%n.tfm"
#endif /* FONTFMT */

#define FSEEK		vms_fseek

#ifndef FSMAPFILE			/* can be set at compile time */
#define FSMAPFILE	"texfiles.map"
#endif /* FSMAPFILE */

#define FTELL		vms_ftell
#define GETENV		vms_getenv
#define HOST_WORD_SIZE	32	/* must be 32 or larger -- used in */
				/* signex to pack 8-bit bytes back */
				/* into integer values, and in dispchar */
				/* and fillrect for managing character */
				/* raster storage. */

#ifndef PSMAPFILE			/* can be set at compile time */
#define PSMAPFILE	"psfonts.map"
#endif /* PSMAPFILE */

#ifndef PS_MAXWIDTH
#define PS_MAXWIDTH	72
#endif /* PS_MAXWIDTH */

#ifndef PS_SHORTLINES
#define PS_SHORTLINES	1		/* VMS has trouble with long lines */
#endif /* PS_SHORTLINES */

#define READ		vms_read	/* ordinary read() returns only one */
					/* disk block at each call */

#ifdef REWIND
#undef REWIND
#endif /* REWIND */

#define REWIND(fp)	(void)rewind(fp)/* must NOT get vms_fseek version */

#define SEP_COMP " ;,|"	/* separators between filename components */
#define SEP_PATH ":]"	/* separators between directory path and filename */
			/* first char is what we default to */

#ifndef SUBEXT				/* can be set at compile time */
#define SUBEXT		".sub"
#endif /* SUBEXT */

#ifndef SUBNAME				/* can be set at compile time */
#define SUBNAME		"texfonts"
#endif /* SUBNAME */

#ifndef TEXFONTS			/* can be set at compile time */
#define TEXFONTS	ENV_TEXFONTS
#endif /* TEXFONTS */

#ifndef TEXINPUTS			/* can be set at compile time */
#define TEXINPUTS	ENV_TEXINPUTS
#endif /* TEXINPUTS */

#ifndef TFMFMT				/* can be set at compile time */
#define TFMFMT		"%n.tfm"
#endif /* TFMFMT */

#define UNGETC		vms_ungetc

/* CACHE_FONTS cannot be implemented  yet.  The code  works, but the
calls to FSEEK() (vms_seek) result in _filbuf() being called to refill
the buffer, obviating the pre-buffering.  Additional code in case 0 of
vms_seek() can probably be developed to avoid this, but I have run out
of time for now. */

#endif /* OSVAXVMS_H_DEFINED_ */
