/* -*-C-*- unixlib.h */
/*-->unixlib*/
/**********************************************************************/
/******************************* unixlib ******************************/
/**********************************************************************/

/* $Id: unixlib.h,v 1.15 1992/10/08 01:42:01 beebe Exp beebe $
 * $Log: unixlib.h,v $
 * Revision 1.15  1992/10/08  01:42:01  beebe
 * Update for C++.
 *
 * Revision 1.14  1992/09/26  13:07:54  beebe
 * Suppress declaration of delete() if running under C++ compiler, since
 * it is a reserved word in that language.
 *
 * Revision 1.13  1992/07/10  18:01:56  beebe
 * Add Convex and HPPA support.
 * Add function prototypes for functions missing in PC DOS.
 *
 * Revision 1.12  1992/03/23  15:58:21  beebe
 * Add function prototype for fileno for __LCC__ (ULTRIX with lcc).
 *
 * Revision 1.11  1992/03/16  19:48:20  beebe
 * Add support for NeXT.
 *
 * Revision 1.10  1992/03/12  03:03:05  beebe
 * *** empty log message ***
 *
 * Revision 1.10  1992/03/12  03:03:05  beebe
 * *** empty log message ***
 *
 * Revision 1.9  1992/03/06  19:38:15  beebe
 * *** empty log message ***
 *
 * Revision 1.8  1992/03/06  16:43:07  beebe
 * *** empty log message ***
 *
 * Revision 1.7  1992/03/06  14:58:06  beebe
 * Complete two-month long development of version 3.0.114.  See
 * 00revhst.txt for details.
 *
 * Revision 1.6  1992/03/01  01:28:38  beebe
 * *** empty log message ***
 *
 * Revision 1.5  1992/02/29  19:42:20  beebe
 * Update for version 3.0.114 [29-Feb-1992] following two-month
 * major overhaul and compilation testing on numerous machines.
 *
 * Revision 1.4  1992/01/22  02:37:14  beebe
 * Initial revision.
 *
 * Revision 1.3  1992/01/22  02:04:26  beebe
 * Add Revision Control System keyword comments.
 *
 * Revision 1.3  1992/01/22  02:04:26  beebe
 * Add Revision Control System keyword comments.
 *
 */

/***********************************************************************

This file provides function prototypes for UNIX library functions that
are usually not declared in <stdio.h> or other commonly-used include
files.  Several UNIX systems do not yet have Standard C conformant
compilers and libraries, but GNU gcc offers at least the compiler part
(no GNU C library is yet available on UNIX; the host C library is used
instead), and it can be asked to check argument passing and identify
functions lacking prototype declarations.

This file requires definitions of fpos_t and size_t; both are provided
by "os.h" (included automatically if needed).

POSIX-compliant UNIX implementations have a catch-all unistd.h file
that declares run-time library functions.  When it is available and in
addition, has full function prototypes, we use it, and then patch up
its deficiencies.  Whenever unistd.h is included, the major portion of
this file is omitted by defining UNIXLIB_H_DEFINED_.  Regrettably,
many systems have been found to have deficient unistd.h files.

To facilitate identifying functions for which prototypes are missing
in UNIX system header files, this file should be accompanied by
funtst.c and funtst.sh.  The former is a C (and C++) file that can be
compiled to determine problems.  The latter is a shell script that
will make funtst.o and funtst.i, and then apply search the .i file for
undeclared functions that should have prototypes in this file.

***********************************************************************/

#ifndef UNIXLIB_H_DEFINED_

#ifndef OS_H_DEFINED_
#include "os.h"
#endif /* OS_H_DEFINED_ */

#include "xtypes.h"

/*====================================================================*/

#if (_AIX && (_AIX370 || ps2))
/* IBM 3090 and PS/2 have identical include files */
#include <unistd.h>
#if !__cplusplus
int		_filbuf ARGS((FILE *fp_));
int		_flsbuf ARGS((unsigned char c_, FILE *fp_));
int		access ARGS((const char *file_spec_, int mode_));
int		close ARGS((int file_desc_));
int		creat ARGS((const char *file_spec_, unsigned int mode_, ...));
int		delete ARGS((const char *file_spec_));
int		dup ARGS((int file_desc_));
int		dup2 ARGS((int fd_1_, int fd_2_));
char		*fgetname ARGS((FILE *file_ptr_, char *buffer_, ...));
int		fgetpos ARGS((FILE *file_ptr_, fpos_t *position_));
int		fsetpos ARGS((FILE *file_ptr_, const fpos_t *position_));
char		*getcwd ARGS((char *name_, int size_));
char		*getname ARGS((int file_desc_, char *buffer_, ...));
int		getw ARGS((FILE *file_ptr_));
int		ioctl ARGS((int file_desc_, int request_, ...));
int		isapipe ARGS((int file_desc_));
int		isatty ARGS((int file_desc_));
int		lseek ARGS((int file_desc_, int offset_, int direction_));
int		open ARGS((const char *file_spec_, int flags_, ...));
int		putw ARGS((int integer_, FILE *file_ptr_));
int		read ARGS((int file_desc_, void *buffer_, size_t nbytes_));
unsigned int	sleep ARGS((unsigned int seconds_));
int		system ARGS((const char *command_));
int		tell ARGS((int file_desc_));
				/* obsolete; use lseek(file_desc_, 0L, 1) */
char		*ttyname ARGS((int file_desc_));
int		unlink ARGS((const char *path_));
unsigned int	usleep ARGS((unsigned int microseconds_)); /* in Sun OS */
int		utime ARGS((const char *path_, time_t times_[2]));
int		write ARGS((int file_desc_, const void *buffer_,
		    size_t nbytes_));
#endif /* __cplusplus */
#define UNIXLIB_H_DEFINED_
#endif /* (_AIX && (_AIX370 || ps2)) */

/*====================================================================*/

#if (_AIX && _IBMR2)
					/* IBM RS/6000 AIX 3.1 and 3.2 */
#include <unistd.h>

/* creat() 2nd arg is mode_t, not unsigned int, and no 3rd or more args */
int		creat ARGS((const char *file_spec_, mode_t mode_));

#if !__cplusplus
		/* this function conflicts with C++ reserved word */
int		delete ARGS((const char *file_spec_));
#endif /* !__cplusplus */

int		getw ARGS((FILE *file_ptr_));
int		ioctl ARGS((int file_desc_, int request_, ...));
int		isapipe ARGS((int file_desc_));
int		open ARGS((const char *file_spec_, int flags_, ...));
int		putw ARGS((int integer_, FILE *file_ptr_));
int		system ARGS((const char *command_));
int		tell ARGS((int file_desc_));
				/* obsolete; use lseek(file_desc_, 0L, 1) */
unsigned int	usleep ARGS((unsigned int microseconds_)); /* in Sun OS */
int		utime ARGS((const char *path_, time_t times_[2]));
#define UNIXLIB_H_DEFINED_
#endif /* (_AIX && _IBMR2) */

/*====================================================================*/

#if __convex__
#include <unistd.h>
#define UNIXLIB_H_DEFINED_
#endif /* __convex__ */

/*====================================================================*/

#if __hppa
			/* HP-UX A.08.00 D 9000/850 */
#include <unistd.h>
#include <sys/types.h>			/* for mode_t definition */
#if !__cplusplus
int		_filbuf ARGS((FILE *fp_));
int		_flsbuf ARGS((unsigned char c_, FILE *fp_));

/* creat() 2nd arg is mode_t, not unsigned int, and no 3rd or more args */
int		creat ARGS((const char *file_spec_, mode_t mode_));

char		*cuserid ARGS((char *s_));
int		delete ARGS((const char *file_spec_));
FILE		*fdopen ARGS((int file_desc_, const char *a_mode_));
char		*fgetname ARGS((FILE *file_ptr_, char *buffer_, ...));
				/* getcwd: 2nd arg size_t instead of int */
char		*getcwd ARGS((char *name_, size_t size_));
char		*getlogin ARGS((void));
char		*getname ARGS((int file_desc_, char *buffer_, ...));
int		isapipe ARGS((int file_desc_));
int		open ARGS((const char *file_spec_, int flags_, ...));
int		system ARGS((const char *command_));
int		tell ARGS((int file_desc_));
				/* obsolete; use lseek(file_desc_, 0L, 1) */
char		*ttyname ARGS((int file_desc_));
unsigned int	usleep ARGS((unsigned int microseconds_)); /* in Sun OS */
#endif /* !__cplusplus */

#if _POSIX_SOURCE		/* compiling with c89 -D_POSIX_SOURCE */
int		getw ARGS((FILE *file_ptr_));
int		ioctl ARGS((int file_desc_, int request_, ...));
int		putw ARGS((int integer_, FILE *file_ptr_));
int		utime ARGS((const char *path_, const struct utimbuf *times_));
#endif /* _POSIX_SOURCE */

#define UNIXLIB_H_DEFINED_
#endif /* __hppa */

/*====================================================================*/

#if _IBMR2
#include <unistd.h>
char		*fgetname ARGS((FILE *file_ptr_, char *buffer_, ...));
char		*getname ARGS((int file_desc_, char *buffer_, ...));
#define UNIXLIB_H_DEFINED_
#endif /* _IBMR2 */

/*====================================================================*/

#if __NeXT__
#if !__cplusplus
/* We do not use libc.h, which otherwise has most of these, because
some declarations there are incorrect. */
int		access ARGS((const char *file_spec_, int mode_));
void		bzero ARGS((char *s_, int n_));
int		close ARGS((int file_desc_));
int		creat ARGS((const char *file_spec_, unsigned int mode_, ...));
char		*cuserid ARGS((char *s_));
int		delete ARGS((const char *file_spec_));
int		dup ARGS((int file_desc_));
int		dup2 ARGS((int fd_1_, int fd_2_));
char		*fgetname ARGS((FILE *file_ptr_, char *buffer_, ...));
char		*getname ARGS((int file_desc_, char *buffer_, ...));
char		*getlogin ARGS((void));
int		getw ARGS((FILE *file_ptr_));
char		*getwd ARGS((char *name_));
int		isapipe ARGS((int file_desc_));
int		ioctl ARGS((int file_desc_, int request_, ...));
int		isapipe ARGS((int file_desc_));
int		isatty ARGS((int file_desc_));
int		lseek ARGS((int file_desc_, int offset_, int direction_));
int		open ARGS((const char *file_spec_, int flags_, ...));

int		putw ARGS((int integer_, FILE *file_ptr_));
int		read ARGS((int file_desc_, void *buffer_, size_t nbytes_));
unsigned int	sleep ARGS((unsigned int seconds_));
int		system ARGS((const char *command_));
int		tell ARGS((int file_desc_));
				/* obsolete; use lseek(file_desc_, 0L, 1) */
char		*ttyname ARGS((int file_desc_));
int		unlink ARGS((const char *path_));
unsigned int	usleep ARGS((unsigned int microseconds_)); /* in Sun OS */
int		utime ARGS((const char *path_, time_t times_[2]));
int		write ARGS((int file_desc_, const void *buffer_,
		    size_t nbytes_));
#endif /* !__cplusplus */
#define UNIXLIB_H_DEFINED_
#endif /* __NeXT__ */

/*====================================================================*/

#if __sgi
#include <unistd.h>
#include <fcntl.h>			/* for creat() and open() */

#if __cplusplus
extern "C" 
{			/* missing from system include files */
int		ioctl ARGS((int file_desc_, int request_, ...));    
};
#else /* NOT __cplusplus */
void		bzero ARGS((char *s_, int n_));
int		delete ARGS((const char *file_spec_));
char		*fgetname ARGS((FILE *file_ptr_, char *buffer_, ...));

#if __LCC__
int		fileno ARGS((FILE *fp_));
#endif /* __LCC__ */

char		*getname ARGS((int file_desc_, char *buffer_, ...));
int		getw ARGS((FILE *file_ptr_));
int		ioctl ARGS((int file_desc_, int request_, ...));
int		isapipe ARGS((int file_desc_));
int		putw ARGS((int integer_, FILE *file_ptr_));
int		tell ARGS((int file_desc_));
unsigned int	usleep ARGS((unsigned int microseconds_)); /* in Sun OS */
#endif /* __cplusplus */

#define UNIXLIB_H_DEFINED_
#endif /* __sgi */

/*====================================================================*/

#if sun && __GNUC__
#include <fcntl.h>			/* for creat() and open() */
#if __cplusplus
extern "C"
{
int		access ARGS((const char *file_spec_, int mode_));
		/* g++ 2.0: bzero() arg 1 is void* instead of char* */
void		bzero ARGS((void *s_, int n_));
int		close ARGS((int file_desc_));
int		dup ARGS((int file_desc_));
int		dup2 ARGS((int fd_1_, int fd_2_));
char		*fgetname ARGS((FILE *file_ptr_, char *buffer_, ...));
int		fgetpos ARGS((FILE *file_ptr_, fpos_t *position_));
int		fprintf ARGS((FILE *file_ptr_, const char *format_spec_,
		    ...));
int		fsetpos ARGS((FILE *file_ptr_, const fpos_t *position_));
char		*getname ARGS((int file_desc_, char *buffer_, ...));
int		ioctl ARGS((int file_desc_, int request_, ...));
int		isapipe ARGS((int file_desc_));
int		isatty ARGS((int file_desc_));
int		lseek ARGS((int file_desc_, int offset_, int direction_));
int		read ARGS((int file_desc_, void *buffer_, size_t nbytes_));
int		remove ARGS((const char *file_spec_));
int		rename ARGS((const char *old_file_spec_,
		    const char *new_file_spec_));
unsigned int	sleep ARGS((unsigned int seconds_));
int		system ARGS((const char *command_));
int		tell ARGS((int file_desc_));
				/* obsolete; use lseek(file_desc_, 0L, 1) */
char		*ttyname ARGS((int file_desc_));
int		unlink ARGS((const char *path_));
int		utime ARGS((const char *path_, time_t times_[2]));
int		write ARGS((int file_desc_, const void *buffer_,
		    size_t nbytes_));
}
#else
int		_filbuf ARGS((FILE *fp_));
int		_flsbuf ARGS((unsigned char c_, FILE *fp_));
int		access ARGS((const char *file_spec_, int mode_));
void		bzero ARGS((char *s_, int n_));
int		close ARGS((int file_desc_));
int		delete ARGS((const char *file_spec_));
int		dup ARGS((int file_desc_));
int		dup2 ARGS((int fd_1_, int fd_2_));
int		fclose ARGS((FILE *file_ptr_));
int		fflush ARGS((FILE *file_ptr_));
int		fgetc ARGS((FILE *file_ptr_));
char		*fgetname ARGS((FILE *file_ptr_, char *buffer_, ...));
int		fgetpos ARGS((FILE *file_ptr_, fpos_t *position_));
int		fprintf ARGS((FILE *file_ptr_, const char *format_spec_,
		    ...));
int		fputc ARGS((int character_, FILE *file_ptr_));
int		fputs ARGS((const char *str_, FILE *file_ptr_));
size_t		fread ARGS((void *ptr_, size_t size_of_item_,
		    size_t number_items_, FILE *file_ptr_));
int		fscanf ARGS((FILE *file_ptr_, const char *format_spec_, ...));
int		fseek ARGS((FILE *file_ptr_, long offset_, int direction_));
int		fsetpos ARGS((FILE *file_ptr_, const fpos_t *position_));
size_t		fwrite ARGS((const void *ptr_, size_t size_of_item_,
		     size_t number_items_, FILE *file_ptr_));
char		*getname ARGS((int file_desc_, char *buffer_, ...));
int		getw ARGS((FILE *file_ptr_));
int		ioctl ARGS((int file_desc_, int request_, ...));
int		isapipe ARGS((int file_desc_));
int		isatty ARGS((int file_desc_));
int		lseek ARGS((int file_desc_, int offset_, int direction_));

#if !HAVE_OPEN_DCL
int		open ARGS((const char *file_spec_, int flags_, ...));
#endif /* !HAVE_OPEN_DCL */

void		perror ARGS((const char *s_));
int		printf ARGS((const char *format_spec_, ...));
int		puts ARGS((const char *str_));
int		putw ARGS((int integer_, FILE *file_ptr_));
int		read ARGS((int file_desc_, void *buffer_, size_t nbytes_));
int		remove ARGS((const char *file_spec_));
int		rename ARGS((const char *old_file_spec_,
		    const char *new_file_spec_));
void		rewind ARGS((FILE *file_ptr_));
int		scanf ARGS((const char *format_spec_, ...));
void		setbuf ARGS((FILE *file_ptr_, char *buffer_));
int		setvbuf ARGS((FILE *file_ptr_, char *buffer_, int type_,
		    size_t size_));
unsigned int	sleep ARGS((unsigned int seconds_));
int		sscanf ARGS((const char *str_, const char *format_spec_,
		    ...));
int		system ARGS((const char *command_));
int		tell ARGS((int file_desc_));
				/* obsolete; use lseek(file_desc_, 0L, 1) */
char		*ttyname ARGS((int file_desc_));
int		ungetc ARGS((int character_, FILE *file_ptr_));
int		unlink ARGS((const char *path_));
unsigned int	usleep ARGS((unsigned int microseconds_)); /* in Sun OS */
int		utime ARGS((const char *path_, time_t times_[2]));
int		vfprintf ARGS((FILE *file_ptr_, const char *format_,
		    void *arg_));
int		vprintf ARGS((const char *format_, void *arg_));
int		vsprintf ARGS((char *s_, const char *format_, void *arg_));
int		write ARGS((int file_desc_, const void *buffer_,
		    size_t nbytes_));
#endif /* __cplusplus */
#define UNIXLIB_H_DEFINED_
#endif /* sun && __GNUC__ */

/*====================================================================*/

#if (sun && __CC__ && !__cplusplus)
					/* native Sun compiler: cc */
#include <unistd.h>
void		bzero ARGS((char *s_, int n_));
int		creat ARGS((const char *file_spec_, unsigned int mode_, ...));
int		delete ARGS((const char *file_spec_));
FILE		*fdopen ARGS((int file_desc_, const char *a_mode_));
int		_filbuf ARGS((FILE *fp_));
int		_flsbuf ARGS((unsigned char c_, FILE *fp_));
char		*fgetname ARGS((FILE *file_ptr_, char *buffer_, ...));
int		fgetpos ARGS((FILE *file_ptr_, fpos_t *position_));
int		fsetpos ARGS((FILE *file_ptr_, const fpos_t *position_));
char		*getlogin ARGS((void));
char		*getname ARGS((int file_desc_, char *buffer_, ...));
int		getw ARGS((FILE *file_ptr_));
int		ioctl ARGS((int file_desc_, int request_, ...));
int		isapipe ARGS((int file_desc_));
int		open ARGS((const char *file_spec_, int flags_, ...));
int		putw ARGS((int integer_, FILE *file_ptr_));
int		setvbuf ARGS((FILE *file_ptr_, char *buffer_, int type_,
		    size_t size_));
int		system ARGS((const char *command_));
int		tell ARGS((int file_desc_));
				/* obsolete; use lseek(file_desc_, 0L, 1) */
char		*tmpnam ARGS((char *name_));
int		unlink ARGS((const char *path_));
unsigned int	usleep ARGS((unsigned int microseconds_)); /* in Sun OS */
int		utime ARGS((const char *path_, time_t times_[2]));
int		vfprintf ARGS((FILE *file_ptr_, const char *format_,
		    void *arg_));
int		vprintf ARGS((const char *format_, void *arg_));
int		vsprintf ARGS((char *s_, const char *format_, void *arg_));

#define UNIXLIB_H_DEFINED_
#endif /* (sun && __CC__ && !__cplusplus) */

/*====================================================================*/

#if (sun && __ACC__ && !__cplusplus)
					/* native ISO/ANSI Sun compiler: acc */
#include <unistd.h>
void		bzero ARGS((char *s_, int n_));
int		creat ARGS((const char *file_spec_, unsigned int mode_, ...));
int		delete ARGS((const char *file_spec_));
FILE		*fdopen ARGS((int file_desc_, const char *a_mode_));
int		_filbuf ARGS((FILE *fp_));
int		_flsbuf ARGS((unsigned char c_, FILE *fp_));
char		*fgetname ARGS((FILE *file_ptr_, char *buffer_, ...));
char		*getname ARGS((int file_desc_, char *buffer_, ...));
int		getw ARGS((FILE *file_ptr_));
int		ioctl ARGS((int file_desc_, int request_, ...));
int		isapipe ARGS((int file_desc_));
int		open ARGS((const char *file_spec_, int flags_, ...));
int		putw ARGS((int integer_, FILE *file_ptr_));
int		system ARGS((const char *command_));
int		tell ARGS((int file_desc_));
				/* obsolete; use lseek(file_desc_, 0L, 1) */
char		*tmpnam ARGS((char *name_));
unsigned int	usleep ARGS((unsigned int microseconds_)); /* in Sun OS */
int		utime ARGS((const char *path_, time_t times_[2]));

#define UNIXLIB_H_DEFINED_
#endif /* (sun && __ACC__ && !__cplusplus) */

/*====================================================================*/

#if __TURBOC__
#include <io.h>				/* for low-level I/O declarations */
#if !__cplusplus
void		bzero ARGS((char *s_, int n_));
char		*cuserid ARGS((char *s_));
		/* this function conflicts with C++ reserved word */
int		delete ARGS((const char *file_spec_));

#if (__TURBOC__ < 0x0400)
FILE		*fdopen ARGS((int file_desc_, const char *a_mode_));
#endif /* (__TURBOC__ < 0x0400) */

char		*fgetname ARGS((FILE *file_ptr_, char *buffer_, ...));
char		*getcwd ARGS((char *name_, int size_));
char		*getlogin ARGS((void));
char		*getname ARGS((int file_desc_, char *buffer_, ...));
int		getw ARGS((FILE *file_ptr_));
int		isapipe ARGS((int file_desc_));
int		putw ARGS((int integer_, FILE *file_ptr_));

#if (__TURBOC__ < 0x0400)
unsigned int	sleep ARGS((unsigned int seconds_));
#endif /* (__TURBOC__ < 0x0400) */

int		system ARGS((const char *command_));
char		*ttyname ARGS((int file_desc_));
unsigned int	usleep ARGS((unsigned int microseconds_)); /* in Sun OS */
int		utime ARGS((const char *path_, time_t times_[2]));
#endif /* !__cplusplus */
#define UNIXLIB_H_DEFINED_
#endif /* __TURBOC__ */

/*====================================================================*/

#if ultrix
#include <sys/stat.h>			/* need for struct stat definition */

#if __cplusplus
#include <unistd.h>
#else /* NOT __cplusplus */
int		access ARGS((const char *file_spec_, int mode_));
void		bzero ARGS((char *s_, int n_));
int		close ARGS((int file_desc_));
int		creat ARGS((const char *file_spec_, unsigned int mode_));
char		*cuserid ARGS((char *s_));
int		delete ARGS((const char *file_spec_));
int		dup ARGS((int file_desc_));
int		dup2 ARGS((int fd_1_, int fd_2_));
FILE		*fdopen ARGS((int fildes_, char *type_));

#if __LCC__
int		fileno ARGS((FILE *fp_));
#endif /* __LCC__ */

char		*fgetname ARGS((FILE *file_ptr_, char *buffer_, ...));

#if __GNUC__
int		fprintf ARGS((FILE *file_ptr_, const char *format_spec_,
		    ...));
#endif /* __GNUC__ */

int		fstat ARGS((int file_desc_, struct stat *buffer_));
char		*getcwd ARGS((char *name_, int size_));
char		*getlogin ARGS((void));
char		*getname ARGS((int file_desc_, char *buffer_, ...));
int		getw ARGS((FILE *file_ptr_));
int		ioctl ARGS((int file_desc_, int request_, ...));
int		isapipe ARGS((int file_desc_));
int		isatty ARGS((int file_desc_));
int		lseek ARGS((int file_desc_, int offset_, int direction_));
int		open ARGS((const char *file_spec_, int flags_, int mode_));
int		putw ARGS((int integer_, FILE *file_ptr_));
int		read ARGS((int file_desc_, void *buffer_, size_t nbytes_));
unsigned int	sleep ARGS((unsigned int seconds_));
int		system ARGS((const char *command_));
int		tell ARGS((int file_desc_));
				/* obsolete; use lseek(file_desc_, 0L, 1) */
char		*ttyname ARGS((int file_desc_));
int		unlink ARGS((const char *path_));
unsigned int	usleep ARGS((unsigned int microseconds_)); /* in Sun OS */
int		utime ARGS((const char *path_, time_t times_[2]));
int		write ARGS((int file_desc_, const void *buffer_,
		    size_t nbytes_));
#endif /* __cplusplus */

#if (__GNUC__ && __cplusplus)
extern "C"
{
int		fprintf ARGS((FILE *file_ptr_, const char *format_spec_,
		    ...));
int		utime ARGS((const char *path_, time_t times_[2]));
}
#endif /* (__GNUC__ && __cplusplus) */

#define UNIXLIB_H_DEFINED_
#endif /* ultrix */

/*====================================================================*/

#if    OS_PCDOS

#if !__cplusplus
char		*cuserid ARGS((char *s_));
int		utime ARGS((const char *path_, time_t times_[2]));
#endif /* !__cplusplus */

#define UNIXLIB_H_DEFINED_
#endif /* OS_PCDOS */


/*====================================================================*/

#if    OS_VAXVMS

#if !__cplusplus
#include <unixlib.h>
#include <unixio.h>
void		bzero ARGS((char *s_, int n_));
char		*cuserid ARGS((char *s_));
char		*getlogin ARGS((void));
int		ioctl ARGS((int file_desc_, int request_, ...));
unsigned int	sleep ARGS((unsigned int seconds_));
int		system ARGS((const char *command_));
int		tell ARGS((int file_desc_));
				/* obsolete; use lseek(file_desc_, 0L, 1) */
char		*ttyname ARGS((void));	/* should be int file_desc_ */
					/* but VMS lacks it */
int		unlink ARGS((const char *path_));
unsigned int	usleep ARGS((unsigned int microseconds_)); /* in Sun OS */
int		utime ARGS((const char *path_, time_t times_[2]));
#endif /* !__cplusplus */

#define UNIXLIB_H_DEFINED_
#endif /* OS_VAXVMS */

/*====================================================================*/

#if __cplusplus
extern "C" {
#endif /* __cplusplus */

#if HAVE_GETHOSTNAME
#if !HAVE_GETHOSTNAME_DCL
int		gethostname ARGS((char *name_, int namelen_));
#endif /* !HAVE_GETHOSTNAME_DCL */
#else /* NOT HAVE_GETHOSTNAME */
#define	gethostname(name_,namelen_)	((name_), (namelen_), EOF)
#endif /* !HAVE_GETHOSTNAME */

#if HAVE_GETLOGIN
#if !HAVE_GETLOGIN_DCL
char		*getlogin ARGS((void));
#endif /* !HAVE_GETLOGIN_DCL */
#else /* NOT HAVE_GETLOGIN */
#define getlogin()	((char*)NULL)
#endif /* HAVE_GETLOGIN */

#if HAVE_GETCWD && !HAVE_GETCWD_DCL
char		*getcwd ARGS((char *name_, int size_));
#endif /* HAVE_GETCWD && !HAVE_GETCWD_DCL */

#if HAVE_GETWD && !HAVE_GETWD_DCL
char		*getwd ARGS((char *name_));
#endif /* HAVE_GETWD && !HAVE_GETWD_DCL */

#if !HAVE_GETWD
/* Posix defines getcwd() but not getwd(), while older UNIX systems
have only getwd().  For other systems, we define getwd() in terms of
getcwd(). */
#define getwd(name_) (char*)getcwd((char*)(name_),(int)sizeof(name_))
#endif /* !HAVE_GETWD */

#if (HAVE_GETWD && !HAVE_GETCWD)
#define getcwd(name_,size_)	(char*)getwd((char*)name_)
#endif /* (HAVE_GETWD && !HAVE_GETCWD) */

#if    (!HAVE_GETCWD && !HAVE_GETWD)
#define getcwd(name_,size_)		((name_), (size_), (char*)NULL)
#endif /* (!HAVE_GETCWD && !HAVE_GETWD) */

#if __cplusplus
}
#endif /* __cplusplus */

/*====================================================================*/

#ifndef UNIXLIB_H_DEFINED_
#define UNIXLIB_H_DEFINED_

#if    OS_UNIX
#if __cplusplus
extern "C"
{
#include <osfcn.h>			/* needed for access() */
}
#else /* NOT __cplusplus */
#include "xstat.h"

/* Low-level I/O functions */

int		access ARGS((const char *file_spec_, int mode_));
int		close ARGS((int file_desc_));
int		creat ARGS((const char *file_spec_, unsigned int mode_, ...));
char		*cuserid ARGS((char *s_));
int		delete ARGS((const char *file_spec_));
int		dup ARGS((int file_desc_));
int		dup2 ARGS((int fd_1_, int fd_2_));

#if sun || (hp300 && __GNUC__) || (mips && __GNUC__)
				/* <stdio.h> uses these without prototypes */
int		_filbuf ARGS((FILE *fp_));
int		_flsbuf ARGS((unsigned char c_, FILE *fp_));
#endif /* sun || (hp300 && __GNUC__)  || (mips && __GNUC__) */

int		fstat ARGS((int file_desc_, struct stat *buffer_));
char		*getname ARGS((int file_desc_, char *buffer_, ...));
int		ioctl ARGS((int file_desc_, int request_, ...));
int		isapipe ARGS((int file_desc_));
int		isatty ARGS((int file_desc_));
int		lseek ARGS((int file_desc_, int offset_, int direction_));

#if !HAVE_OPEN_DCL
int		open ARGS((const char *file_spec_, int flags_, ...));
#endif /* !HAVE_OPEN_DCL */

int		read ARGS((int file_desc_, void *buffer_, size_t nbytes_));
int		remove ARGS((const char *file_spec_));
int		rename ARGS((const char *old_file_spec_,
		    const char *new_file_spec_));
int		stat ARGS((const char *file_spec_, struct stat *buffer_));
char		*ttyname ARGS((int file_desc_));
int		write ARGS((int file_desc_, const void *buffer_,
		    size_t nbytes_));

/* High-level I/O functions.  It appears that library functions of type
int usually are not given prototypes in UNIX stdio.h. */

int		fclose ARGS((FILE *file_ptr_));
FILE		*fdopen ARGS((int file_desc_, const char *a_mode_));
int		fflush ARGS((FILE *file_ptr_));
int		fgetc ARGS((FILE *file_ptr_));
char		*fgetname ARGS((FILE *file_ptr_, char *buffer_, ...));
int		fgetpos ARGS((FILE *file_ptr_, fpos_t *position_));
char		*fgets ARGS((char *str_, int maxchar_, FILE *file_ptr_));

#if !__GNUC__	/* complains of conflict with stdio.h definition */
#if !ardent
FILE		*fopen ARGS((const char *filespec_, const char *a_mode_,
		    ...));
#endif /* !ardent */
#endif /* !__GNUC__ */

int		fprintf ARGS((FILE *file_ptr_, const char *format_spec_,
		    ...));
int		fputc ARGS((int character_, FILE *file_ptr_));
int		fputs ARGS((const char *str_, FILE *file_ptr_));

#if    KCC_20
int		fread ARGS((void *ptr_, size_t size_of_item_,
		    size_t number_items_, FILE *file_ptr_));
#else /* NOT KCC_20 */
#if !ardent
size_t		fread ARGS((void *ptr_, size_t size_of_item_,
		    size_t number_items_, FILE *file_ptr_));
#endif /* !ardent */
#endif /* KCC_20 */

#if !__GNUC__	/* complains of conflict with stdio.h definition */
#if !ardent
FILE		*freopen ARGS((const char *file_spec_, const char *a_mode_,
		    FILE *file_ptr_, ...));
#endif /* !ardent */
#endif /* !__GNUC__ */

int		fscanf ARGS((FILE *file_ptr_, const char *format_spec_, ...));
int		fseek ARGS((FILE *file_ptr_, long offset_, int direction_));
int		fsetpos ARGS((FILE *file_ptr_, const fpos_t *position_));
long		ftell ARGS((FILE *file_ptr_));

#if    KCC_20
int		fwrite ARGS((const void *ptr_, size_t size_of_item_,
		     size_t number_items_, FILE *file_ptr_));
#else /* NOT KCC_20 */
#if !ardent
size_t		fwrite ARGS((const void *ptr_, size_t size_of_item_,
		     size_t number_items_, FILE *file_ptr_));
#endif /* !ardent */
#endif /* KCC_20 */

char		*gets ARGS((char *str_));
int		getw ARGS((FILE *file_ptr_));
int		printf ARGS((const char *format_spec_, ...));
int		puts ARGS((const char *str_));
int		putw ARGS((int integer_, FILE *file_ptr_));

#if    OS_VAXVMS
int		rewind ARGS((FILE *file_ptr_));
					/* library declaration wrong, sigh.. */
#else  /* NOT OS_VAXVMS */
void		rewind ARGS((FILE *file_ptr_));
#endif /* OS_VAXVMS */

int		scanf ARGS((const char *format_spec_, ...));

#if !ardent
void		setbuf ARGS((FILE *file_ptr_, char *buffer_));
int		setvbuf ARGS((FILE *file_ptr_, char *buffer_, int type_,
		    size_t size_));
#endif /* ardent */

#if ultrix
char		*sprintf ARGS((char *str_, const char *format_spec_, ...));
#else /* NOT ultrix */
#if apollo
char		*sprintf ARGS((char *str_, char *format_spec_, ...));
#else /* NOT apollo */
#if sun
char		*sprintf ARGS((char *str_, const char *format_spec_, ...));
#else /* NOT sun */
int		sprintf ARGS((char *str_, const char *format_spec_, ...));
#endif /* sun */
#endif /* apollo */
#endif /* ultrix */

int		sscanf ARGS((const char *str_, const char *format_spec_,
		    ...));
FILE		*tmpfile ARGS((void));
char		*tmpnam ARGS((char *name_));
int		ungetc ARGS((int character_, FILE *file_ptr_));

#if !ardent
int		vfprintf ARGS((FILE *file_ptr_, const char *format_,
		    void *arg_));
int		vprintf ARGS((const char *format_, void *arg_));
int		vsprintf ARGS((char *s_, const char *format_, void *arg_));
#endif /* !ardent */

/* miscellaneous library functions */

void		bzero ARGS((char *s_, int n_));
void		perror ARGS((const char *s_));
unsigned int	sleep ARGS((unsigned int seconds_));
int		system ARGS((const char *command_));
int		tell ARGS((int file_desc_));
				/* obsolete; use lseek(file_desc_, 0L, 1) */
time_t		time ARGS((time_t *time_location_));
int		unlink ARGS((const char *path_));
unsigned int	usleep ARGS((unsigned int microseconds_)); /* in Sun OS */
int		utime ARGS((const char *path_, time_t times_[2]));
#endif /* __cplusplus */
#endif /* OS_UNIX */
#endif /* UNIXLIB_H_DEFINED_ */
#endif /* UNIXLIB_H_DEFINED_ */
