/* -*-C-*- xstring.h */
/**********************************************************************/
/****************************** string ********************************/
/**********************************************************************/

/* $Id: xstring.h,v 1.6 1992/10/08 01:42:01 beebe Exp beebe $
 * $Log: xstring.h,v $
 * Revision 1.6  1992/10/08  01:42:01  beebe
 * Update for C++.
 *
 * Revision 1.5  1992/07/10  18:08:22  beebe
 * Remove Lattice C support.
 * Change definition of NULL.
 *
 * Revision 1.4  1992/03/06  14:58:06  beebe
 * Complete two-month long development of version 3.0.114.  See
 * 00revhst.txt for details.
 *
 * Revision 1.3  1992/03/06  14:55:54  beebe
 * Complete two-month long development of version 3.0.114.  See
 * 00revhst.txt for details.
 *
 * Revision 1.3  1992/03/06  14:55:54  beebe
 * Complete two-month long development of version 3.0.114.  See
 * 00revhst.txt for details.
 *
 * Revision 1.3  1992/03/06  14:54:22  beebe
 * Complete two-month long development of version 3.0.114.  See
 *
 * Revision 1.2  1992/02/29  19:42:20  beebe
 * Update for version 3.0.114 [29-Feb-1992] following two-month
 * major overhaul and compilation testing on numerous machines.
 *
 */

#ifndef XSTRING_H_DEFINED_	/* file ignored if included more than once */
#define XSTRING_H_DEFINED_

#ifndef OS_H_DEFINED_
#include "os.h"
#endif /* OS_H_DEFINED_ */

/* Standard C, System V, and BSD 4.3 call this <string.h>.  BSD 4.1 called it
<strings.h> */

#if    STDC
#include <string.h>		/* get the host version */

#if __GNUG__
extern "C"
{
VOIDP		memmove ARGS((VOIDP dest_,  const VOIDP src_,  size_t n_));
	/* missing from /usr/local/lib/g++-include/string.h in g++ 2.0 */
};
#endif 


#if    !HAVE_MEMXXX_DCL
/* Some systems have these in memory.h, but without argument
declarations, and sometimes, with wrong return types.  We use the
Standard C declarations here, rather than using memory.h, because the
latter causes other conflicts that we wish to avoid.  */
VOIDP		memccpy ARGS((VOIDP dest_,  const VOIDP src_,  int c_,
		    size_t n_));	/* Extension to Standard C */
VOIDP		memchr	ARGS((const VOIDP s_,  int c_,  size_t n_));
int		memcmp	ARGS((const VOIDP s1_,  const VOIDP s2_,
		    size_t n_));
VOIDP		memcpy	ARGS((VOIDP dest_,  const VOIDP src_,  size_t n_));
int		memicmp ARGS((const VOIDP s1_,  const VOIDP s2_,
		    size_t n_));	/* Extension to Standard C */
VOIDP		memmove ARGS((VOIDP dest_,  const VOIDP src_,  size_t n_));
VOIDP		memset	ARGS((VOIDP s_,  int c_,  size_t n_));
#endif /* !HAVE_MEMXXX_DCL */

#else /* NOT STDC */

#include "xtypes.h"

/* Strictly, size_t must be defined in Standard C's string.h, but
since it is usually typedef'ed, e.g. "typedef long size_t" or "typedef
int size_t", sometimes with the unsigned attribute, we have no way of
checking here for a prior definition, so we can do nothing for it. */

#ifndef NULL
#if    KCC_20
/* has its own version in stdio.h */
#else  /* NOT KCC_20 */
#define NULL			((VOIDP) 0L)	/* this is SYSTEM-DEPENDENT */
#endif /* KCC_20 */
#endif /* NULL */

/* Some UNIX systems have the memxxx() functions in <memory.h>.
Standard C puts them in <string.h>. */

VOIDP		memccpy ARGS((VOIDP dest_,  const VOIDP src_,  int c_,
		    size_t n_));	/* Extension to Standard C */
VOIDP		memchr	ARGS((const VOIDP s_,  int c_,  size_t n_));
int		memcmp	ARGS((const VOIDP s1_,  const VOIDP s2_,
		    size_t n_));
VOIDP		memcpy	ARGS((VOIDP dest_,  const VOIDP src_,  size_t n_));
int		memicmp ARGS((const VOIDP s1_,  const VOIDP s2_,
		    size_t n_));	/* Extension to Standard C */
VOIDP		memmove ARGS((VOIDP dest_,  const VOIDP src_,  size_t n_));
VOIDP		memset	ARGS((VOIDP s_,  int c_,  size_t n_));
char		*strcat ARGS((char *s1_,  const char *s2_));
char		*strchr ARGS((const char *s_,  int character_));
int		strcmp ARGS((const char *s1_,  const char *s2_));
int		strcoll ARGS((const char *s1_, const char *s2_));
char		*strcpy ARGS((char *s1_,  const char *s2_));
size_t		strcspn ARGS((const char *s1_,  const char *s2_));
char		*strerror ARGS((int errnum_,  ...));
size_t		strlen ARGS((const char *s_));
char		*strncat ARGS((char *s1_,  const char *s2_,  size_t n_));
int		strncmp ARGS((const char *s1_,  const char *s2_,
		    size_t n_));
char		*strncpy ARGS((char *s1_,  const char *s2_,  size_t n_));
char		*strpbrk ARGS((const char *s1_,  const char *s2_));
char		*strrchr ARGS((const char *s_,  int character_));
size_t		strspn ARGS((const char *s1_,  const char *s2_));
char		*strstr ARGS((const char *s1_,  const char *s2_));
char		*strtok ARGS((char *s1_,  const char *s2_));
size_t		strxfrm ARGS((char *to_, const char *from_,
		    size_t maxsize_));
#endif /* STDC */

/* Define a few additional functions used in the DVI driver family */

char 		*strdup ARGS((const char * s_));
int		stricmp ARGS((const char *, const char *));
char		*stristr ARGS((const char *s_, const char *sub_));
int		strnicmp ARGS((const char *s1_, const char *s2_, size_t n_));

#endif /* XSTRING_H_DEFINED_ */
