#!/bin/sh
### ====================================================================
###  @UNIX-shell-file{
###     author          = "Nelson H. F. Beebe",
###     version         = "1.04",
###     date            = "26 July 1994",
###     time            = "11:52:52 MDT",
###     filename        = "bibextract.sh",
###     address         = "Center for Scientific Computing
###                        Department of Mathematics
###                        University of Utah
###                        Salt Lake City, UT 84112
###                        USA",
###     telephone       = "+1 801 581 5254",
###     FAX             = "+1 801 581 4148",
###     checksum        = "12070 108 495 4441",
###     email           = "beebe@math.utah.edu (Internet)",
###     codetable       = "ISO/ASCII",
###     keywords        = "",
###     supported       = "yes",
###     abstract        = "",
###     docstring       = "Extract a subset of one or more bibtex
###                        files according to a regular expression
###                        pattern given on the command line, writing
###                        them on stdout.
###
###                        The pattern should avoid upper-case
###                        letters; the matching will be against a
###                        lower-cased copy of the BibTeX entry, to
###                        make letter case insignificant.
###
###                        Usage:
###                             bibextract 'keyword-pat' 'regexp-pat' \
###                                bibtex-file(s) >new-bibtex-file
###
###                        If the keyword-pat pattern is empty,
###                        matching occurs against the entire
###                        bibliographic entry.
###
###                        Here are some examples:
###
###                        Extract all entries mentioning chaos in any field:
###
###                             bibextract "" "chaos" file(s) >new-bibtex-file
###
###                        Extract entries with names Brown or Smith
###                        occurring in either of the author or editor
###                        fields:
###
###                             bibextract "author|editor" "brown|smith" \
###                                 file(s) >new-bibtex-file
###
###                        Extract entries for titles containing the
###                        letter z anywhere after a vowel; note that
###                        single quotes are necessary to provide the
###                        necessary protection from shell expansion:
###
###                             bibextract "title" '[aeiou].*z' file(s) \
###                                 >new-bibtex-file
###
###                        The checksum field above contains a CRC-16
###                        checksum as the first value, followed by the
###                        equivalent of the standard UNIX wc (word
###                        count) utility output of lines, words, and
###                        characters.  This is produced by Robert
###                        Solovay's checksum utility.",
###  }
### ====================================================================

### Edit history (reverse chronological order):
### [22-Jul-1994]	1.04	Eliminate printbraceditem() in favor of
###				using collectbraceditem(), which now
###				checks for balanced braces to avoid
###				possibility of an infinite loop.
### [17-Jul-1994]	1.03	Revise to output only those @String{...}
###				entries that are actually used by the
###				matched entries.
### [30-Oct-1992]	1.02	Fix typographical error.
### [21-Oct-1992]       1.01    Update for public distribution.
### [08-May-1989]       1.00    Original version.

TMPFILE=/tmp/bibtextract.$$
LIBDIR=@LIBDIR@

trap '/bin/rm -f ${TMPFILE}' 2 1

# Make a new awk program with the patterns built in.  If tr is
# available, force the pattern into lower case, in case the user
# forgot.  Unfortunately, the Berkeley and AT&T tr programs take
# incompatible arguments.  We assume the AT&T style here.
if [ -f /bin/tr ]
then pattern=`echo $2 | /bin/tr '[A-Z]' '[a-z]'`
else pattern=$2
fi

/bin/sed    -e "sKEYWORD$1"\
            -e "sPATTERN$pattern"\
            <@LIBDIR@/bibextract.awk >${TMPFILE}

# Discard first 2 arguments (keyword-pat and regexp-pat)
shift
shift

# Extract the bibliography subset
nawk -f ${TMPFILE} $*

# discard our temporary file
/bin/rm -f ${TMPFILE}
