#include <stdio.h>
#if (__STDC__ || __cplusplus || c_plusplus)
#include <stdlib.h>
#endif /*  (__STDC__ || __cplusplus || c_plusplus) */
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#if !__NeXT__
#include <unistd.h>
#include <malloc.h>
#endif /* !__NeXT__ */

#if (__STDC__ || __cplusplus || c_plusplus)
#define VOID	void
#else /* NOT (__STDC__ || __cplusplus || c_plusplus) */
#define VOID
#endif /* (__STDC__ || __cplusplus || c_plusplus) */

#undef bcopy
#define bcopy(source,target,length) \
	memcpy((char*)(target),(const char*)(source),length)

#if sun
#if __cplusplus
extern "C" int	_filbuf(FILE *);	/* missing from stdio.h */
#if !__GNUC__
int	_flsbuf(unsigned char,FILE *);	/* missing from stdio.h */
#endif /* !__GNUC__ */
extern "C" int	_flsbuf(unsigned int, FILE *); /* missing from stdio.h */
extern "C" char	*tempnam(const char *, const char *);
					/* not defined by acc's stdio.h */
extern "C" int	waitpid(int, int *, int); /* not defined by any Sun .h file */
#else /* NOT __cplusplus */
int	_filbuf(FILE *);		/* missing from stdio.h */
#if !__GNUC__
int	_flsbuf(unsigned char,FILE *);	/* missing from stdio.h */
#endif /* !__GNUC__ */
char	*tempnam(const char *, const char *); /* not defined by acc's stdio.h */
int	waitpid(int, int *, int);	/* not defined by any Sun .h file */
#endif /* __cplusplus */
#endif /* sun */

#if DEBUG_MALLOC
			/* For dynamic memory debugging. */
			/* Note that the parens around free and malloc */
			/* are essential to prevent macro expansion in */
			/* ANSI/ISO Standard C and C++.  Erroneous */
			/* preprocessors will go into an infinite loop */
			/* (e.g. SunOS /usr/CC/sun4/cpp) */
#if sun
int malloc_debug(int level);
int malloc_verify(void);
#else /* NOT sun */
#define malloc_debug(level)	level
#define malloc_verify()		1
#endif /* sun */
#undef free
#undef malloc
#define free(ptr) (malloc_verify(), \
		fprintf(stderr,"line %d: free(%p)\n",(int)__LINE__,(ptr)), \
		(free)(ptr))
static void *p__;			/* for malloc() debugging */
#define malloc(s) (malloc_verify(),\
		   p__ = (malloc)(s),\
		   fprintf(stderr,"line %d: malloc(%ld) -> %p\n",\
			   (int)__LINE__,(s),(p__)),\
		   p__)
#endif /* DEBUG_MALLOC */

#if __NeXT__
static char* p__;
static char* q__;
/* NB: This is not a general definition of tempnam(), but works for
this program! */
#define tempnam(dir,pfx)	(p__ = tmpnam((char*)NULL), \
				 q__ = malloc(strlen(p__)+1), \
				 strcpy(q__,p__))
#include <libc.h>			/* for struct rusage definition */
#define waitpid(pid, statusp, options)	wait4((pid), (statusp), (options),\
					      (struct rusage*)0)
#endif /* __NeXT__ */

#if ardent
/* Stardent has only simple wait-for-all-children function, sigh... */
#define waitpid(pid, statusp, options)	wait((int*)0)
char *getenv(const char *name);		/* missing from system header files */
#endif

#if __hppa
#include <sys/wait.h>
#endif /* __hppa */

#if __sgi
#include <sys/wait.h>
#endif /* __sgi */

#define FILE_VERSION  	2	/* file format version */
#define MAJOR_VERSION 	2	/* program version     */
#define MINOR_VERSION 	5

#define MAXWORD	  	31	/* maximum length of word indexed */
typedef char Word[MAXWORD+1];

#include <limits.h>
#ifndef USHRT_MAX
#define USHRT_MAX ((unsigned int) 0xffffL)
#endif

typedef unsigned short Index_t;
#define INDEX_NAN USHRT_MAX	/* maximum value representable as Index_t */

#define BADWORDS	{ 	/* words not to index */ \
    "an", "and", "for", "in", "of", "on", "the", "to", "with", 0 \
}

#define NONABBREV ",\n\t \"#%'()={}"    /* See LaTeX book, p.143 */

/*
 * provide ntohs(), ntohl(), htonl() and htons():
 */
#if defined(unix) && !defined(HAVE_NETINET_IN_H)
#define HAVE_NETINET_IN_H	unix
#endif

#if HAVE_NETINET_IN_H
#include <netinet/in.h>
#else
/* define as no-op for standalone: */
#define	ntohl(x)	(x)
#define	ntohs(x)	(x)
#define	htonl(x)	(x)
#define	htons(x)	(x)
#endif
