#!/bin/sh
### ====================================================================
###  @UNIX-shell-file{
###     author          = "Nelson H. F. Beebe",
###     version         = "0.00",
###     date            = "01 November 1994",
###     time            = "08:59:52 MST",
###     filename        = "biblabel.sh",
###     address         = "Center for Scientific Computing
###                        Department of Mathematics
###                        University of Utah
###                        Salt Lake City, UT 84112
###                        USA",
###     telephone       = "+1 801 581 5254",
###     FAX             = "+1 801 581 4148",
###     checksum        = "47660 68 258 2398",
###     email           = "beebe@math.utah.edu (Internet)",
###     codetable       = "ISO/ASCII",
###     keywords        = "bibliography, BibTeX, citation label, LaTeX,
###                        TeX",
###     supported       = "yes",
###     docstring       = "This script runs the biblabel.awk program
###                        to generate a citation label substitution
###                        file suitable for input to citesub(1) to
###                        standardize citation labels to the form
###                        Author:year:abbrev.
###
###                        Usage:
###
###                        biblabel [-f in-use-file] [-i ignore-file]
###                            [ BibTeXfile(s) ] >output-citesub-file
###
###                        The checksum field above contains a CRC-16
###                        checksum as the first value, followed by the
###                        equivalent of the standard UNIX wc (word
###                        count) utility output of lines, words, and
###                        characters.  This is produced by Robert
###                        Solovay's checksum utility.",
###  }
### ====================================================================

BIBLABELAWK=./biblabel.awk
FILES=
IGNOREFILE=/dev/null
INUSEFILE=/dev/null

# Loop over the command-line arguments, collecting bibsort switches,
# sort(1) switches, and file names.
while [ $# -gt -0 ]
do
	case $1 in
	-f)
		shift
		INUSEFILE=$1
		;;
	-i)
		shift
		IGNOREFILE=$1
		;;
	*)
		FILES="$FILES $1"
		;;
	esac
	shift			# discard this switch
done

bibclean -no-check -no-warning -max-width 0 $FILES | \
	gawk -f $BIBLABELAWK -v IGNORE=$IGNOREFILE -v USED=$INUSEFILE
