/* -*-C-*- stricm.c */
/*-->stricmp*/
/**********************************************************************/
/****************************** stricmp *******************************/
/**********************************************************************/

#include "os.h"
#include "xctype.h"
#include "xstdlib.h"
#include "xstring.h"

RCSID("$Id: stricm.c,v 1.6 1993/12/29 18:27:02 beebe Exp beebe $")


/***********************************************************************
 Compare strings (ignoring case), and return:
	s1>s2:	>0
	s1==s2:  0
	s1<s2:	<0
***********************************************************************/

/* toupper() is supposed to work for all letters, but PCC-20 does it
incorrectly if the argument is not already lowercase; this definition
fixes that. */

#define TOUPPER(c) (islower(c) ? toupper(c) : (c))

int
#if STDC
stricmp(
register const char *s1,
register const char *s2
)
#else /* NOT STDC */
stricmp(s1, s2)
register const char *s1;
register const char *s2;
#endif /* STDC */
{
    while ((*s1) && (TOUPPER(*s1) == TOUPPER(*s2)))
    {
	s1++;
	s2++;
    }
    return((int)(TOUPPER(*s1) - TOUPPER(*s2)));
}

#ifdef TOUPPER
#undef TOUPPER
#endif /* TOUPPER */
