/* -*-C-*- xstat.h */
/**********************************************************************/
/******************************** stat ********************************/
/**********************************************************************/

/* $Id: xstat.h,v 1.8 1994/03/01 02:35:35 beebe Exp $*/

#ifndef XSTAT_H_DEFINED_
#define XSTAT_H_DEFINED_

/***********************************************************************
This file includes the system stat.h file, which does not have a
standard location.

On ULTRIX and System V, the system stat.h cannot be included more than
once, because the compilers raise errors about duplicate (although
identical) definitions of struct stat; the code here prevents that
from happening.
***********************************************************************/

#ifndef OS_H_DEFINED_
#include "os.h"
#endif /* OS_H_DEFINED_ */

#include "xtypes.h"

#if HAVE_STAT_H
#if HAVE_SYS_DIR
#include <sys/stat.h>
#else /* NOT HAVE_SYS_DIR */
#include <stat.h>
#endif /* HAVE_SYS_DIR */
#endif /* HAVE_STAT_H */

#if !defined(__cplusplus)
#if ultrix && (mips || __LCC__)		/* supply missing prototypes */
int		fstat ARGS((int file_desc_, struct stat *buffer_));
int		stat ARGS((const char *file_spec_, struct stat *buffer_)) ;
/* chmod() and mkdir() are also missing prototypes in <sys/stat.h>,
but we cannot declare them here because one argument in each is of
type mode_t, which on ULTRIX expands to "unsigned short", which
requires a complete unique Standard C prototype to compile. */
#endif /* ultrix && (mips || __LCC__) */
#endif /* !defined(__cplusplus) */

#endif /* XSTAT_H_DEFINED_ */
