/* -*-C-*- xstddef.h */
/**********************************************************************/
/****************************** stddef ********************************/
/**********************************************************************/

/* $Id: xstddef.h,v 1.6 1993/12/29 18:40:00 beebe Exp beebe $ */

#ifndef XSTDDEF_H_DEFINED_
#define XSTDDEF_H_DEFINED_

/***********************************************************************
This file provides some miscellaneous type and constant definitions. It
will include <stddef.h> in a Standard C environment instead.  It is
intended to be included only by os.h.
[14-Dec-1988]
***********************************************************************/

#if    STDC || HAVE_STDDEF_H
#include <stddef.h>		/* get the host version */
#else  /* NOT (STDC || HAVE_STDDEF_H) */

#ifndef NULL
#if    KCC_20
/* has its own version in stdio.h */
#else  /* NOT KCC_20 */
#define NULL			((VOIDP) 0L)
#endif /* KCC_20 */
#endif /* NULL */

#ifndef offsetof
#define offsetof(type,ident)	((size_t)(&((type*) NULL)->ident))
#endif /* offsetof */

/* os.h has already included <sys/types.h>, so most systems should
already have size_t defined.  Here is a reasonable value to use if
it is not yet known. */
#if 0
typedef long			size_t;
#endif /* 0 */


#if    STDC
#else  /* NOT STDC */
typedef long			ptrdiff_t;
#endif /* STDC */

extern volatile int		errno;	/* UNIX style error code */

#endif /* STDC || HAVE_STDDEF_H */

#endif /* XSTDDEF_H_DEFINED_ */
