/* -*-C-*- typedefs.h */
/*-->typedefs*/
/**********************************************************************/
/****************************** typedefs ******************************/
/**********************************************************************/

/* $Id: typedefs.h,v 1.8 1993/12/29 19:24:11 beebe Exp beebe $ */

#ifndef TYPEDEFS_H_DEFINED_
#define	TYPEDEFS_H_DEFINED_

/***********************************************************************
This file defines all of the primitive scalar data types required by
the DVI family.  These are defined below by typedefs, not preprocessor
symbols, so advantage can be taken of better compiler type matching.
We establish a set of default types, and then override some of them on
a case-by-case basis.

WARNING: Do NOT use types BYTE* (pointer to BYTE); they may not be the
same as (char*) in memory.
***********************************************************************/

#define	T_BOOLEAN	unsigned char	/* >= 1 bit */
#define	T_BYTE		unsigned char	/* >= 8 bits */
#define	T_COORDINATE	short		/* >= 16 bits */
#define	T_INT16		short		/* >= 16 bits */
#define	T_INT32		long		/* >= 32 bits */
#define	T_INT8		short		/* >= 8 bits */
#define	T_UNSIGN16	unsigned short	/* >= 16 bits */
#define	T_UNSIGN32	unsigned long	/* >= 32 bits */
#define	T_VOID		void

/**********************************************************************/
/* Type variations, either because of compiler limitations, or because
of efficiency considerations (e.g. vector and RISC architectures don't
work well on data types shorter than 32 bits). */

#ifdef mips				/* RISC: use only 32-bit values */
#undef	T_BOOLEAN
#define	T_BOOLEAN	unsigned int
#undef	T_BYTE
#define	T_BYTE		unsigned int
#undef	T_COORDINATE
#define	T_COORDINATE	int
#undef	T_INT16
#define	T_INT16		int
#undef	T_INT8
#define	T_INT8		int
#undef	T_UNSIGN16
#define	T_UNSIGN16	unsigned int
#endif /* mips */

#ifdef sparc				/* RISC: use only 32-bit values */
#undef	T_BOOLEAN
#define	T_BOOLEAN	unsigned int
#undef	T_BYTE
#define	T_BYTE		unsigned int
#undef	T_COORDINATE
#define	T_COORDINATE	int
#undef	T_INT16
#define	T_INT16		int
#undef	T_INT8
#define	T_INT8		int
#undef	T_UNSIGN16
#define	T_UNSIGN16	unsigned int
#endif /* sparc */

#if    IBM_PC_TURBO
#undef	T_BYTE
#define	T_BYTE		unsigned int
#endif /* IBM_PC_TURBO */

#ifdef _AIX
#undef	T_BOOLEAN
#define	T_BOOLEAN	int
#undef	T_BYTE
#define	T_BYTE		int
#undef	T_COORDINATE
#define	T_COORDINATE	int
#undef	T_INT16
#define	T_INT16		int
#undef	T_INT8
#define	T_INT8		int
#undef	T_UNSIGN16
#define	T_UNSIGN16	unsigned int
#undef	T_UNSIGN32
#define	T_UNSIGN32	unsigned long
#endif /* _AIX */

#ifdef __GNUC__
#undef	T_BOOLEAN
#define	T_BOOLEAN	unsigned int
#undef	T_BYTE
#define	T_BYTE		unsigned int
#undef	T_COORDINATE
#define	T_COORDINATE	int
#undef	T_INT16
#define	T_INT16		int
#undef	T_INT8
#define	T_INT8		int
#undef	T_UNSIGN16
#define	T_UNSIGN16	unsigned int
#endif /* __GNUC__ */

#ifdef OS_TOPS20		/* use 36-bit full-word types for efficiency*/

#if    PCC_20
/* void defined by local addition to stdio.h */
/* #undef	T_VOID */
/* #define	T_VOID		int */
#endif /* PCC_20 */

#undef	T_BOOLEAN
#define	T_BOOLEAN	int
#undef	T_BYTE
#define	T_BYTE		int
#undef	T_COORDINATE
#define	T_COORDINATE	int
#undef	T_INT16
#define	T_INT16		int
#undef	T_INT8
#define	T_INT8		int
#undef	T_UNSIGN16
#define	T_UNSIGN16	unsigned int
#endif /* OS_TOPS20 */

#if    OS_VMCMS
#undef	T_VOID
#define	T_VOID		int
#endif /* OS_VMCMS */

/**********************************************************************/

typedef	T_BOOLEAN	BOOLEAN;
typedef	T_BYTE		BYTE;
typedef T_COORDINATE	COORDINATE;
typedef T_INT16		INT16;
typedef T_INT32		INT32;
typedef T_INT8		INT8;
typedef T_UNSIGN16	UNSIGN16;
typedef T_UNSIGN32	UNSIGN32;

#ifdef ardent
#define VOID            T_VOID          /* compiler won't accept a typedef */
#endif /* ardent */

#ifdef MSDOS
#define VOID            T_VOID          /* compiler won't accept a typedef */
#endif /* MSDOS */

#ifdef vms
#define VOID            T_VOID          /* compiler won't accept a typedef */
#endif /* vms */

#ifndef VOID
#ifdef AIX
#define VOID		void  
#else /* NOT VOID */
/* typedef T_VOID          VOID; */
#define VOID            T_VOID          /* compiler won't accept a typedef */
#endif /* AIX */
#endif /* VOID */

/* No further use may be made of the T_xxx temporaries, so eliminate them */
#undef T_BOOLEAN
#undef T_BYTE
#undef T_COORDINATE
#undef T_INT16
#undef T_INT32
#undef T_INT8
#undef T_UNSIGN16
#undef T_UNSIGN32
#undef T_VOID

/**********************************************************************/

#ifdef FALSE
#undef FALSE
#endif /* FALSE */

#define	 FALSE		  ((BOOLEAN)0)

#ifdef TRUE
#undef TRUE
#endif /* TRUE */

#define	 TRUE		  ((BOOLEAN)1)

typedef unsigned char UCHAR;		/* Used in struct char_entry */
					/* for flags and small integers */
					/* so size is VERY important. */
					/* Do NOT make unsigned int */
					/* unless your compiler does not */
					/* support unsigned char (in which */
					/* case, your compiler is very old). */
typedef struct
{
    const char		*name;		/* name string */
    int			minmatch;	/* minimum unique match length	*/
    int			value;		/* numerical value */
} match_table;

#endif /* TYPEDEFS_H_DEFINED_ */
