.\" ====================================================================
.\"  @Troff-man-file{
.\"     author          = "Nelson H. F. Beebe",
.\"     version         = "0.02",
.\"     date            = "16 October 1996",
.\"     time            = "12:11:51 MDT",
.\"     filename        = "biblabel.man",
.\"     address         = "Center for Scientific Computing
.\"                        Department of Mathematics
.\"                        University of Utah
.\"                        Salt Lake City, UT 84112
.\"                        USA",
.\"     telephone       = "+1 801 581 5254",
.\"     FAX             = "+1 801 581 4148",
.\"     checksum        = "64777 269 1145 8456",
.\"     email           = "beebe@math.utah.edu (Internet)",
.\"     codetable       = "ISO/ASCII",
.\"     keywords        = "bibliography, BibTeX, citation label, LaTeX,
.\"                        TeX",
.\"     supported       = "yes",
.\"     docstring       = "This file contains the UNIX manual pages
.\"                        for the biblabel utility, a program for
.\"                        generating new BibTeX citation labels
.\"                        standardized to the BibNet Project form,
.\"                        Lastname:year:abbrev.  The companion
.\"                        program, citesub, can be used to carry out
.\"                        the substitutions on BibTeX, LaTeX, and TeX
.\"                        files.
.\"
.\"                        The checksum field above contains a CRC-16
.\"                        checksum as the first value, followed by the
.\"                        equivalent of the standard UNIX wc (word
.\"                        count) utility output of lines, words, and
.\"                        characters.  This is produced by Robert
.\"                        Solovay's checksum utility.",
.\"  }
.\" ====================================================================
.if t .ds Bi B\s-2IB\s+2T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Bi BibTeX
.if t .ds Te T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Te TeX
.TH BIBLABEL 1 "16 October 1996" "Version 0.02"
.\"======================================================================
.SH NAME
biblabel \- generated standardized BibTeX citation labels
.\"======================================================================
.SH SYNOPSIS
.B biblabel
[
.BI \-f " in-use-file"
]
[
.BI \-i " ignore-file"
]
[ \*(Bi\&file(s) ]  >outfile
.\"======================================================================
.SH DESCRIPTION
.B biblabel
filters a \*(Bi\& bibliography, or bibliography
fragment, on its standard input, or one or more
bibliographies named on the command line, and
prints on standard output lines containing pairs
of old and new citation labels, suitable for input
to the companion program,
.BR citesub (1).
.PP
The citation label is formed by these rules, easily
applicable by a human, or by a computer program
like this one:
.RS
.TP \w'(1)'u+2n
(1)
Take the first author's last name, dropping
apostrophes, Jr/Sr/generation numbers, and
eliminating accents (e.g. J{\e"a}nsch -> Jaensch,
and Jind\ev{r}ich -> Jindrich), using multi-letter
transliterations if that is conventional.
Hyphenated names, like Baeza-Yates, are preserved
in full.
.TP
(2)
Append a colon.
.TP
(3)
Append the four-digit year of publication.
.TP
(4)
Append another colon.
.TP
(5)
Pick the first 3 important words in the title that
begin with a letter, excluding articles and
prepositions and \*(Te\& math mode (e.g.
.I "On ${C}^1$ interpolating hierarchical spline bases"
reduces to IHS), and append that.  If there are
fewer than 3 important words, then use a shorter
string.
.TP
(6)
If the resulting citation label is already in use,
add a letter
.IR a ,
.IR b ,
.IR c ,
\|.\|.\|. to make it unique.
.RE
.PP
This will produce a label like Smith:1994:ABC.
.PP
The reason for including a four-digit year is that
the millenium change is near, and we expect
bibliographies to be in use for many years hence.
Also, some bibliographies may be historical, with
entries dating back hundreds of years.  Using a
four-digit year will keep sorts of otherwise
identical keys in chronological order, and putting
the year before the key derived from the title
will facilitate sorting by year.
.PP
Because any change in citation labels must be
accompanied by a change in citations in all
documents that use the bibliography, it is not
sufficient to just produce a new bibliography file
with changed labels.  Consequently, the output of
.B biblabel
is expected to be saved, and subsequently used
with
.BR citesub (1)
to actually carry out the substitutions
efficiently.  If no documents other than the
bibliography file itself need to be changed, then
a simple UNIX or IBM PC DOS pipeline of the form
.PP
.nf
.I "biblabel <foo.bib | citesub -f - >foo.bib-new
.fi
.PP
will produce a new bibliography file with all of
the citation labels changed to the new
standardized form.
.PP
To avoid confusion between labels with common
prefixes, such as
.I Smith80
and
.IR Smith80a ,
.BR citesub (1)
will check for leading context of a left brace,
quote, comma, whitespace, or beginning of line and
trailing context of a right brace, comma, quote,
percent, whitespace, or end of line so as to match
these styles:
.PP
.RS
.nf
@Book{Smith:1980:ABC,

crossref = "Smith:1980:ABC",

crossref = {Smith:1980:ABC},

\ecite{Smith:1980:ABC}

\ecite{Smith:1980:ABC,Jones:1994:DEF}

\ecite{%
       Smith:1980:ABC,%
       Jones:1994:DEF%
}
.fi
.RE
.\"======================================================================
.SH OPTIONS
Except for the options described below, all
command-line words are assumed to be input files.
Should such a filename begin with a hyphen, it
must be disguised by a leading absolute or
relative directory path, e.g.
.I /tmp/-foo.bib
or
.IR ./-foo.bib .
.TP \w'\-f-labels-in-use-file'u+2n
.BI \-f " labels-in-use-file"
This option specifies the name of a file
containing citation labels already in use, one
label per line.  This can be used in a multi-file
bibliography collection to guarantee unique
citation labels across the entire collection.
.TP
.BI \-i " ignore-file"
This option specifies the name of a file
containing additional words to be added to the
internal ignore list. Such words are ignored when
the up-to-three-letter title abbreviation is
constructed.
.\"======================================================================
.SH "WARNING AND ERROR MESSAGES"
.B biblabel
will issue warning messages in the following cases:
.TP \w'\(bu'u+1n
\(bu
.I "Duplicate citation labels in the input file(s)."
This condition will definitely cause erroneous
substitutions when
.BR citesub (1)
is used, so the error
.I must
be corrected and
.B biblabel
run again on the corrected file.
.TP
\(bu
.I "Incomplete accent removal."
.B biblabel
contains many heuristic reductions of accented
letters to unaccented ones, but occasionally an
accent combination is met that it cannot
recognize, and the result is that the generated
label may not be exactly what was intended.  Only
rarely will manual editing of the output
substitution file be necessary.
.TP
\(bu
.I "Year out of the range 1000 \|.\|.\|. 2099."
A valid year is required for generation of a
citation label; an out-of-range, or omitted, year
will be represented by
.I 19xx
in the generated citation label.
.\"======================================================================
.SH CAVEATS
\*(Bi\& has loose syntactical requirements that
the current simple implementation of
.B biblabel
does not support.  In particular, outer
parentheses may
.I not
be used in place of braces following ``@keyword''
patterns.  If you have such a file, you can use
.BR bibclean (1)
to prettyprint it into a form that
.B biblabel
can handle successfully.
.\"======================================================================
.SH "SEE ALSO"
.BR bibcheck (1),
.BR bibclean (1),
.BR bibextract (1),
.BR bibjoin (1),
.BR biblex (1),
.BR biborder (1),
.BR bibparse (1),
.BR bibsort (1),
.BR bibtex (1),
.BR bibunlex (1),
.BR citesub (1).
.\"======================================================================
.SH AUTHOR
.nf
Nelson H. F. Beebe, Ph.D.
Center for Scientific Computing
Department of Mathematics
University of Utah
Salt Lake City, UT 84112
Tel: +1 801 581 5254
FAX: +1 801 581 4148
Email: <beebe@math.utah.edu>
.fi
.\"==============================[The End]==============================
