/* -*-C-*- os.h */
/*-->os*/
/**********************************************************************/
/********************************* os *********************************/
/**********************************************************************/

#ifndef OS_H_DEFINED_ /* file ignored if included more than once */
#define OS_H_DEFINED_

/***********************************************************************
This file sets the operating system and compiler flags, automatically
where this is possible based on pre-defined symbols, and also always
includes stdio.h (this has been found essential to resolve problems of
where to find open file limits).

	=================		=========
	Operating Systems		Compilers
	=================		=========
	OS_ATARI			(Mark Williams)
	OS_PCDOS			__TURBOC__ and (Microsoft C)
	OS_PRIMOS			Prime
	OS_RMX				Intel
	OS_TOPS20			KCC_20 and PCC_20
	OS_UNIX				(cc and GNU gcc)
	OS_UNIX and OS_VAXVMS		__GNUC__
	OS_VAXVMS			(VMS cc and GNU gcc)
	OS_VMCMS			(Waterloo)
	any				__STDC__ (Standard C conformant)
	=================		=========

The operating system macros will be given definitions (0 or 1), so
they can freely by used in later preprocessor expressions.  Specific
compiler symbols should be used only inside code bracketed by #if
OS_xxx ...  #endif.

For convenience, the following values are also set:

	STDC		0 in pre-Standard C, 1 in Standard C

	UNIX_ATT	UNIX variants
	UNIX_BSD

	ARGS		argument prototypes (Standard C or pre-Standard C)
	const		type modifier (new with Standard C)
	errno		UNIX style error code
	MAXPATHLEN	length of the longest host filename.
	NULL		null pointer constant
	OPENMAX		maximum number of open files per process
	fpos_t		type used for file positions
	offsetof	macro to return offset of element in structure
	ptrdiff_t	type used for pointer differences
	R_OPEN		fopen() mode flags for text read
	RB_OPEN		fopen() mode flags for binary read
	RW_OPEN		fopen() mode flags for text read/write
	size_t		integer type returned by sizeof()
	time_t		integer type used for time counters
	W_OPEN		fopen() mode flags for text write
	WB_OPEN		fopen() mode flags for binary write
	VOIDP		void* (new with Standard C) or char* (pre-Standard C)
	volatile	type modifier (new with Standard C)

Some of these are defined in Standard stddef.h; a private version of that
is included below, so it need not appear in user programs.

It does not appear possible for OS_PRIMOS, OS_RMX, and OS_VMCMS to
recognize the operating system automatically from predefined symbols;
for those, you will have to set the OS_xxx value explicitly below, or
else define it at compile time.

[07-Jul-1990]
***********************************************************************/

/***********************************************************************
Standard C conformant systems must define __STDC__ to a non-zero value.
All predefined macros in Standard C systems have leading and trailing
double underscores, and Standard C reserves names of that form for the
compiler/library implementors.	Alas, prior practice has been to
predefine arbitrary names, usually in lower case, without underscores
(thereby making them likely to be confused with program variables).
We use some of these in tests below.  It is better to define our own
names (all in upper case) and make them more systematic and less
likely to clash with predefined symbols.

Alas, some compilers (Microsoft C 5.1, QuickC 2.0) predefine __STDC__
to a zero value that cannot be changed, and others (GNU gcc) define it
to a non-zero value when the library and system header files are not
yet conformant.	 Therefore, we only test if __STDC__ is defined or
not, and we use a private symbol, STDC, for deciding whether we have
a Standard (or almost Standard) C environment.	 We use this to choose the
form of function prototypes, and to decide whether certain #include
header files and predefined types are available.
***********************************************************************/

/* Here are the operating systems supported. */

#ifndef OS_ATARI
#define OS_ATARI		0
#endif /* OS_ATARI */

#ifndef OS_PCDOS
#define OS_PCDOS		0
#endif /* OS_PCDOS */

#ifndef OS_PRIMOS
#define OS_PRIMOS		0
#endif /* OS_PRIMOS */

#ifndef OS_RMX
#define OS_RMX			0
#endif /* OS_RMX */

#ifndef OS_TOPS20
#define OS_TOPS20		0
#endif /* OS_TOPS20 */

#ifndef OS_UNIX
#define OS_UNIX			0
#endif /* OS_UNIX */

#ifndef OS_VAXVMS
#define OS_VAXVMS		0
#endif /* OS_VAXVMS */

#ifndef OS_VMCMS
#define OS_VMCMS		0
#endif /* OS_VMCMS */

/* Provide defaults for compiler symbols */

#ifndef IBM_PC_MICROSOFT
#define IBM_PC_MICROSOFT	0
#endif /* IBM_PC_MICROSOFT */

#ifndef IBM_PC_TURBO
#define IBM_PC_TURBO		0
#endif /* IBM_PC_TURBO */

#ifndef KCC_20
#define KCC_20			0
#endif /* KCC_20 */

#ifndef PCC_20
#define PCC_20			0
#endif /* PCC_20 */

#ifndef UNIX_ATT
#define UNIX_ATT		0
#endif /* UNIX_ATT */

#ifndef UNIX_BSD
#define UNIX_BSD		0
#endif /* UNIX_BSD */

#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus		1	/* we only use this new name */
#endif /* __cplusplus */
#endif /* c_plusplus */

/***********************************************************************
We start by assuming that most implementations will have certain basic
types.  These can be overridden at compile time, or in O/S-specific
sections below.  If they are not defined, then Standard-C conformant
typedefs are supplied.
***********************************************************************/

#ifndef HAVE_CLOCK_T
#define HAVE_CLOCK_T		1
#endif /* HAVE_CLOCK_T */

#ifndef HAVE_FPOS_T
#define HAVE_FPOS_T		1
#endif /* HAVE_FPOS_T */

#ifndef HAVE_PROTOTYPES
#define HAVE_PROTOTYPES		0
#endif /* HAVE_PROTOTYPES */

#ifndef HAVE_SIZE_T
#define HAVE_SIZE_T		1
#endif /* HAVE_SIZE_T */

#ifndef HAVE_TIME_T
#define HAVE_TIME_T		1
#endif /* HAVE_TIME_T */

#ifndef HAVE_VOIDP
#define HAVE_VOIDP		0
#endif /* HAVE_VOIDP */

#ifndef HAVE_VOLATILE_TYPE
#define HAVE_VOLATILE_TYPE	0
#endif /* HAVE_VOLATILE_TYPE */

/***********************************************************************
Define symbols that tell what system include files are available.  These
can all be overridden at compile time.
***********************************************************************/

#ifndef HAVE_ERRNO_H
#define HAVE_ERRNO_H		1
#endif /* HAVE_ERRNO_H */

#ifndef HAVE_FILE_H
#define HAVE_FILE_H		1
#endif /* HAVE_FILE_H */

#ifndef HAVE_LIMITS_H
#define HAVE_LIMITS_H		1
#endif /* HAVE_LIMITS_H */

#ifndef HAVE_MATH_H
#define HAVE_MATH_H		1
#endif /* HAVE_MATH_H */

#ifndef HAVE_PARAM_H
#define HAVE_PARAM_H		1
#endif /* HAVE_PARAM_H */

#ifndef HAVE_PWD_H
#define HAVE_PWD_H		0
#endif /* HAVE_PWD_H */

#ifndef HAVE_STAT_H
#define HAVE_STAT_H		1
#endif /* HAVE_STAT_H */

#ifndef HAVE_SYS_DIR
#define HAVE_SYS_DIR		1
#endif /* HAVE_SYS_DIR */

#ifndef HAVE_TYPES_H
#define HAVE_TYPES_H		1
#endif /* HAVE_TYPES_H */

/***********************************************************************
A few getxxx() library functions are often not declared in system
header files.  Start by assuming they are properly declared.
***********************************************************************/

#ifndef HAVE_GETWD
#define HAVE_GETWD		0	/* avoid: not a Posix function */
#endif /* HAVE_GETWD */

#ifndef HAVE_GETWD_DCL
#define HAVE_GETWD_DCL		0
#endif /* HAVE_GETWD_DCL */

#ifndef HAVE_GETCWD
#define HAVE_GETCWD		1
#endif /* HAVE_GETCWD */

#ifndef HAVE_GETCWD_DCL
#define HAVE_GETCWD_DCL		1
#endif /* HAVE_GETCWD_DCL */


#ifndef HAVE_GETHOSTNAME
#define HAVE_GETHOSTNAME	1	/* most systems have it, but */
#endif /* HAVE_GETHOSTNAME */

#ifndef HAVE_GETHOSTNAME_DCL
#define HAVE_GETHOSTNAME_DCL	0	/* lack a function prototype */
#endif /* HAVE_GETHOSTNAME_DCL */


#ifndef HAVE_GETLOGIN
#define HAVE_GETLOGIN		1
#endif /* HAVE_GETLOGIN */

#ifndef HAVE_GETLOGIN_DCL
#define HAVE_GETLOGIN_DCL	1
#endif /* HAVE_GETLOGIN_DCL */


#ifndef HAVE_GETPWNAM
#define HAVE_GETPWNAM		1
#endif /* HAVE_GETPWNAM */

#ifndef HAVE_GETPWNAM_DCL
#define HAVE_GETPWNAM_DCL	1
#endif /* HAVE_GETPWNAM_DCL */


#ifndef HAVE_GETPWUID
#define HAVE_GETPWUID		1
#endif /* HAVE_GETPWUID */

#ifndef HAVE_GETPWUID_DCL
#define HAVE_GETPWUID_DCL	1
#endif /* HAVE_GETPWUID_DCL */


#ifndef HAVE_GETUID
#define HAVE_GETUID		1
#endif /* HAVE_GETUID */

#ifndef HAVE_GETUID_DCL
#define HAVE_GETUID_DCL		1
#endif /* HAVE_GETUID_DCL */


/***********************************************************************
Now check for the definition of certain predefined symbols to see if
we can automatically set the operating system and UNIX variant flags.
This is possible for OS_PCDOS, OS_TOPS20 (KCC_20 only), OS_VAXVMS, and
OS_UNIX, but not for OS_TOPS20 (PCC_20) or OS_ATARI.

On IBM VM/CMS, IBM C and Waterloo C have only 'ANSI' predefined if you
compile under that option, so there is no apparently no way to detect
that environment automatically.	 I have no information yet on what the
SAS/Lattice C compiler does.  Compile-time definition of OS_VMCMS will
therefore be necessary.
***********************************************************************/

#if    VMS
/***********************************************************************
The VAX VMS compiler complains about undefined macros when the
/STANDARD=PORTABLE compiler switch is used.  To avoid masking other
legitimate problems, we define ALL referenced preprocessor symbols here.
***********************************************************************/

#if defined(__ALPHA)
#undef HAVE_GETHOSTNAME
#undef HAVE_GETHOSTNAME_DCL
#undef HAVE_GETWD
#undef HAVE_MEMXXX_H
#undef HAVE_PARAM_H
#undef HAVE_SIZE_T
#undef HAVE_STRDUP
#undef HAVE_SYS_DIR
#undef HAVE_TIME_T
#endif

#define AIX			0
#define BSD			0
#define HAVE_CLOCK_T		1
#define HAVE_CONST_TYPE		0
#define HAVE_ERRNO_H		1
#define HAVE_FPOS_T		1
#define HAVE_GETCWD		1
#define HAVE_GETCWD_DCL		1
#define HAVE_GETHOSTNAME	0
#define HAVE_GETHOSTNAME_DCL	0
#define HAVE_GETWD		0
#define HAVE_GETWD_DCL		0
#define HAVE_LIMITS_H		1
#define HAVE_MATH_H		1
#define HAVE_MEMXXX_DCL		1	/* string.h has memxxx() declarations */
#define HAVE_PARAM_H		0
#define HAVE_PROTOTYPES		0
#define HAVE_PWD_H		0
#define HAVE_SIZE_T		0
#define HAVE_STDDEF_H		0
#define HAVE_STDLIB_H		0
#define HAVE_STRDUP_DCL		0
#define HAVE_STRFTIME		0
#define HAVE_STRFTIME_DCL	0
#define HAVE_SYS_DIR		0
#define HAVE_TIME_T		0
#define HAVE_TM_ZONE		0
#define HAVE_TZNAME		0
#define HAVE_TZNAME_DCL		0
#define HAVE_VOIDP		0
#define HAVE_VOLATILE_TYPE	0
#define IBM_PC_MICROSOFT	0
#define IBM_PC_TURBO		0
#define KCC_20			0
#define MSDOS			0
#define PCC_20			0
#define STDC			0
#define UNIXPC			0
#define UNIX_ATT		0
#define UNIX_BSD		0
#define _AIX			0
#define _AIX370			0
#define _HPUX_SOURCE		0
#define _IBMR2			0
#define _POSIX_SOURCE		0
#define __ACC__			0
#define __APOGEE__		0
#define __CC__			0
#define __COMPILER_KCC__	0
#define __GNUC__		0
#define __GNUG__		0
#define __LCC__			0
#define __NeXT__		0

#if !defined(__ALPHA)
#define __STDC__		0
#endif

#define __SUNCC__		0
#define __TURBOC__		0

#if !defined(__ALPHA)
#define __alpha			0
#endif

#define __convex__		0

/* Do NOT define __cplusplus here; DEC OpenVMS uses definition, rather
than value, to choose between C and C++ declarations */

#define __hppa			0
#define __hpux			0
#define __sgi			0
#define __sgi__			0
#define __solaris		0
#define __unix			0
#define ardent			0
#define c_plusplus		0
#define hp300			0
#define hpux			0
#define mips			0
#define ps2			0
#define sgi			0
#define sun			0
#define sun386			0
#define ultrix			0
#define unix			0
#define unixpc			0
#define usg			0

#ifdef OS_VAXVMS
#undef OS_VAXVMS
#endif /* OS_VAXVMS */

#define OS_VAXVMS		1
#undef STDC
#define STDC			1
#endif /* VMS */

#if    (unix || __unix)		/* (all?) UNIX systems define one of these */

#ifdef OS_UNIX
#undef OS_UNIX
#endif /* OS_UNIX */

#define OS_UNIX			1

#endif /* (unix || __unix) */

#if    __alpha && (unix || __unix__)
#define HAVE_STRDUP_DCL		1
#define HAVE_MEMXXX_DCL		1
#ifdef OS_UNIX
#undef OS_UNIX
#endif /* OS_UNIX */
#define OS_UNIX			1
#define STDC			1
#endif /* __alpha && (unix || __unix__) */


#if    _AIX
/***********************************************************************
Both AIX-370 with the MetaWare High C Compiler R2.1n, and IBM AIX PS/2
C Language - Version 1.1, support Standard C-style function prototypes
and declarations, and have Standard C include files.  The preprocessor
symbols defined by these compilers are:

PS/2:		_AIX	AIX		NLS	ps2
3090:		_AIX	AIX	_AIX370	NLS	__HIGHC__	__STDC__
RS/6000:	_AIX	_IBMR2
***********************************************************************/

#ifdef OS_UNIX
#undef OS_UNIX
#endif /* OS_UNIX */

#if (_AIX370 || ps2)
#define HAVE_MEMXXX_DCL		1
#undef HAVE_FPOS_T		/* fpos_t is missing from <sys/types.h> */
#undef HAVE_GETLOGIN_DCL
#undef HAVE_GETPWNAM_DCL
#undef HAVE_GETWD_DCL
#if defined(__cplusplus)
#define HAVE_FPOS_T		1
#define HAVE_GETLOGIN_DCL	1
#define HAVE_GETLOGIN		1
#define HAVE_GETPWNAM_DCL	1
#define HAVE_GETPWNAM		1
#define HAVE_GETWD_DCL		1
#undef HAVE_GETWD
#define HAVE_GETWD		1
#endif /* defined(__cplusplus) */
#endif /*  (_AIX370 || ps2) */

#define OS_UNIX			1
#define STDC			1
#endif /* _AIX */

/* NB: We check for AIX separately from _AIX.  Both are defined by
Standard C-level compilers on AIX, but _AIX is not defined by
pre-Standard C compilers */

#if    AIX	/* IBM PS/2 and RT AIX (System V.2 UNIX + BSD extensions) */
#undef UNIX_ATT
#define UNIX_ATT		1
#endif /* AIX */

#if    MSDOS  /* Microsoft C 3, 4, 5, Quick C 1, 2 (latter defines _QC too) */

#ifdef OS_PCDOS
#undef OS_PCDOS
#endif /* OS_PCDOS */

#define OS_PCDOS		1

#ifdef IBM_PC_MICROSOFT
#undef IBM_PC_MICROSOFT
#endif /* IBM_PC_MICROSOFT */

#define IBM_PC_MICROSOFT	1
#define STDC			1
#endif /* MSDOS */

#if    __TURBOC__ /* Turbo C 2.0 (it also defines __MSDOS__) */
		/* __STDC__ is predefined only if -A compile switch used */

#undef HAVE_TZNAME_DCL			/* missing from time.h */
#define HAVE_TZNAME             1

#ifdef OS_PCDOS
#undef OS_PCDOS
#endif /* OS_PCDOS */

#define OS_PCDOS		1

#ifdef IBM_PC_TURBO
#undef IBM_PC_TURBO
#endif /* IBM_PC_TURBO */

#define IBM_PC_TURBO		1
#define STDC			1

#if (__TURBOC__ >= 0x0400)
/* tcc 3.0 does not define stdaux or stdprn in the __STDC__ environment,
but we need them, and fileno() too */
#define fileno(f)       ((f)->fd)
#if defined(__cplusplus)
#define stdaux		__getStream(3)
#define stdprn		__getStream(4)
#else /* NOT defined(__cplusplus) */
#define stdaux		(&_streams[3])
#define stdprn		(&_streams[4])
#endif /* defined(__cplusplus) */

#endif /* (__TURBOC__ >= 0x400) */
#endif /* __TURBOC__ */

#if    __COMPILER_KCC__

#ifdef OS_TOPS20
#undef OS_TOPS20
#endif /* OS_TOPS20 */

#define OS_TOPS20		1

#ifdef KCC_20
#undef KCC_20
#endif /* KCC_20 */

#define KCC_20			1

#ifdef __STDC__
#define STDC			1	/* KCC 6 or later */
#endif /* __STDC__ */

#endif /* __COMPILER_KCC__ */

#if    KCC_20

#ifdef OS_TOPS20
#undef OS_TOPS20
#endif /* OS_TOPS20 */

#define OS_TOPS20		1
#endif /* KCC_20 */

#if    PCC_20

#ifdef OS_TOPS20
#undef OS_TOPS20
#endif /* OS_TOPS20 */

#define OS_TOPS20		1
#endif /* PCC_20 */

#if    OS_TOPS20
#if    (KCC_20 || PCC_20)
#else  /* NOT (KCC_20 || PCC_20) */

#ifdef KCC_20
#undef KCC_20
#endif /* KCC_20 */

#define KCC_20			1	/* KCC-20 is default for Tops-20 */
#endif /* (KCC_20 || PCC_20) */
#endif /* OS_TOPS20 */

#if    __ACC__			/* Sun 4 SunOS 4.1.1 semi-Standard C compiler */
#define sun			1	/* doesn't define, but we need it */
#define STDC			1
#define HAVE_STDDEF_H		1
#define HAVE_STDLIB_H		1
#endif /* __ACC__ */

#if    __APOGEE__	/* Sun 4 SunOS 4.1.1 Apogee Standard C compiler */
#define sun			1	/* doesn't define, but we need it */
#define STDC			1
#define HAVE_STDDEF_H		1
#define HAVE_STDLIB_H		1
#endif /* __APOGEE__ */

#if    ardent				/* Ardent Titan (Stardent 1520) UNIX */
#undef HAVE_CLOCK_T			/* (System V + BSD extensions) */
#undef HAVE_FPOS_T
#undef HAVE_GETCWD_DCL
#undef HAVE_GETLOGIN_DCL
#undef HAVE_GETWD
#undef HAVE_GETWD_DCL
#undef HAVE_PROTOTYPES
#undef HAVE_VOIDP

#define HAVE_CONST_TYPE		0	/* has const, but include files  */
					/* don't use it, so we must not */
					/* either to avoid declaration  */
					/* conflicts */
#define HAVE_GETCWD		1
#define HAVE_GETCWD_DCL		0	/* missing from include files */
#define HAVE_GETLOGIN		1
#define HAVE_GETLOGIN_DCL	0	/* missing from include files */
#define HAVE_MEMXXX_DCL		1
#define HAVE_PROTOTYPES		1
#define HAVE_SIZE_T		1
#define HAVE_TIME_T		1
#define HAVE_TZNAME		1
#define HAVE_VOIDP		1

#undef UNIX_ATT
#define UNIX_ATT		1
#endif /* ardent */

#if BSD					/* this works for BSD 4.3 on HP 370 */
#undef HAVE_FPOS_T
#undef HAVE_GETWD
#undef HAVE_GETWD_DCL
#undef UNIX_BSD
#define HAVE_GETWD		1
#define HAVE_GETWD_DCL		1
#define UNIX_BSD		1
#endif

#if __convex__
#define STDC			1
#endif /* __convex__ */

#if (__GNUC__ || defined(__cplusplus))
#undef HAVE_CONST_TYPE
#undef HAVE_PROTOTYPES
#undef HAVE_VOIDP
#undef HAVE_VOLATILE_TYPE

#define HAVE_CONST_TYPE		1
#define HAVE_PROTOTYPES		1
#define HAVE_VOIDP		1
#define HAVE_VOLATILE_TYPE	1
#define STDC			1
#endif /* (__GNUC__ || defined(__cplusplus)) */

#if    __hppa && (_POSIX_SOURCE - 0)
#define STDC			1
#define HAVE_STDDEF_H		1
#define HAVE_STDLIB_H		1
#endif /* __hppa && (_POSIX_SOURCE - 0) */

#if    __hppa && _HPUX_SOURCE
#define STDC			1
#define HAVE_STDDEF_H		1
#define HAVE_STDLIB_H		1
#undef HAVE_GETHOSTNAME
#define HAVE_GETHOSTNAME	1
#undef HAVE_GETHOSTNAME_DCL
#define HAVE_GETHOSTNAME_DCL	1
#endif /* __hppa && _HPUX_SOURCE */

#if	__hppa && defined(__cplusplus)
#undef HAVE_GETHOSTNAME_DCL
#define HAVE_GETHOSTNAME_DCL	1
#endif /* __hppa && defined(__cplusplus) */

#if    (hpux || __hpux)	/* Hewlett-Packard UNIX (System V + BSD extensions) */
#undef HAVE_GETWD
#undef HAVE_TZNAME
#undef UNIX_ATT

#define HAVE_TZNAME             1

#ifdef __STDC__
#define STDC			1
#endif /* __STDC__ */

#define UNIX_ATT		1
#endif /* (hpux || __hpux) */

#if    __LCC__		/* AT&T / Princeton retargetable Standard C compiler: */
			/* lcc has code generators for several architectures, */
			/* and its own Standard C include files. */
#define STDC			1
#define HAVE_STDDEF_H		1
#define HAVE_STDLIB_H		1
#endif /* __LCC__ */

#if mips && !(ardent || __sgi || ultrix)/* MIPS UNIX (System V.3 and BSD 4.3) */

#undef HAVE_FPOS_T		/* fpos_t is missing from <sys/types.h> */
#undef HAVE_CLOCK_T
#undef HAVE_GETLOGIN_DCL
#undef HAVE_GETCWD
#undef HAVE_GETCWD_DCL
#undef HAVE_GETWD
#undef HAVE_GETWD_DCL
#define HAVE_GETWD		1
#define HAVE_GETWD_DCL		1
#undef HAVE_GETPWNAM_DCL
#undef HAVE_GETUID_DCL
#undef HAVE_VOIDP

#define HAVE_MEMXXX_DCL		1
#define HAVE_TM_ZONE		1	/* time.h struct tm has tm_zone */
					/* in -systype bsd43 environment */
#define HAVE_VOIDP		1
#undef UNIX_BSD
#define UNIX_BSD		1
#endif /* mips && !(ardent || __sgi || ultrix) */

#if    __NeXT__
/* NeXT systems use the GNU C compiler and MACH (4.3BSD system call
compatible).  The compiler predefines __MACH__, mc68000, NeXT,
__STDC__, and unix, and has Standard C-conformant library and header
files. */
#define STDC			1
#undef UNIX_BSD
#define UNIX_BSD		1
#undef HAVE_GETUID_DCL
#undef HAVE_GETWD
#undef HAVE_GETWD_DCL
#define HAVE_GETWD		1
#define HAVE_GETWD_DCL		1
#undef HAVE_GETCWD
#undef HAVE_GETCWD_DCL
#if defined(__cplusplus)
#define HAVE_GETUID_DCL		1
#endif
#endif /* __NeXT__ */

#if    (sgi || __sgi)			/* Silicon Graphics UNIX System V.x */

#undef UNIX_ATT
#define UNIX_ATT		1
#endif /* (sgi || __sgi) */

#if __sgi__ && __GNUC__
/* GNU C 1.39 is missing these symbols that cc defines, and we need them */
#define __SVR3			1
#define __host_mips		1
#define __mips			1
#define __sgi			1
#define __unix			1
#endif /* __sgi__ && __GNUC__ */

#if    __sgi			/* Silicon Graphics Iris Indigo IRIX 4.0.1*/
#define STDC			1
#define HAVE_MEMXXX_DCL		1
#define HAVE_SSCANF_FUNCTION	1
#define HAVE_OPEN_DCL		1
#define HAVE_STDDEF_H		1
#define HAVE_STDLIB_H		1
#endif /* __sgi */

#if    __SUNCC__
#define sun	1
#endif /* __SUNCC__ */

#if    sun	/* Sun Microsystems UNIX OS 3.x and 4.x (4.2BSD) */
#undef HAVE_FPOS_T		/* fpos_t is missing from <sys/types.h> */
#undef HAVE_GETCWD_DCL
#undef HAVE_GETLOGIN_DCL
#undef HAVE_GETUID_DCL

#if	__ACC__
#define HAVE_MEMXXX_DCL		1
#endif /* __ACC__ */

#define HAVE_GETLOGIN_DCL	1
#define HAVE_GETUID_DCL		1

#if    __GNUC__
#undef HAVE_GETLOGIN_DCL
#undef HAVE_GETUID_DCL
#endif /* __GNUC__ */

#if    __LCC__
#define HAVE_FPOS_T	1
#endif

#if    __SUNCC__
#undef HAVE_GETWD
#undef HAVE_GETWD_DCL
#define HAVE_GETWD	1
#define HAVE_GETWD_DCL	1
#endif /* __SUNCC__ */

#if    sun386				/* Sun 386i */
#undef HAVE_CLOCK_T
#undef HAVE_GETLOGIN_DCL

#define HAVE_SSCANF_FUNCTION	1	/* true for all versions */
#else					/* Sun 3 or 4 */
#define HAVE_SSCANF_FUNCTION	1	/* true for all versions */
#define HAVE_OPEN_DCL		1	/* true at SunOS 4.0 or later */
					/* defined in sys/fcntlcom.h */
#define HAVE_STDDEF_H		1	/* true at SunOS 4.1 or later, even */
					/* though cc is not yet Standard C */
#define HAVE_STDLIB_H		1	/* true at SunOS 4.1 or later, even */
					/* though cc is not yet Standard C */
#endif /* sun386 */

#if defined(__cplusplus)
#undef HAVE_OPEN_DCL
#endif /* defined(__cplusplus) */

#define HAVE_TM_ZONE		1	/* time.h struct tm has tm_zone */

#if   __solaris				/* Solaris 2.x on Sun systems */
#define HAVE_GETCWD_DCL		1
#if __GNUC__
#undef HAVE_GETCWD_DCL
#define HAVE_GETCWD_DCL		1	/* 0 for gcc 2.3 and earlier */
#endif
#undef HAVE_TM_ZONE
#endif

#undef UNIX_BSD
#define UNIX_BSD		1

#endif /* sun */

#if    ultrix	/* DEC version of 4.2BSD UNIX */
#define HAVE_MEMXXX_DCL		1
#define HAVE_OPEN_DCL		1
#define HAVE_TM_ZONE		1	/* time.h struct tm has tm_zone */
#undef HAVE_GETUID_DCL

#if   __GNUG__
#define HAVE_GETUID_DCL		1
#endif

#if    __LCC__
#undef HAVE_TM_ZONE
#define HAVE_STRFTIME		1
#define HAVE_STRFTIME_DCL	1
#endif /* __LCC__ */

#undef UNIX_BSD
#define UNIX_BSD		1
#endif /* ultrix */

#if    unixpc	/* UNIX PC (System V) */
#undef UNIX_ATT
#define UNIX_ATT		1
#endif /* unixpc */

#if    usg	/* AT&T UNIXes may be define this (GNU EMACS uses USG) */
#undef UNIX_ATT
#define UNIX_ATT		1
#endif /* usg */

#if   (OS_ATARI || OS_PCDOS || OS_PRIMOS || OS_RMX || OS_TOPS20)
#else /* NOT (OS_ATARI || OS_PCDOS || OS_PRIMOS || OS_RMX || OS_TOPS20) */
#if   (OS_UNIX || OS_VAXVMS || OS_VMCMS)
#else /* NOT (OS_UNIX || OS_VAXVMS || OS_VMCMS) */
			/* OS_UNIX is default if no operating system defined */
#undef OS_UNIX
#define OS_UNIX			1
#endif /* (OS_UNIX || OS_VAXVMS || OS_VMCMS) */
#endif /* (OS_ATARI || OS_PCDOS || OS_PRIMOS || OS_RMX || OS_TOPS20) */

#ifndef STDC
#define STDC			0
#endif /* STDC */

/***********************************************************************
Here are O/S- and compiler-specific sections to redefine HAVE_xxx
flags that must be changed.
***********************************************************************/

#if    STDC
#undef HAVE_CONST_TYPE
#undef HAVE_PROTOTYPES
#undef HAVE_VOIDP
#undef HAVE_VOLATILE_TYPE
#undef HAVE_SIZE_T
#undef HAVE_TIME_T

#define HAVE_CONST_TYPE		1

#if sun
#if (__ACC__ || __APOGEE__ || __solaris)
#define HAVE_FPOS_T		1
 /* cc, gcc, and g++ stdio.h lack it on SunOS, but have it on Solaris 2.x */
#endif /*  (__ACC__ || __APOGEE__ || __solaris) */
#endif /* sun */

#define HAVE_PROTOTYPES		1
#define HAVE_SIZE_T		1
#define HAVE_TIME_T		1
#define HAVE_VOIDP		1
#define HAVE_VOLATILE_TYPE	1
#endif /* STDC */

#if    OS_ATARI
#undef HAVE_SYS_DIR
#endif /* OS_ATARI */

#if    OS_PCDOS
#undef HAVE_GETWD_DCL
#undef HAVE_FILE_H
#undef HAVE_PARAM_H
#define HAVE_MEMXXX_DCL		1
#endif /* OS_PCDOS */

#if    OS_PRIMOS
#undef HAVE_ERRNO_H
#endif /* OS_PRIMOS */

#if    OS_RMX
#endif /* OS_RMX */

#if    OS_TOPS20
#if    KCC_20 && !STDC
#undef HAVE_SYS_DIR
#endif /* KCC_20 && !STDC */
#endif /* OS_TOPS20 */

#if    OS_UNIX
#undef HAVE_PWD_H
#define HAVE_PWD_H		1

#if    !(UNIX_ATT || UNIX_BSD)
#undef UNIX_BSD
#define UNIX_BSD		1	/* UNIX_BSD is default UNIX variant */
#endif /* !(UNIX_ATT || UNIX_BSD) */
#endif /* OS_UNIX */

#if    OS_VAXVMS
#undef HAVE_SYS_DIR
#define HAVE_SYS_DIR		0
#endif /* OS_VAXVMS */

#if    OS_VMCMS
#undef HAVE_SYS_DIR
#undef HAVE_ERRNO_H
#endif /* OS_VMCMS */

/* A few implementations know about const, even though they are not
yet Standard C.  For the rest, make the type an empty string. */

#if !HAVE_CONST_TYPE
#define const
#endif /* !HAVE_CONST_TYPE */

#if !HAVE_CLOCK_T
typedef	long clock_t;
#endif /* !HAVE_CLOCK_T */

#if !HAVE_FPOS_T
typedef long fpos_t;
#endif /* !HAVE_FPOS_T */

#if HAVE_PROTOTYPES
#define ARGS(parenthesized_list) parenthesized_list
#else /* NOT HAVE_PROTOTYPES */
#define ARGS(parenthesized_list) ()
#endif /* HAVE_PROTOTYPES */

#if !HAVE_SIZE_T
typedef unsigned int size_t;
#endif /* !HAVE_SIZE_T */

#if !HAVE_TIME_T
typedef long time_t;
#endif /* !HAVE_TIME_T */

#ifdef VOIDP
#undef VOIDP
#endif
#if HAVE_VOIDP
#define VOIDP			void*
#else  /* NOT HAVE_VOIDP */
#define VOIDP			char*
#endif /* HAVE_VOIDP */

#if !HAVE_VOLATILE_TYPE
#define volatile
#endif /* !HAVE_VOLATILE_TYPE */

/***********************************************************************
The system limit on the number of open files usually is set in a system
include file, but regrettably has no standard name.  The following have
been observed:

--------	-------------	------------------------------------------
Name		Definition	System
--------	-------------	------------------------------------------
IOFILES		<stdio.h>	Wizard C
NFILE		<stdio.h>	V7 UNIX
NOFILE		<sys/param.h>	Sun OS (4.2BSD), 4.3BSD and Gould UTX/32
OPEN_MAX	<limits.h>	POSIX, DEC Alpha (OSF/1)
OPEN_MAX	<stdio.h>	Turbo C 2.0
SYS_OPEN	<stdio.h>	KCC-20, Turbo C 2.0, Microsoft C 5.0,
				Wizard C
_NFILE		<stdio.h>	VAX VMS, NMTCC-20, PCC-20, SYS V, HPUX,
				Microsoft C 5.0, Lattice C, Primos,
				IBM AIX (370, PS/2, RT)
_NFILE		<sys/param.h>	KCC-20
FOPEN_MAX	<stdio.h>	Intel RMX, IBM AIX (RS), DEC Alpha (OSF/1)
--------	-------------	------------------------------------------

We use a private symbol OPENMAX;  it is needed for cached-font support
in gblvars.h.
***********************************************************************/

/* Include stdio.h, and if available, param.h, and maybe, limits.h */

#include <stdio.h>

#if HAVE_PARAM_H
#if HAVE_SYS_DIR
#include <sys/param.h>
#else /* HAVE_SYS_DIR */
#include <param.h>
#endif /* HAVE_SYS_DIR */
#endif /* HAVE_PARAM_H */

#ifndef OPENMAX
#ifdef FOPEN_MAX
#define OPENMAX			FOPEN_MAX
#endif /* FOPEN_MAX */
#endif /* OPENMAX */

#ifndef OPENMAX
#ifdef NFILE
#define OPENMAX			NFILE
#endif /* NFILE */
#endif /* OPENMAX */

#ifndef OPENMAX
#ifdef _NFILE
#define OPENMAX			_NFILE
#endif /* _NFILE */
#endif /* OPENMAX */

#ifndef OPENMAX
#ifdef NOFILE
#define OPENMAX			NOFILE
#endif /* NOFILE */
#endif /* OPENMAX */

#ifndef OPENMAX
#ifdef SYS_OPEN
#define OPENMAX			SYS_OPEN
#endif /* SYS_OPEN */
#endif /* OPENMAX */

#ifndef OPENMAX
#include <limits.h>
#ifdef OPEN_MAX
#define OPENMAX			OPEN_MAX
#endif /* OPEN_MAX */
#endif /* OPENMAX */

#ifndef OPENMAX
/* Cause a compilation error */
??? cannot find needed definition of OPENMAX ???
#endif /* OPENMAX */

/***********************************************************************
The limit on file name lengths is similarly non-standard.

--------	-------------	------------------------------------------
Name		Definition	System
--------	-------------	------------------------------------------
FNMAX		<stdio.h>	PCC-20
MAXPATH		<dir.h>		Turbo C 2.0, C and C++ 3.0, and TopSpeed C
_MAX_PATH	<stdlib.h>	Microsoft C 5.0, 6.0, 7.0 and TopSpeed C
MAXPATHLEN	<sys/param.h>	Sun OS (4.2BSD), 4.3BSD, Gould UTX/32,
				HPUX, KCC-20, AIX (RT, RS, PS/2, 370),
				HP/Apollo DomainOS, DEC Alpha (OSF/1)
PATH_MAX	<stdio.h>	SYS V (Silicon Graphics)
PATH_MAX	<limits.h>	POSIX, DEC Alpha (OSF/1)
FILENAME_MAX	<stdio.h>	Intel RMX, NeXT Mach, Turbo C/C++ 3.0
--------	-------------	------------------------------------------

We already have included <sys/param.h>, <limits.h>, and <stdio.h>.  If
we cannot find preset values, we set values based on experience; this
parameter is less critical than OPENMAX.  MAXPATHLEN should also be
long enough to hold a file search path from an environment variable;
on systems with small MAXPATHLEN values, this may be a problem.
***********************************************************************/

#ifndef MAXPATHLEN
#ifdef PATH_MAX
#define MAXPATHLEN		PATH_MAX
#endif /* PATH_MAX */

#ifdef FNMAX

#ifdef MAXPATHLEN
#undef MAXPATHLEN
#endif /* MAXPATHLEN */

#define MAXPATHLEN		FNMAX
#endif /* FNMAX */

#ifdef FILENAME_MAX

#ifdef MAXPATHLEN
#undef MAXPATHLEN
#endif /* MAXPATHLEN */

#define MAXPATHLEN		FILENAME_MAX
#endif /* FILENAME_MAX */

#endif /* MAXPATHLEN */

#if OS_VAXVMS
#undef MAXPATHLEN		/* value of 39 is too small--reset below */
#endif /* OS_VAXVMS */

#ifndef MAXPATHLEN

#if    OS_ATARI
#define MAXPATHLEN		128
#endif /* OS_ATARI */

#if    OS_PCDOS
#define MAXPATHLEN		260	/* used to be 80, but recent DOS */
					/* C compilers have 260 */
#endif /* OS_PCDOS */

#if    OS_PRIMOS
#define MAXPATHLEN		128 /* not in system .h files */
#endif /* OS_PRIMOS */

#if    OS_RMX
#define MAXPATHLEN		64
#endif /* OS_RMX */

#if    OS_TOPS20
#define MAXPATHLEN		288
#endif /* OS_TOPS20 */

#if    OS_UNIX
#define MAXPATHLEN		1024	/* from <sys/param.h> in 4.3BSD */
#endif /* OS_UNIX */

#if    OS_VAXVMS
#define MAXPATHLEN		512	/* value uncertain */
#endif /* OS_VAXVMS */

#if    OS_VMCMS
#define MAXPATHLEN		128	/* value uncertain */
#endif /* OS_VMCMS */

#endif /* MAXPATHLEN */

/***********************************************************************
fopen() mode flags differ between systems.  Here are symbolic values:
	R_OPEN		-- text read
	RB_OPEN		-- binary read
	RW_OPEN		-- text read/write
	W_OPEN		-- text write
	WB_OPEN		-- binary write
***********************************************************************/

#define R_OPEN			"r"
#define RB_OPEN			"r"
#define RW_OPEN			"w+"
#define W_OPEN			"w"
#define WB_OPEN			"w"

#if    OS_PCDOS
#undef RB_OPEN
#define RB_OPEN			"rb"

#undef WB_OPEN
#define WB_OPEN			"wb"
#endif /* OS_PCDOS */

#if    OS_PRIMOS
#undef HAVE_TYPES_H
#undef RB_OPEN
#define RB_OPEN			"i"

#undef RW_OPEN
#define RW_OPEN			"w"

#undef WB_OPEN
#define WB_OPEN			"o"
#endif /* OS_PRIMOS */

#if    OS_TOPS20
#undef RB_OPEN
#define RB_OPEN			"rb"

#undef WB_OPEN
#define WB_OPEN			"wb"
#endif /* OS_TOPS20 */

#if    OS_VAXVMS
#undef RB_OPEN
#define RB_OPEN			"rb"

#undef WB_OPEN
#define WB_OPEN			"wb"
#endif /* OS_VAXVMS */

#include "xstddef.h"
#include "xerrno.h"

/***********************************************************************
On [02-Nov-1991], driver development on UNIX was placed under the
Revision Control System (RCS).  For now, RCSID() will always generate
a static RCS version string.  We may later wish to suppress this to
conserve memory on small systems.  Thus, the expansion includes a
semicolon so that it can be made to completely disappear if we wish.
A typical initial usage is RCSID("<dollar>Id<dollar>"), where <dollar>
is a literal dollar sign.
***********************************************************************/

#if OS_UNIX
#define RCSID(s) static char rcsid[] = s;
#else /* NOT OS_UNIX */
#define RCSID(s)
#endif /* OS_UNIX */

#if STDC
#define VOID_ARG	void
#else
#define VOID_ARG
#endif /* STDC */

#endif /* OS_H_DEFINED_ */
