/* -*-C-*- xstring.h */
/**********************************************************************/
/****************************** string ********************************/
/**********************************************************************/

/* $Id: xstring.h,v 1.8 1993/12/29 18:40:38 beebe Exp beebe $*/

#ifndef XSTRING_H_DEFINED_	/* file ignored if included more than once */
#define XSTRING_H_DEFINED_

#ifndef OS_H_DEFINED_
#include "os.h"
#endif /* OS_H_DEFINED_ */

/* Standard C, System V, and BSD 4.3 call this <string.h>.  BSD 4.1 called it
<strings.h> */

#if    STDC
#include <string.h>		/* get the host version */

#if __GNUG__ && !__NeXT__
extern "C"
{	/* missing from /usr/local/lib/g++-include/string.h in g++ 2.0 */
VOIDP		memmove ARGS((VOIDP dest_,  const VOIDP src_,  size_t n_));
char		*strerror ARGS((int errnum_));
};
#endif /* __GNUG__ && !__NeXT__ */


#if    !HAVE_MEMXXX_DCL
/* Some systems have these in memory.h, but without argument
declarations, and sometimes, with wrong return types.  We use the
Standard C declarations here, rather than using memory.h, because the
latter causes other conflicts that we wish to avoid.  */
VOIDP		memccpy ARGS((VOIDP dest_,  const VOIDP src_,  int c_,
		    size_t n_));	/* Extension to Standard C */
VOIDP		memchr	ARGS((const VOIDP s_,  int c_,  size_t n_));
int		memcmp	ARGS((const VOIDP s1_,  const VOIDP s2_,
		    size_t n_));
VOIDP		memcpy	ARGS((VOIDP dest_,  const VOIDP src_,  size_t n_));
int		memicmp ARGS((const VOIDP s1_,  const VOIDP s2_,
		    size_t n_));	/* Extension to Standard C */
VOIDP		memmove ARGS((VOIDP dest_,  const VOIDP src_,  size_t n_));
VOIDP		memset	ARGS((VOIDP s_,  int c_,  size_t n_));
#endif /* !HAVE_MEMXXX_DCL */

#else /* NOT STDC */

#include "xtypes.h"

/* Strictly, size_t must be defined in Standard C's string.h, but
since it is usually typedef'ed, e.g. "typedef long size_t" or "typedef
int size_t", sometimes with the unsigned attribute, we have no way of
checking here for a prior definition, so we can do nothing for it. */

#ifndef NULL
#if    KCC_20
/* has its own version in stdio.h */
#else  /* NOT KCC_20 */
#define NULL			((VOIDP) 0L)	/* this is SYSTEM-DEPENDENT */
#endif /* KCC_20 */
#endif /* NULL */

/* Some UNIX systems have the memxxx() functions in <memory.h>.
Standard C puts them in <string.h>. */

VOIDP		memccpy ARGS((VOIDP dest_,  const VOIDP src_,  int c_,
		    size_t n_));	/* Extension to Standard C */
VOIDP		memchr	ARGS((const VOIDP s_,  int c_,  size_t n_));
int		memcmp	ARGS((const VOIDP s1_,  const VOIDP s2_,
		    size_t n_));
VOIDP		memcpy	ARGS((VOIDP dest_,  const VOIDP src_,  size_t n_));
int		memicmp ARGS((const VOIDP s1_,  const VOIDP s2_,
		    size_t n_));	/* Extension to Standard C */
VOIDP		memmove ARGS((VOIDP dest_,  const VOIDP src_,  size_t n_));
VOIDP		memset	ARGS((VOIDP s_,  int c_,  size_t n_));
char		*strcat ARGS((char *s1_,  const char *s2_));
char		*strchr ARGS((const char *s_,  int character_));
int		strcmp ARGS((const char *s1_,  const char *s2_));
int		strcoll ARGS((const char *s1_, const char *s2_));
char		*strcpy ARGS((char *s1_,  const char *s2_));
size_t		strcspn ARGS((const char *s1_,  const char *s2_));
char		*strerror ARGS((int errnum_));
size_t		strlen ARGS((const char *s_));
char		*strncat ARGS((char *s1_,  const char *s2_,  size_t n_));
int		strncmp ARGS((const char *s1_,  const char *s2_,
		    size_t n_));
char		*strncpy ARGS((char *s1_,  const char *s2_,  size_t n_));
char		*strpbrk ARGS((const char *s1_,  const char *s2_));
char		*strrchr ARGS((const char *s_,  int character_));
size_t		strspn ARGS((const char *s1_,  const char *s2_));
char		*strstr ARGS((const char *s1_,  const char *s2_));
char		*strtok ARGS((char *s1_,  const char *s2_));
size_t		strxfrm ARGS((char *to_, const char *from_,
		    size_t maxsize_));
#endif /* STDC */

/* Define a few additional functions used in the DVI driver family */

/* strdup() proved to have too many implementation variants, so we */
/* use a private version everywhere, but always invoke it by the macro */
/* name, STRDUP, to facilitate alteration in the event of name conflicts. */

#undef STRDUP
#define STRDUP	Strdup
char 		*Strdup ARGS((const char * s_));
int		stricmp ARGS((const char *, const char *));
char		*stristr ARGS((const char *s_, const char *sub_));
int		strnicmp ARGS((const char *s1_, const char *s2_, size_t n_));

#endif /* XSTRING_H_DEFINED_ */
