.\" -*-nroff-*-
.\" ====================================================================
.\"  @Troff-man-file{
.\"     author          = "Nelson H. F. Beebe",
.\"     version         = "0.04",
.\"     date            = "09 March 2001",
.\"     time            = "12:24:58 MST",
.\"     filename        = "biblabel.man",
.\"     address         = "Center for Scientific Computing
.\"                        University of Utah
.\"                        Department of Mathematics, 322 INSCC
.\"                        155 S 1400 E RM 233
.\"                        Salt Lake City, UT 84112-0090
.\"                        USA",
.\"     telephone       = "+1 801 581 5254",
.\"     FAX             = "+1 801 585 1640, +1 801 581 4148",
.\"     URL             = "http://www.math.utah.edu/~beebe",
.\"     checksum        = "25421 867 3495 24995",
.\"     email           = "beebe@math.utah.edu, beebe@acm.org,
.\"                        beebe@computer.org, beebe@ieee.org,
.\"                        (Internet)",
.\"     codetable       = "ISO/ASCII",
.\"     keywords        = "bibliography, BibTeX, citation label, LaTeX,
.\"                        TeX",
.\"     supported       = "yes",
.\"     docstring       = "This file contains the UNIX manual pages
.\"                        for the biblabel utility, a program for
.\"                        generating new BibTeX citation labels
.\"                        standardized to the BibNet Project form,
.\"                        Lastname:year:abbrev.  The companion
.\"                        program, citesub, can be used to carry out
.\"                        the substitutions on BibTeX, LaTeX, and TeX
.\"                        files.
.\"
.\"                        The checksum field above contains a CRC-16
.\"                        checksum as the first value, followed by the
.\"                        equivalent of the standard UNIX wc (word
.\"                        count) utility output of lines, words, and
.\"                        characters.  This is produced by Robert
.\"                        Solovay's checksum utility.",
.\"  }
.\" ====================================================================
.if t .ds Bi B\s-2IB\s0T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Bi BibTeX
.if t .ds La L\\h'-0.24m'\\v'-0.15v'\\s-2A\\s+2\\h'-0.15m'\\v'0.15v'T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds La LaTeX
.if t .ds Te T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Te TeX
.TH BIBLABEL 1 "09 March 2001" "Version 0.04"
.\"===============================================
.SH NAME
biblabel \- generate standardized BibTeX citation labels
.\"===============================================
.SH SYNOPSIS
.B biblabel
[
.B \-\|\-?
]
.if n .ti +9n
[
.B \-\|\-author
]
.if n .ti +9n
[
.B \-\|\-copyright
]
.if n .ti +9n
.if t .ti +\w'\fBbiblabel\fP\ 'u
[
.BI \-\|\-corporate-file " input-words-to-ignore-file"
]
.if n .ti +9n
[
.BI \-\|\-dump-corporate-file " output-file"
]
.if n .ti +9n
.if t .ti +\w'\fBbiblabel\fP\ 'u
[
.BI \-\|\-dump-ignore-file " output-file"
]
.if n .ti +9n
[
.BI \-\|\-dump-label-file " output-file"
]
.if n .ti +9n
[
.B \-\|\-help
]
.if n .ti +9n
.if t .ti +\w'\fBbiblabel\fP\ 'u
[
.BI \-\|\-ignore-file " input-words-to-ignore-file"
]
.if n .ti +9n
[
.B \-\|\-long-corporate-names
]
.if n .ti +9n
.if t .ti +\w'\fBbiblabel\fP\ 'u
[
.BI \-\|\-used-file " input-labels-in-use-file"
]
.if n .ti +9n
[
.B \-\|\-version
]
.if n .ti +9n
.if t .ti +\w'\fBbiblabel\fP\ 'u
.RI [ \*(Bi\&file(s) ]
.RI > outpub-citesub-file
.\"===============================================
.SH DESCRIPTION
.B biblabel
filters a \*(Bi\& bibliography, or bibliography
fragment, on its standard input, or one or more
bibliographies named on the command line, and
prints on standard output,
.IR stdout ,
lines containing pairs of old and new citation
labels, suitable for input to the companion
program,
.BR citesub (1).
.PP
The citation label is formed by these rules, easily
applicable by a human, or by a computer program
like this one:
.RS
.TP \w'(1)'u+2n
(1)
Take the first author's last name, dropping
apostrophes, Jr/Sr/generation numbers, protecting
braces, and eliminating accents (e.g., J{\e"a}nsch ->
Jaensch, and Jind\ev{r}ich -> Jindrich), using
multi-letter transliterations if that is conventional.
Preserve hyphenated names, like Baeza-Yates, in full.
.TP
(2)
Append a colon.
.TP
(3)
Append the four-digit year of publication.
.TP
(4)
Append another colon.
.TP
(5)
Pick the initial letters of at most
.I three
of the leading important words in the title that
begin with a letter, excluding articles,
prepositions, and \*(Te\& math mode, and append
those letters.
.IP
For example, given the title
.IR "{Euler}'s Constant to $1271$ Places" ,
(from an article by Donald E. Knuth in Mathematics of Computation,
.BR 16 (79)
275--281, July 1962)
this recipe produces
.IR ECP .
.TP
(6)
If the resulting citation label is already in use,
add a letter
.IR a ,
.IR b ,
.IR c ,
\|.\|.\|. to make it unique.  In those rare cases
when there are more than 26 such collisions, add
additional letters, producing suffixes written in
a base-26 number system in ascending order:
.IR a .\|. z,
.IR aa  .\|. az ,
.IR ba  .\|. bz ,
\&.\|.\|.,
.IR za  .\|. zz ,
.IR aaa  .\|. aaz ,
\&.\|.\|.,
.IR zza  .\|. zzz ,
.IR aaaa  .\|. aaaz ,
\&.\|.\|.,
.IR zzza  .\|. zzzz ,
\&.\|.\|..
.RE
.PP
This will produce a label like Smith:1994:ABC.
.PP
The reason for including a four-digit year is that
the worldwide Y2K problem at the millennium change
amply demonstrated the foolishness of two-digit
year abbreviations.  Also, some bibliographies may
be historical, with entries dating back hundreds
of years.  Using a four-digit year will keep sorts
of otherwise identical keys in chronological
order, and putting the year before the key derived
from the title will facilitate sorting by year by,
e.g.,
.BR bibsort (1).
.PP
Because any change in citation labels must be
accompanied by a change in citations in all
documents that use the bibliography, it is not
sufficient to just produce a new bibliography file
with changed labels.  Consequently, the output of
.B biblabel
is expected to be saved, and subsequently used
with
.BR citesub (1)
to actually carry out the substitutions
efficiently.  If no documents other than the
bibliography file itself need to be changed, then
a simple UNIX or IBM PC DOS pipeline of the form
.PP
.RS
.nf
.I "biblabel <foo.bib | citesub -f - foo.bib >foo.new
.fi
.RE
.PP
will produce a new bibliography file with all of
the citation labels changed to the new
standardized form.
.PP
To avoid confusion between labels with common
prefixes, such as
.I Smith80
and
.IR Smith80a ,
.BR citesub (1)
will check for leading context of a left brace,
quote, comma, whitespace, or beginning of line and
trailing context of a right brace, comma, quote,
percent, whitespace, or end of line so as to match
these styles:
.PP
.RS
.nf
@Book{Smith:1980:ABC,

crossref = "Smith:1980:ABC",

crossref = {Smith:1980:ABC},

\ecite{Smith:1980:ABC}

\ecite{Smith:1980:ABC,Jones:1994:DEF}

\ecite{%
       Smith:1980:ABC,%
       Jones:1994:DEF%
}
.fi
.RE
.PP
Created labels are guaranteed to be unique
within the input files provided on the
command line.
.PP
However, in a larger project, one may wish to
exclude labels that are already in use in other
bibliographies.  To provide for this, the
.B \-\|\-used-file
option can be specified to define the name of a
file of labels that are already in use.
.PP
When a label is found in use, and the current
file matches the in-use label filename, the
label is considered to be unused; otherwise,
repeated runs through this program would keep
changing already-assigned labels.
.\"===============================================
.SH OPTIONS
Unless otherwise noted, all command-line options
may be abbreviated to a unique leading prefix, and
letter case is
.I not
significant.
.PP
All options are parsed before any input
bibliography files are read, no matter what their
order on the command line.
.PP
The leading hyphen that distinguishes an option
from a filename may be doubled, for compatibility
with GNU and POSIX conventions.  Thus,
.B \-author
and
.B \-\-author
are equivalent.
.PP
Except for the options described below, all other
command-line words are assumed to be input files.
Should such a filename begin with a hyphen, it
must be disguised by a leading absolute or
relative directory path, e.g.,
.I /tmp/-foo.bib
or
.IR ./-foo.bib .
.PP
.\"-----------------------------------------------
.TP \w'\-\|\-copyright'u+2n
.B \-\|\-author
Display an author credit on
.IR stderr ,
and then terminate with a success return code
(0 on UNIX).
.\"-----------------------------------------------
.TP
.B \-\|\-copyright
Display a copyright statement on
.IR stderr ,
and then terminate with a success return code
(0 on UNIX).
.IP
This option may be abbreviated
.BR \-\|\-c .
.\"-----------------------------------------------
.TP
.BI \-\|\-corporate-file " input-words-to-ignore-file"
Specify the name of a file containing additional words
(one or more per line) to be added to the internal
corporate name ignore list, after converting to
lowercase and stripping nonletters.  Such words, and
all words in the normal ignore list, are not considered
when corporate name abbreviations are constructed.
.IP
Multiple
.B \-\|\-corporate-file
options may be specified.
.IP
See also the
.B "INITIALIZATION FILES"
section below.
.\"-----------------------------------------------
.TP
.BI \-\|\-dump-corporate-file " output-file"
Dump the corporate name ignore list on the
specified file, and then terminate with a success
return code.  This file is valid for subsequent
use with the
.B \-\|\-corporate-file
option.
.IP
To avoid disastrous overwriting of a bibliography
file in the event of a command-line mistake, the
output file must not yet exist.
.\"-----------------------------------------------
.TP
.BI \-\|\-dump-label-file " output-file"
Dump the labels-in-use list on the specified file.
This file is valid for subsequent use with the
.B \-\|\-used-file
option.
.IP
Unlike the other dump options, which are processed at
startup time, this option is processed only at the
end of a successful execution.
.IP
To avoid disastrous overwriting of a bibliography
file in the event of a command-line mistake, the
output file must not yet exist.
.\"-----------------------------------------------
.TP
.BI \-\|\-dump-ignore-file " output-file"
Dump the ignore list on the specified file, and
then terminate with a success return code.  This
file is valid for subsequent use with the
.B \-\|\-ignore-file
option.
.IP
To avoid disastrous overwriting of a bibliography
file in the event of a command-line mistake, the
output file must not yet exist.
.\"-----------------------------------------------
.TP
.BI \-\|\-f " labels-in-use-file"
This option is deprecated, but retained for
compatibility with versions of
.B biblabel
prior to version 0.04.  It may be removed in a later
version.  See instead the
.BI \-\|\-used-file
description below.
.\"-----------------------------------------------
.TP
.BR \-\|\-help " or " \-\|\-?
Display a brief help message on
.IR stderr ,
and then terminate execution immediately with a
success return code (0 on UNIX).
.\"-----------------------------------------------
.TP
.BI \-\|\-ignore-file " words-to-ignore-file"
Specify the name of a file containing additional
words (one or more per line) to be added to the
internal ignore list, after converting to
lowercase and stripping nonletters.  Such words
are ignored when the up-to-three-letter title
abbreviations, and corporate name abbreviations,
are constructed.
.IP
Multiple
.B \-\|\-ignore-file
options may be specified.
.IP
See also the
.B "INITIALIZATION FILES"
section below.
.\"-----------------------------------------------
.TP
.B \-\|\-long-corporate-names
Do not abbreviate corporate names.
.IP
Without this option, a braced corporate
author/editor string of
.I "{Free Software Foundation}"
is reduced to
.IR FSF .
With this option, it becomes
.IR Free-Software-Foundation .
.IP
Single-word corporate names are never abbreviated
to an initial:
.I IBM
remains that way, instead of being reduced to
.IR I .
.\"-----------------------------------------------
.TP
.BI \-\|\-used-file " labels-in-use-file"
Specify the name of a file containing citation
labels already in use.
.IP
Each line consists of a whitespace-separated pair
of filename and citation label.  Inclusion of the
filename in which the label is already in use is
required, both so that it can be used in
diagnostic messages, and to avoid unnecessary
changes to labels in the current file.
.IP
This option can be used in a multi-file
bibliography collection to guarantee unique
citation labels across the entire collection.
.IP
Multiple
.B \-\|\-used-file
options may be specified.
.IP
See also the
.B "INITIALIZATION FILES"
section below.
.\"-----------------------------------------------
.TP
.B \-\|\-version
Display a program version number and date on
.IR stderr ,
and then terminate with a success return code
(0 on UNIX).
.\"===============================================
.SH "INITIALIZATION FILES"
To make it easy to have personal customized lists
of words to be ignored, and labels in use, on
startup,
.B biblabel
looks for default initialization files, and then
processes any additional files specified by
command-line
.BR \-\|\-corporate-file ,
.BR \-\|\-ignore-file ,
and
.B \-\|\-used-file
options.
.PP
These files may contain:
.TP \w'\(bu'u+2n
\(bu
Comments, which run from a percent (%) or sharp
(#) character anywhere on the line to the end of
that line.  Comments are stripped
.I before
any further processing.
.TP
\(bu
Empty lines containing zero or more space and/or
tab characters.  Such lines are ignored.
.TP
\(bu
Data lines.
.PP
The three default optional initialization files are:
.TP \w'\fIbiblabel.cig\fP'u+2n
.I biblabel.cig
List of words to add to the internal corporate
name ignore list, after converting to lowercase
and stripping nonletters.
.TP
.I biblabel.ign
List of words to add to the internal ignore list,
after converting to lowercase and stripping
nonletters.
.TP
.I biblabel.use
List of citation labels already in use, together
with the names of the files in which they are used.
.IP
Each line consists of a whitespace-separated pair
of filename and citation label.
.PP
If these files exist, they must be in the current
directory.
.PP
To make it possible to override the built-in
ignore list, if the special word
.I @RESET@
appears in any ignore-list file, then it, and all
entries in the internal list, are immediately
forgotten.
.PP
For consistency, this special word is also
recognized in labels-in-use files, but has limited
utility since there is no built-in citation label
table.  It could nevertheless be useful if
.B biblabel
were wrapped inside another script, or a shell
alias, which themselves provided command-line
initialization files.
.\"===============================================
.SH "INTERNAL DEFAULTS"
.B biblabel
starts with a built-in ignore list, containing
lowercase forms of words that are to be ignored
when forming the up-to-three-letter title
abbreviations, and corporate name abbreviations.
It then augments that built-in list with the
contents of any
.I biblabel.ign
file in the current directory, plus any files
specified with
.B \-\|\-ignore-file
options.
.PP
Here is the built-in ignore list, taken directly
from the output file created by the
.B \-\|\-dump-ignore-file
option.  To conserve space here, the original
one-word-per-line list has been reformatted into
paragraphs of words with common initial letters.
.RS
.nf
\&\fC
%% Title: Dump of ignore list
%% CreationDate: Fri Mar  9 10:16:31 MST 2001
%% Creator: biblabel version 0.04 [06-Mar-2001]
%% For: Nelson H. F. Beebe <beebe@suncore.math.utah.edu>
%% Directory: /u/sy/beebe/tex/biblabel/biblabel-0.04

a ab aber als also am an and any are as at auf aus aux
away az

be bei bin bir bist but by

cum

da dans das dat de dei dem den der des det di die dos
down

e een eene egy ei ein eine einen einer eines eit el en
er es et ett eyn eyne

for from fuer fur

gehabt gl gli

ha hab habe haben habt had haette hai has hast hat
hatte have he heis hen hena henas het hin hinar hinir
hinn hith ho hoi

i il in into is ist its

ka ke

l la las le les lo los

mia mit

n na ne nicht nji not

o oben oder of off ohne on onto or os others out over

pas

s seid sie sind so sur

t ta that the these this those to

uber um uma un una und une uno unter unto up

via vom von

with without

y yr

zu zum zur\fP
.fi
.RE
.PP
.B biblabel
also has a much shorter built-in list of words to be
ignored when forming corporate name abbreviations.  The
list is small, because all words from the main ignore
list are also excluded when forming such abbreviations.
.B biblabel
augments the built-in list with the contents of any
.I biblabel.cig
file in the current directory, plus any files
specified with
.B \-\|\-corporate-file
options.
.PP
Here is the built-in corporate ignore list, taken
directly from the output file created by the
.B \-\|\-dump-corporate-file
option.  To conserve space here, the original
one-word-per-line list has been reformatted into
paragraphs of words with common initial letters.
.RS
.nf
\&\fC
%% Title: Dump of corporate ignore list
%% CreationDate: Fri Mar  9 10:22:54 MST 2001
%% Creator: biblabel version 0.04 [06-Mar-2001]
%% For: Nelson H. F. Beebe <beebe@suncore.math.utah.edu>
%% Directory: /u/sy/beebe/tex/biblabel/biblabel-0.04

co company corp corporation

gmbh group

inc incorporated

limited ltd

staff

team\fP
.fi
.RE
.PP
There are no internal defaults for the list of
citation labels already in use.  That list is
initialized from any
.I biblabel.use
file in the current directory, plus any files
specified with
.B \-\|\-used-file
options.
.\"===============================================
.SH "DIAGNOSTIC MESSAGES"
.B biblabel
issues diagnostic messages on
.I stderr
in the standard form
.IR "filename:linenumber:message-text" .
When the program is run under an advanced text
editor like
.BR emacs (1)
or
.BR vim (1),
the editor can then jump to the error location
with only a keystroke or two.
.PP
Here, in alphabetical order, are the messages that
.B biblabel
can produce, with brief explanations.  Each is
prefixed with an uppercase word denoting the
severity level.
.\"-----------------------------------------------
.TP \w'\(bu'u+1n
.I "ERROR: duplicate citation label [xxx]"
This condition will definitely cause erroneous
substitutions when
.BR citesub (1)
is used, so the error
.I must
be corrected and
.B biblabel
run again on the corrected file.
.\"-----------------------------------------------
.TP
.I "NOTE: generational suffixes are normally not preceded by a comma: [xxx]"
See the next diagnostic description.
.\"-----------------------------------------------
.TP
.I "NOTE: Junior-like suffixes are normally preceded by a comma: [xxx]"
Although a few authors (e.g., noted computer
scientist Guy L. Steele Jr.) omit the separating
comma before the suffix, it is usually a coding
mistake in the \*(Bi\& file.
.IP
This practice may be changing in American English:
the widely-followed
.IR "Chicago Manual of Style" ,
14th ed., University of Chicago Press (Chicago and
London), 1993, ISBN 0-226-10389-7, notes in
section 8.55 on p. 307:
.RS
.RS
.I Traditionally,
Jr.
.I and
Sr.
.I "have been set off with commas, whereas"
.RI I ,
.RI II ,
.RI III ,
.RI IV ,
.I "and so on have not.  This tradition is still"
.I "widely followed, and the University of Chicago"
.I "Press recognizes and accepts it; but the Press now"
.I "also accepts, and in fact recommends, that the"
.I "commas be omitted in both cases."
.RE
.RE
.IP
On the other hand, the
.IR "MLA Handbook for Writers of Research Papers" ,
4th ed., Modern Language Association of America
(New York), 1996, ISBN 0-87352-565-5, in section
4.6.1 on p. 110, wants a comma before all such
suffixes.
.IP
Strunk and White's
.IR "The Elements of Style"
3rd ed., Macmillan (New York), 1979, ISBNs
0-02-418230-3 and 0-02-418220-6, on p. 3 says to
omit the comma before
.IR Jr. ,
but to include it before
.I Ph.D.
and
.I S.J.
suffixes.
.IP
.IR "Words into Type" ,
3rd ed., Prentice Hall (Englewood Cliffs, NJ),
1974, ISBN 0-13-964262-5, recommends the comma
before
.I Jr.
and
.IR Sr. ,
but notes that newspapers frequently omit it.
.IP
The
.IR "ACS Style Guide" ,
2nd ed., American Chemical Society (Washington,
DC), 1997, ISBNs 0-8412-3461-2 and 0-8412-3462-0,
requires a comma before
.I Jr.
and
.IR Sr. ,
but says to treat roman numeral suffixes according
to the person's preference.
.IP
In other words, style manuals don't agree!
.BR biblabel 's
diagnostic is thus only informational.
.\"-----------------------------------------------
.TP
.I "PORTABILITY: unexpected 8-bit character(s) found in author/editor name [xxx]"
For maximum portability across systems, \*(Bi\&
files should not use characters outside of the
7-bit ASCII character set, since standard \*(Te\&
control sequences can represent all needed
accents.  Even at sites where extended 8-bit
encodings are used in \*(Te\& and \*(La\& files
for convenience and improved hyphenation, those
files can remain site-specific, while the
bibliography database can be shared worldwide.
.IP
This message cannot be raised unless the
underlying
.BR awk (1)
implementation supports 8-bit characters in
regular-expression patterns.
.BR gawk (1)
and
.BR mawk (1)
do, but others may not.
.\"-----------------------------------------------
.TP
.I "WARNING: incomplete accent removal [xxx] -> [yyy]"
.B biblabel
contains many heuristic reductions of accented
letters to unaccented ones, but occasionally an
accent combination is met that it cannot
recognize, and the result is that the generated
label may not be exactly what was intended.  Only
rarely will manual editing of the output
substitution file be necessary.
.\"-----------------------------------------------
.TP
.I "WARNING: unexpected standalone Junior-like name suffix [xxx]"
A name suffix (Jr., Sr., III, .\|.\|.)  was found
where a full name was expected.  This can happen
when simple-minded software tools are used to
convert bibliographic data to \*(Bi\& form.  This
message would be raised if
.I "P. D. Q. {Bach, Jr.}"
or
.I "Bach, P. D. Q., Jr."
had been incorrectly coded as
.IR "P. D. Q. Bach and Jr." .
.\"-----------------------------------------------
.TP
.I "WARNING: unrecognized text [xxx]"
There is a syntax error in the
.I biblabel.use
file, or a file specified by the
.B \-\|\-used-file
option.  Such files are expected to contain
comments (from percent (%) or sharp (#) to
end-of-line), empty or blank lines, and lines with
whitespace-separated pairs of filename and
citation label.
.\"-----------------------------------------------
.TP
.I "WARNING: year [xxxx] out of acceptable range [1000..2099] for citation label: using 20xx instead"
A valid year is required for generation of a
citation label; an out-of-range, or omitted, year
will be represented by
.I 20xx
in the generated citation label.
.\"-----------------------------------------------
.\" Since biblabel.sh always invokes bibclean first, this
.\" caveat is now obsolete:
.\" OLD: .\"===============================================
.\" OLD: .SH CAVEATS
.\" OLD: \*(Bi\& has loose syntactical requirements that
.\" OLD: the current simple implementation of
.\" OLD: .B biblabel
.\" OLD: does not support.  In particular, for
.\" OLD: .BR biblabel ,
.\" OLD: outer parentheses may
.\" OLD: .I not
.\" OLD: be used in place of braces following ``@keyword''
.\" OLD: patterns.  If you have such a file, you can use
.\" OLD: .BR bibclean (1)
.\" OLD: to prettyprint it into a form that
.\" OLD: .B biblabel
.\" OLD: can handle successfully.
.\"===============================================
.SH "SEE ALSO"
.BR bibcheck (1),
.BR bibclean (1),
.BR bibextract (1),
.BR bibdestringify (1),
.BR bibdup (1),
.BR bibextract (1),
.BR bibjoin (1),
.BR biblex (1),
.BR biborder (1),
.BR bibparse (1),
.BR bibsearch (1),
.BR bibsort (1),
.BR bibsplit (1)
.BR bibtex (1),
.BR bibunlex (1),
.BR citesub (1),
.BR emacs (1),
.BR vim (1).
.\"===============================================
.SH AUTHOR
.nf
Nelson H. F. Beebe, Ph.D.
Center for Scientific Computing
University of Utah
Department of Mathematics, 322 INSCC
155 S 1400 E RM 233
Salt Lake City, UT 84112-0090
USA
Email: \fCbeebe@math.utah.edu\fP, \fCbeebe@acm.org\fP,
       \fCbeebe@computer.org\fP, \fCbeebe@ieee.org\fP (Internet)
WWW URL: \fChttp://www.math.utah.edu/~beebe\fP
Telephone: +1 801 581 5254
FAX: +1 801 585 1640, +1 801 581 4148
.fi
.\"===============================================
.SH AVAILABILITY
.B biblabel
is freely available; its master distribution can
be found at
.PP
.RS
.nf
\&\fCftp://ftp.math.utah.edu/pub/tex/bib/\fP
\&\fChttp://www.math.utah.edu/pub/tex/bib/index-table-b.html#biblabel\fP
.fi
.RE
.PP
in the files
.RS
.nf
.I biblabel-x.yy.jar
.I biblabel-x.yy.shar.gz
.I biblabel-x.yy.tar.gz
.I biblabel-x.yy.zip
.I biblabel-x.yy.zoo
.fi
.RE
where
.I x.yy
is the current version.  Each of the popular
archive format unpacks into an identical
distribution tree in a subdirectory named
.IR biblabel-x.yy .
.RB [ Caution :
older software distributions may omit the leading
subdirectory prefix in some archive formats.]
.PP
That site is mirrored to several other Internet
archives, so you may also be able to find it
elsewhere on the Internet; try searching for the
string
.I biblabel
at one or more of the popular Web search sites,
such as
.PP
.RS
.nf
\&\fChttp://search.microsoft.com/
http://www.altavista.com/
http://www.dejanews.com/
http://www.dogpile.com/
http://www.euroseek.net/
http://www.excite.com/
http://www.go2net.com/
http://www.google.com/
http://www.hotbot.com/
http://www.infoseek.com/
http://www.inktomi.com/
http://www.lycos.com/
http://www.northernlight.com/
http://www.snap.com/
http://www.stpt.com/
http://www.websmostlinked.com/
http://www.yahoo.com/\fP
.fi
.RE
.\"===============================================
.SH COPYRIGHT
.nf
\fC########################################################################
########################################################################
########################################################################
###                                                                  ###
###      biblabel: generate standardized BibTeX citation labels      ###
###                                                                  ###
###     Copyright (C) 1994, 1996, 1997, 2001 Nelson H. F. Beebe      ###
###                                                                  ###
### This program is covered by the GNU General Public License (GPL), ###
### version 2 or later, available as the file COPYING in the program ###
### source distribution, and on the Internet at                      ###
###                                                                  ###
###               ftp://ftp.gnu.org/gnu/GPL                          ###
###                                                                  ###
###               http://www.gnu.org/copyleft/gpl.html               ###
###                                                                  ###
### This program is free software; you can redistribute it and/or    ###
### modify it under the terms of the GNU General Public License as   ###
### published by the Free Software Foundation; either version 2 of   ###
### the License, or (at your option) any later version.              ###
###                                                                  ###
### This program is distributed in the hope that it will be useful,  ###
### but WITHOUT ANY WARRANTY; without even the implied warranty of   ###
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    ###
### GNU General Public License for more details.                     ###
###                                                                  ###
### You should have received a copy of the GNU General Public        ###
### License along with this program; if not, write to the Free       ###
### Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   ###
### MA 02111-1307 USA                                                ###
########################################################################
########################################################################
########################################################################\fP
.fi
.\"==============================[The End]==============================
.\" This is for GNU Emacs file-specific customization:
.\" Local Variables:
.\" fill-column: 50
.\" End:
