.\" ====================================================================
.\"  @Troff-man-file{
.\"     author          = "Nelson H. F. Beebe",
.\"     version         = "0.04",
.\"     date            = "05 March 2001",
.\"     time            = "06:00:36 MST",
.\"     filename        = "citesub.man",
.\"     address         = "Center for Scientific Computing
.\"                        University of Utah
.\"                        Department of Mathematics, 322 INSCC
.\"                        155 S 1400 E RM 233
.\"                        Salt Lake City, UT 84112-0090
.\"                        USA",
.\"     telephone       = "+1 801 581 5254",
.\"     FAX             = "+1 801 585 1640, +1 801 581 4148",
.\"     URL             = "http://www.math.utah.edu/~beebe",
.\"     checksum        = "29900 368 1461 12320",
.\"     email           = "beebe@math.utah.edu, beebe@acm.org,
.\"                        beebe@computer.org, beebe@ieee.org,
.\"                        (Internet)",
.\"     codetable       = "ISO/ASCII",
.\"     keywords        = "bibliography, BibTeX, citation label, LaTeX,
.\"                        TeX",
.\"     supported       = "yes",
.\"     docstring       = "This file contains the UNIX manual pages
.\"                        for the citesub utility, a program for
.\"                        substituting new BibTeX citation labels
.\"                        standardized to the BibNet Project form,
.\"                        Lastname:year:abbrev.  The companion
.\"                        program, biblabel, can be used to generate
.\"                        the substitution file needed by this
.\"                        program.
.\"
.\"                        The checksum field above contains a CRC-16
.\"                        checksum as the first value, followed by the
.\"                        equivalent of the standard UNIX wc (word
.\"                        count) utility output of lines, words, and
.\"                        characters.  This is produced by Robert
.\"                        Solovay's checksum utility.",
.\"  }
.\" ====================================================================
.if t .ds Bi B\s-2IB\s+2T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Bi BibTeX
.if t .ds La L\\h'-0.24m'\\v'-0.15v'\\s-2A\\s+2\\h'-0.15m'\\v'0.15v'T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds La LaTeX
.if t .ds Te T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Te TeX
.TH CITESUB 1 "05 March 2001" "Version 0.04"
.\"======================================================================
.SH NAME
citesub \- substitute standardized BibTeX citation labels
.\"======================================================================
.SH SYNOPSIS
.B citesub
[
.BI \-f " substitution-file"
]
[
.B \-v
]
[ file(s) ]  >outfile
.\"======================================================================
.SH DESCRIPTION
.B citesub
applies citation label substitutions to input
\*(Bi\&, \*(La\&, and \*(Te\& files.  The
substitutions will usually be generated
automatically by the companion
.B biblabel
program (see below), which can be used to
standardize the form of \*(Bi\& citation labels to
the conventions adopted for the BibNet Project.
.PP
Most existing \*(Bi\& bibliography files have been
found to have rather haphazardly-chosen, and
unsystematic, citation labels that are very likely
to conflict with labels in other bibliography
files;
.B biblabel
and
.B citesub
provide an automatic way to rectify this.
.PP
To avoid confusion between labels with common
prefixes, such as
.I Smith80
and
.IR Smith80a ,
.B citesub
checks for leading context of a left brace, quote,
comma, whitespace, or beginning of line and
trailing context of a right brace, comma, quote,
percent, whitespace, or end of line so as to match
these styles:
.PP
.RS
.nf
@Book{Smith:1980:ABC,

crossref = "Smith:1980:ABC",

crossref = {Smith:1980:ABC},

\ecite{Smith:1980:ABC}

\ecite{Smith:1980:ABC,Jones:1994:DEF}

\ecite{%
       Smith:1980:ABC,%
       Jones:1994:DEF%
}
.fi
.RE
.PP
Although one might expect that simple application
of standard software tools like the UNIX
.BR awk (1)
and
.BR sed (1)
utilities could do the string substitution job,
this is not the case.  For one thing, the required
context sensitivity complicates the
regular-expression patterns that are needed.  For
another, most UNIX
.BR sed (1)
implementations have a built-in limit of about 100
substitutions, which is far too few for typical
bibliographies.  Finally, simple application of
.BR awk (1)
and
.BR awk (1)
involves matching every input line with every
substitution pattern, which results in quadratic
run-time behavior that proves impossibly slow for
large bibliographies.
.PP
.B citesub
provides an efficient solution whose run time is
essentially proportional to the size of the input
files, and
.I independent
of the number of substitutions to be carried out.
This is achieved by tokenizing the input lines,
and then looking up each token in a
constant-access time (hash) table of
substitutions.  An initial prototype programmed in
the
.I awk
language led to a final version in C that ran
about 50 times faster, processing about 4000 input
lines/sec on an entry-level Sun SPARCstation LX
workstation.
.\"======================================================================
.SH OPTIONS
Except for the option described below, all
command-line words are assumed to be input files.
Should such a filename begin with a hyphen, it
must be disguised by a leading absolute or
relative directory path, e.g.
.I /tmp/-foo.bib
or
.IR ./-foo.bib .
.TP \w'\-f-labels-in-use-file'u+2n
.BI \-f " substitution-file"
This option specifies the name of a file
containing pairs of old and new citation labels,
one pair per line, surrounded by arbitrary amounts
of whitespace.  This file is most easily generated
by the companion program
.BR biblabel (1).
.IP
If this option is omitted, then the substitution
filename will be derived from that of the first
input file by replacing its extension by
.IR ".sub" .
Thus, the commands
.nf
.I "citesub -f foo.sub foo.bib >foo.bib-new"
and
.I "citesub foo.bib >foo.bib-new"
.fi
are equivalent.
.IP
If the substitution file is named "-", then
.B citesub
follows the common UNIX convention and interprets
it to mean standard input, allowing the
substitutions to be provided from a pipeline, such
as
.nf
.I "biblabel foo.bib | citesub -f - >foo.new"
.fi
.TP
.B \-v
Display the program version number, and possibly
installer, location, and compile-time information,
on
.IR stderr .
.\"======================================================================
.SH "WARNING AND ERROR MESSAGES"
.B citesub
will issue warning messages in the following cases:
.TP \w'\(bu'u+1n
\(bu
.I "Incorrect number of fields in substitution file."
The line is ignored.
.TP
\(bu
.I "Invalid citation label character."
.B citesub
expects that citation labels follow the
requirements of the \*(Bi\& grammar described in
the paper
.IP
Nelson H. F. Beebe,
.IR "Bibliography prettyprinting and syntax checking" ,
TUGboat 14(3), 222, October (1993) and TUGboat
14(4), 395--419, December (1993).
.IP
Citation labels must contain only these
characters:
.nf
ABCDEFGHIJKLMNOPQRSTUVWXYZ
abcdefghijklmnopqrstuvwxyz
0123456789
:-+/.'_
.fi
.B citesub
will continue processing, but since only input
tokens containing the above set of characters are
candidates for substitution, such erroneous labels
will not be substituted.
.TP
\(bu
.IR "No label substitutions found in file."
This is not necessarily an error, but might be.
.B citesub
will then simply copy its input to its output.
.\"======================================================================
.SH "SEE ALSO"
.BR awk (1),
.BR bibcheck (1),
.BR bibclean (1),
.BR bibextract (1),
.BR bibjoin (1),
.BR biblabel (1),
.BR biblex (1),
.BR biborder (1),
.BR bibparse (1),
.BR bibsort (1),
.BR bibtex (1),
.BR bibunlex (1),
.BR sed (1).
.\"======================================================================
.SH AUTHOR
.nf
Nelson H. F. Beebe, Ph.D.
Center for Scientific Computing
University of Utah
Department of Mathematics, 322 INSCC
155 S 1400 E RM 233
Salt Lake City, UT 84112-0090
USA
Email: \fCbeebe@math.utah.edu\fP, \fCbeebe@acm.org\fP,
       \fCbeebe@computer.org\fP, \fCbeebe@ieee.org\fP (Internet)
WWW URL: \fChttp://www.math.utah.edu/~beebe\fP
Telephone: +1 801 581 5254
FAX: +1 801 585 1640, +1 801 581 4148
.fi
.\"=====================================================================
.SH AVAILABILITY
.B citesub
is freely available; its master distribution can
be found in the biblabel package at
.PP
.RS
.nf
\&\fCftp://ftp.math.utah.edu/pub/tex/bib/\fP
\&\fChttp://www.math.utah.edu/pub/tex/bib/\fP
.fi
.RE
.PP
in the files
.RS
.nf
.I biblabel-x.yy.jar
.I biblabel-x.yy.tar.gz
.I biblabel-x.yy.zip
.I biblabel-x.yy.zoo
.fi
.RE
where
.I x.yy
is the current version.  Each of the popular
archive format unpacks into an identical
distribution tree.
.PP
That site is mirrored to several other Internet
archives, so you may also be able to find it
elsewhere on the Internet; try searching for the
string
.I biblabel
at one or more of the popular Web search sites,
such as
.PP
.RS
.nf
\&\fChttp://search.microsoft.com/
http://www.altavista.com/
http://www.dejanews.com/
http://www.dogpile.com/
http://www.euroseek.net/
http://www.excite.com/
http://www.go2net.com/
http://www.google.com/
http://www.hotbot.com/
http://www.infoseek.com/
http://www.inktomi.com/
http://www.lycos.com/
http://www.northernlight.com/
http://www.snap.com/
http://www.stpt.com/
http://www.websmostlinked.com/
http://www.yahoo.com/\fP
.fi
.RE
.\"=====================================================================
.SH COPYRIGHT
.nf
\fC########################################################################
########################################################################
########################################################################
###                                                                  ###
###     citesub: substitute standardized BibTeX citation labels      ###
###                                                                  ###
###     Copyright (C) 1994, 1996, 1997, 2001 Nelson H. F. Beebe      ###
###                                                                  ###
### This program is covered by the GNU General Public License (GPL), ###
### version 2 or later, available as the file COPYING in the program ###
### source distribution, and on the Internet at                      ###
###                                                                  ###
###               ftp://ftp.gnu.org/gnu/GPL                          ###
###                                                                  ###
###               http://www.gnu.org/copyleft/gpl.html               ###
###                                                                  ###
### This program is free software; you can redistribute it and/or    ###
### modify it under the terms of the GNU General Public License as   ###
### published by the Free Software Foundation; either version 2 of   ###
### the License, or (at your option) any later version.              ###
###                                                                  ###
### This program is distributed in the hope that it will be useful,  ###
### but WITHOUT ANY WARRANTY; without even the implied warranty of   ###
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    ###
### GNU General Public License for more details.                     ###
###                                                                  ###
### You should have received a copy of the GNU General Public        ###
### License along with this program; if not, write to the Free       ###
### Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   ###
### MA 02111-1307 USA                                                ###
########################################################################
########################################################################
########################################################################\fP
.fi
.\"==============================[The End]==============================
.\" This is for GNU Emacs file-specific customization:
.\" Local Variables:
.\" fill-column: 50
.\" End:
