/* -*-C-*- hash.h */
/**********************************************************************/
/******************************* hash *********************************/
/**********************************************************************/

/* $Id: hash.h,v 1.2 1996/02/17 23:08:51 beebe Exp beebe $ */

#ifndef HASH_H_DEFINED_
#define HASH_H_DEFINED_

typedef unsigned int	HASH_INT;	/* MUST be unsigned for hash() */
					/* to protect against overflow */
typedef struct
{
    const char		*hash_key;	/* pointer to hash key string */
    VOIDP		hash_data;	/* pointer to arbitrary data */
} HASH_ENTRY;

typedef struct
{
    HASH_INT	hash_index;		/* index of next entry to be */
					/* examined by hash_next() */
    HASH_INT	hash_size;		/* size of hash table */
    HASH_ENTRY	*hash_table;		/* pointer to hash table */
    int		(*hash_compare) ARGS((const char *s1_, const char *s2_));
    long	n_compare;		/* number of calls to HASH_COMPARE() */
    long	n_install;		/* number of calls to hash_install() */
    long	n_lookup;		/* number of calls to hash_lookup() */
    long	n_probe;		/* number of probes into hash table */
    long	max_chain;		/* longest collision-induced chain */
} HASH_TABLE;

#define HASH_COMPARE_CAST	int(*)ARGS((const char *, const char *))

#if sun
/* /lib/libsunwindow.a has functions with name conflicts, so rename ours */
#define	hash_alloc	Hash_alloc
#define	hash_free	Hash_free
#define	hash_install	Hash_install
#define	hash_lookup	Hash_lookup
#define	hash_next	Hash_next
#endif /* sun */

HASH_TABLE	*hash_alloc ARGS((HASH_INT size_, int case_sensitive_));

void		hash_free ARGS((HASH_TABLE *table_));

HASH_ENTRY	*hash_install ARGS((const char *key_, VOIDP data_,
				HASH_TABLE *table_));

HASH_ENTRY	*hash_lookup ARGS((const char *key_, HASH_TABLE *table_));

HASH_ENTRY	*hash_next ARGS((int first_, HASH_TABLE *table_));

#endif /* HASH_H_DEFINED_ */
