/* -*-C-*- strdup.c */
/*-->strdup*/
/**********************************************************************/
/******************************* strdup *******************************/
/**********************************************************************/

#include <config.h>

#if defined(HAVE_STDIO_H)
#include <stdio.h>
#endif

#if defined(HAVE_STDLIB_H)
#include <stdlib.h>
#endif

#if defined(HAVE_STRING_H)
#include <string.h>
#endif

RCSID("$Id: strdup.c,v 1.5 1993/12/29 18:26:46 beebe Exp beebe $")

char*
#if STDC
STRDUP(
const char  *s
)
#else /* NOT STDC */
STRDUP(s)				/* allocate new copy of s, or die */
const char  *s;
#endif /* STDC */
{
    register char  *p;

    p = (char*)malloc((size_t)(strlen(s) + 1));
    if (p == (char*)NULL)
    {
	(void)fprintf(stderr,"Out of memory in strdup()\n");
	exit(EXIT_FAILURE);
    }
    (void)strcpy(p,s);
    return (p);
}
