.\" ====================================================================
.\"  @Troff-man-file{
.\"     author          = "Nelson H. F. Beebe",
.\"     version         = "0.06",
.\"     date            = "04 December 1994",
.\"     time            = "12:58:47 MST",
.\"     filename        = "biborder.man",
.\"     address         = "Center for Scientific Computing
.\"                        Department of Mathematics
.\"                        University of Utah
.\"                        Salt Lake City, UT 84112
.\"                        USA",
.\"     telephone       = "+1 801 581 5254",
.\"     FAX             = "+1 801 581 4148",
.\"     checksum        = "06053 336 1307 9219",
.\"     email           = "beebe@math.utah.edu (Internet)",
.\"     codetable       = "ISO/ASCII",
.\"     keywords        = "bibliography, sorting, BibTeX",
.\"     supported       = "yes",
.\"     docstring       = "This file contains the UNIX manual pages
.\"                        for the biborder utility, a program for
.\"                        ordering key fields in BibTeX bibliography
.\"                        files.
.\"
.\"                        The checksum field above contains a CRC-16
.\"                        checksum as the first value, followed by the
.\"                        equivalent of the standard UNIX wc (word
.\"                        count) utility output of lines, words, and
.\"                        characters.  This is produced by Robert
.\"                        Solovay's checksum utility.",
.\"  }
.\" ====================================================================
.if t .ds Bi B\s-2IB\s+2T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Bi BibTeX
.if t .ds Te T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Te TeX
.TH BIBORDER 1 "04 December 1994" "Version 0.06"
.\"======================================================================
.SH NAME
biborder \- order key fields in a BibTeX bibliography file
.\"======================================================================
.SH SYNOPSIS
.B biborder
.RB [ \-bimonthly
.IR m1/m2/m3/m4/m5/m6 ]
.RB [ \-check-missing ]
.if n .ti +9n
.RB [ \-monthly ]
.RB [ \-quarterly
.IR m1/m2/m3/m4 ]
.if n .ti +9n
.if t .ti +.5i
< infile > outfile
.nf
or
.fi
.B biborder
.RB [ \-bimonthly
.IR m1/m2/m3/m4/m5/m6 ]
.RB [ \-check-missing ]
.if n .ti +9n
.RB [ \-monthly ]
.RB [ \-quarterly
.IR m1/m2/m3/m4 ]
.if n .ti +9n
.if t .ti +.5i
BibTeXfile(s)
> outfile
.\"======================================================================
.SH DESCRIPTION
.B biborder
filters one or more \*(Bi\& bibliographies, or
bibliography fragments, from the specified files,
or from its standard input if no filenames are
provided, printing on standard output a
bibliography in which key fields have been put
into a standard order:
.IR author ,
.IR editor ,
.IR key ,
.IR booktitle ,
.IR title ,
.IR crossref ,
.IR chapter ,
.IR journal ,
.IR volume ,
.IR type ,
.IR number ,
.IR howpublished ,
.IR institution ,
.IR organization ,
.IR publisher ,
.IR school ,
.IR address ,
.IR edition ,
.IR pages ,
.IR month ,
.IR year ,
.IR ISBN ,
.IR ISSN ,
.IR LCCN ,
.IR note ,
.IR price ,
.IR series ,
and
.IR URL .
All other key fields are output in alphabetical
order following the standard ones.
.PP
A consistent key field order makes \*(Bi\& entries
easier to read, and also facilitates
identification and removal of duplicates, such as
with
.BR "bibsort -u" .
.\"======================================================================
.SH OPTIONS
Command-line options may be abbreviated to a
unique leading prefix.
.PP
To avoid confusion with options, if a filename
begin with a hyphen, it must be disguised by a
leading absolute or relative directory path, e.g.
.I /tmp/-foo.bib
or
.IR ./-foo.bib .
.\"-----------------------------------------------
.TP \w'\-check-missing'u+3n
.BI \-bimonthly " m1,m2,m3,m4,m5,m6"
If this option is specified, all of the journals
in the \*(Bi\& file entries are assumed to appear
at two-month intervals. The six month names that
correspond to each such interval must be given as
a
.I single
argument following
.BR \-bimonthly ,
with the names separated by (any number of)
non-letters.  A typical example is
.IR feb-apr-jun-aug-oct-dec ,
specifying that issue number 1 appears in
February, and number 6 in December.
.\"-----------------------------------------------
.TP
.B \-check-missing
If this option is specified, missing expected key
fields will be supplied, with the key field name
prefixed with OPT, and the value string set to a
pair of question marks, e.g.
.nf
  OPTvolume =    "??",
.fi
The
.I OPT
prefix ensures that the key is ignored by \*(Bi\&,
so that the question marks will not appear in an
output
.I .bbl
file.  The GNU Emacs
.I bibtex-mode
editing support has functions for removing the OPT
prefixes, and so does
.BR bibclean (1).
.IP
The doubled question marks are distinguished from
single ones that might legitimately appear in
value strings, and also serve as a convenient
regular-expression pattern for
.BR bibextract (1),
allowing easy preparation of a printed listing of
just those entries that have incomplete
bibliographic data:
.nf
.BI "     bibextract" " '' '[?][?]' BibTeXfiles " "|  lpr"
.fi
.\"-----------------------------------------------
.TP
.B \-monthly
If this option is specified, all of the journals
in the \*(Bi\& file entries are assumed to appear
monthly, 1 in January, 2 in February, .\|.\|., 12
in December.
.IP
If only one of the number and month values is
supplied,
.B biborder
will supply the other automatically, but will
name it
.I OPTmonth
or
.I OPTnumber
to distinguish it from existing keys.  A simple
editor string substitution, or
.BR bibclean (1),
can subsequently normalize the appearance.
.\"-----------------------------------------------
.TP
.BI \-quarterly " m1,m2,m3,m4"
If this option is specified, all of the journals
in the \*(Bi\& file entries are assumed to appear
quarterly. The four month names that correspond to
each quarter must be given as a
.I single
argument following
.BR \-quarterly ,
with the names separated by (any number of)
non-letters.  Some examples are
.IR jan-apr-jul-oct ,
.IR mar////jun.sep:dec ,
.IR "Spring\e Summer\e Fall\e Winter" ,
and
.IR "'Spring Summer Fall Winter'" .
The last two examples show that when space
separators are used, they must be backslashed, or
else the list must be surrounded by quotes, to
force UNIX shells to interpret the quarter names
as a single argument.
.\"-----------------------------------------------
.PP
The options
.BR \-bimonthly ,
.BR \-monthly ,
and
.B \-quarterly
are mutually exclusive;
.B biborder
will refuse to run if more than one of them is
specified; they should normally only be used in
journal-specific bibliographies, since
number-month pairing does not hold for all
journals.
.PP
Failure to supply the correct number of month
names for
.B \-bimonthly
or
.B \-quarterly
will also cause immediate termination.
.\"======================================================================
.SH "WARNING AND ERROR MESSAGES"
.B biborder
will issue warning messages in the following cases:
.TP \w'\(bu'u+1n
\(bu
With
.BR \-check-missing ,
for unrecognized \*(Bi\& entry types.  The entry will
be output without checking for missing key
names.
.TP
\(bu
With
.BR \-bimonthly ,
.BR \-monthly ,
and
.BR \-quarterly ,
for mismatches between
.I month
and
.I number
values, or for an out-of-range
.I number
value.
.TP
\(bu
For duplicate key names.  Such key/value pairs are
sorted together by name, preserving their original order.
.PP
.B biborder
will issue an error message and terminate with
exit code 1, and incomplete output, in the
following cases:
.TP \w'\(bu'u+1n
\(bu
For an unrecognized command-line argument (only
the first letter of each option is currently
examined).
.TP
\(bu
If more than one of
.BR \-bimonthly ,
.BR \-monthly ,
and
.B \-quarterly
is specified.
.TP
\(bu
End-of-file is reached while collecting an entry.
.TP
\(bu
A line beginning with `@' is encountered while
collecting an entry, before balanced braces have
been found.
.TP
\(bu
An incorrect number of month names is specified
with
.B \-bimonthly
or
.BR \-quarterly .
.\"======================================================================
.SH CAVEATS
\*(Bi\& has loose syntactical requirements that
the current simple implementation of
.B biborder
does not support.  In particular, outer
parentheses may
.I not
be used in place of braces following ``@keyword''
patterns.  If you have such a file, you can use
.BR bibclean (1)
to prettyprint it into a form that
.B biborder
can handle successfully.
.\"======================================================================
.SH "SEE ALSO"
.BR bibclean (1),
.BR bibextract (1),
.BR biblex (1),
.BR bibparse (1),
.BR bibsort (1),
.BR bibtex (1),
.BR bibunlex (1),
.BR emacs (1).
.\"======================================================================
.SH AUTHOR
.nf
Nelson H. F. Beebe, Ph.D.
Center for Scientific Computing
Department of Mathematics
University of Utah
Salt Lake City, UT 84112
Tel: +1 801 581 5254
FAX: +1 801 581 4148
Email: <beebe@math.utah.edu>
.fi
.\"==============================[The End]==============================
