.\" ====================================================================
.\"  @Troff-man-file{
.\"     author          = "Nelson H. F. Beebe",
.\"     version         = "1.04",
.\"     date            = "08 May 1999",
.\"     time            = "09:26:19 MDT",
.\"     filename        = "bibunlex.man",
.\"     address         = "Center for Scientific Computing
.\"                        University of Utah
.\"                        Department of Mathematics, 322 INSCC
.\"                        155 S 1400 E RM 233
.\"                        Salt Lake City, UT 84112-0090
.\"                        USA",
.\"     telephone       = "+1 801 581 5254",
.\"     FAX             = "+1 801 585 1640, +1 801 581 4148",
.\"     URL             = "http://www.math.utah.edu/~beebe",
.\"     checksum        = "51217 120 475 4123",
.\"     email           = "beebe@math.utah.edu, beebe@acm.org,
.\"                        beebe@ieee.org  (Internet)",
.\"     codetable       = "ISO/ASCII",
.\"     keywords        = "bibliography, BibTeX, lexical analysis",
.\"     supported       = "yes",
.\"     docstring       = "This file is the UNIX nroff/troff manual
.\"                        page documentation for bibunlex, a tool for
.\"                        reconstructing BibTeX bibliography data
.\"                        base files from the lexical analysis output
.\"                        of bibclean or biblex.
.\"
.\"                        The checksum field above contains a CRC-16
.\"                        checksum as the first value, followed by the
.\"                        equivalent of the standard UNIX wc (word
.\"                        count) utility output of lines, words, and
.\"                        characters.  This is produced by Robert
.\"                        Solovay's checksum utility.",
.\"  }
.\"=====================================================================
.\"
.if t .ds Bi B\s-2IB\s+2T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Bi BibTeX
.\"
.\"=====================================================================
.TH BIBUNLEX 1 "08 May 1999" "Version 1.04"
.\"=====================================================================
.SH NAME
bibunlex \- reconstruct a BibTeX bibliography data base file from \
bibclean or biblex lexical analysis output
.\"=====================================================================
.SH SYNOPSIS
.B bibunlex
.I "<infile"
.I ">outfile"
.nf
or
.fi
.B bibunlex
.I "file1 file2 file3 .\|.\|."
.I ">outfile"
.\"=====================================================================
.SH DESCRIPTION
.B bibunlex
takes a lexical token stream from
.BR bibclean (1)
or from
.BR biblex (1),
and reconstructs a
\*(Bi bibliography data base file on
.IR stdout .
.PP
The reconstruction is simplistic with regard to obtaining nice
spacing, and best results will be obtained if the output is
prettyprinted by
.BR bibclean (1).
For example,
.RS
.nf
.B "bibclean -no-prettyprint \fI*.bib\fP | some-filter | bibunlex | bibclean \
>new.bib"
.B "biblex \fI*.bib\fP | some-filter | bibunlex | bibclean >new.bib"
.fi
.RE
.\"=====================================================================
.SH "SEE ALSO"
.BR bibcheck (1),
.BR bibclean (1),
.BR bibdup (1),
.BR bibextract (1),
.BR bibjoin (1),
.BR biblabel (1),
.BR biblex (1),
.BR biborder (1),
.BR bibparse (1),
.BR bibsearch (1),
.BR bibsort (1),
.BR bibtex (1),
.BR citefind (1),
.BR citesub (1),
.BR citetags (1),
.BR latex (1),
.BR scribe (1),
.BR tex (1).
.\"=====================================================================
.SH AUTHOR
.nf
Nelson H. F. Beebe
Center for Scientific Computing
University of Utah
Department of Mathematics, 322 INSCC
155 S 1400 E RM 233
Salt Lake City, UT 84112-0090
USA
Email: \fCbeebe@math.utah.edu\fP, \fCbeebe@acm.org\fP, \fCbeebe@ieee.org\fP (Internet)
WWW URL: \fChttp://www.math.utah.edu/~beebe\fP
Telephone: +1 801 581 5254
FAX: +1 801 585 1640, +1 801 581 4148
.fi
.\"=====================================================================
.\" This is for GNU Emacs file-specific customization:
.\" Local Variables:
.\" fill-column: 50
.\" End:
