
# line 2 "bibparse.y"
 /**********************************************************************
 @Yacc-file{
    author              = "Nelson H. F. Beebe",
    version             = "1.04",
    date                = "07 May 1999",
    time                = "10:21:46 MDT",
    filename            = "bibparse.y",
    address             = "Center for Scientific Computing
                           University of Utah
                           Department of Mathematics, 322 INSCC
                           155 S 1400 E RM 233
                           Salt Lake City, UT 84112-0090
                           USA",
    telephone           = "+1 801 581 5254",
    FAX                 = "+1 801 585 1640, +1 801 581 4148",
    URL                 = "http://www.math.utah.edu/~beebe",
    checksum            = "37113 553 1689 14003",
    email               = "beebe@math.utah.edu, beebe@acm.org,
                           beebe@ieee.org (Internet)",
    codetable           = "ISO/ASCII",
    keywords            = "BibTeX, bibliography, lexical analysis, lexer,
                           parsing, parser",
    supported           = "yes",
    docstring           = "This yacc file defines a parser for a
                           prototype BibTeX grammar.

                           The resulting program reads BibTeX data,
                           and/or BibTeX lexical token streams produced
                           by biblex or bibclean, from one or more files
                           specified on the command line, or standard
                           input, and parses the token stream to verify
                           its conformance to the BibTeX grammar.

                           If a command-line -d (or -D) option is
                           specified, debug mode is selected, and
                           extensive commentary on the parsing actions
                           will be output.  It will be necessary to
                           have a copy of the y.output file produced
                           by bison or lex in order to make sense out
                           of the state and rule numbers in this
                           output.

                           The checksum field above contains a CRC-16
                           checksum as the first value, followed by the
                           equivalent of the standard UNIX wc (word
                           count) utility output of lines, words, and
                           characters.  This is produced by Robert
                           Solovay's checksum utility.",
 }
 **********************************************************************/

#include <config.h>

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#if defined(HAVE_STDLIB_H)
#include <stdlib.h>
#endif

#if HAVE_ALLOCA_H
 /* needed for alloca() macro definition if bison is used instead of yacc */
#include <alloca.h>
#endif

#include "args.h"
#include "bibyydcl.h"

static void		doparse ARGS((void));
int			main ARGS((int argc_, char *argv_[]));
static int		nextchar ARGS((void));
static void		recognize ARGS((const char *s_));
int			yyparse ARGS((void));
static void		yywarning ARGS((const char *s_));

#if defined(__cplusplus)
extern "C" {
#endif

static int		(*pyylex) ARGS((void));
int			xxlex ARGS((void));
int			zzlex ARGS((void));

#if defined(__cplusplus)
}
#endif

int			error_count;
char			*program_name;	/* for error messages */

/* These variables are defined in biblex.c: */
extern int		do_lex_output;
extern long		line_number;
extern const char	*the_filename;
extern char		yytext[BIBYYLMAX];

#define	ERROR_PREFIX	"??"	/* this prefixes all error messages */
#define WARNING_PREFIX	"%%"	/* this prefixes all warning messages */

#define RECOGNIZE(s)	recognize(s)

#define YYDEBUG		1		/* need for -d option support */

#if defined(_CRAY)
extern long yydebug;
#else
extern int yydebug;
#endif

# define TOKEN_ABBREV 1
# define TOKEN_AT 2
# define TOKEN_COMMA 3
# define TOKEN_COMMENT 4
# define TOKEN_ENTRY 5
# define TOKEN_EQUALS 6
# define TOKEN_FIELD 7
# define TOKEN_INCLUDE 8
# define TOKEN_INLINE 9
# define TOKEN_KEY 10
# define TOKEN_LBRACE 11
# define TOKEN_LITERAL 12
# define TOKEN_NEWLINE 13
# define TOKEN_PREAMBLE 14
# define TOKEN_RBRACE 15
# define TOKEN_SHARP 16
# define TOKEN_SPACE 17
# define TOKEN_STRING 18
# define TOKEN_VALUE 19

#ifdef __STDC__
#include <stdlib.h>
#include <string.h>
#else
#include <malloc.h>
#include <memory.h>
#endif

#include <values.h>

#ifdef __cplusplus

#ifndef yyerror
	void yyerror(const char *);
#endif

#ifndef yylex
#ifdef __EXTERN_C__
	extern "C" { int yylex(void); }
#else
	int yylex(void);
#endif
#endif
	int yyparse(void);

#endif
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval;
YYSTYPE yyval;
typedef int yytabelem;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#if YYMAXDEPTH > 0
int yy_yys[YYMAXDEPTH], *yys = yy_yys;
YYSTYPE yy_yyv[YYMAXDEPTH], *yyv = yy_yyv;
#else	/* user does initial allocation */
int *yys;
YYSTYPE *yyv;
#endif
static int yymaxdepth = YYMAXDEPTH;
# define YYERRCODE 256

# line 353 "bibparse.y"


/* end of grammar */

static void
doparse(VOID)
{		/* parse a complete BibTeX file or BibTeX token stream */
    int c;

    line_number = 1L;

    /* A single character lookahead distinguishes between a token
    stream, which starts with a line number directive, and a BibTeX
    file, which does not.  We then pick a suitable lexical analyzer
    function. */

    c = getchar();
    (void)ungetc(c,stdin);
    pyylex = (c == '#') ? zzlex : xxlex;

    yyparse();				/* this handles the entire file */
}


#if NEW_STYLE
int
main(int argc, char *argv[])
#else /* K&R style */
int
main(argc, argv)
int argc;
char *argv[];
#endif /* NEW_STYLE */
{
    int code;				/* error return code */
    int k;				/* index into argv[] */
    int n;				/* index into argv[] */
    FILE *fp;				/* pointer to current input file */

    do_lex_output = 0;			/* prevent output from xxlex() */
    error_count = 0;
    program_name = argv[0];

    for (k = 1; k < argc; ++k)
    {					/* check for command-line options */
	if ((strcmp(argv[k],"-d") == 0) || (strcmp(argv[k],"-D") == 0))
	{
	    yydebug = 1;
	    do_lex_output = 1;
	    for (n = k; n < argc; ++n)	/* shuffle remaining arguments down */
		argv[n] = argv[n+1];
	    argc--;			/* and reduce argument count */
	}
    }

    if (argc > 1)		/* files to parse named on command line */
    {
	for (k = 1; k < argc; ++k)
	{
	    fp = freopen(argv[k],"r",stdin);
	    if (fp == (FILE*)NULL)
	    {
		(void)fprintf(stderr,
			      "\n%s Ignoring open failure on file [%s]\n",
			      ERROR_PREFIX, argv[k]);
		(void)perror("perror() says");
	    }
	    else
	    {
		the_filename = argv[k];
		doparse();
		(void)fclose(fp);
	    }
	}
    }
    else				/* parse stdin */
    {
	the_filename = "stdin";
	doparse();
    }
    code = (error_count > 0) ? EXIT_FAILURE : EXIT_SUCCESS;

    exit(code);
    return (code);			/* NOT REACHED */
}


static int
nextchar (VOID)
{
    int c;

    c = getchar ();
    if (yydebug)
	putchar (c);
    return (c);
}



#if NEW_STYLE
static void
recognize(const char *s)
#else
static void
recognize(s)
const char *s;
#endif
{
    if (yydebug)
	printf("[%s]\n", s);
}


#if NEW_STYLE
void
yyerror(const char *s)
#else
void
yyerror(s)
const char *s;
#endif
{
    error_count++;
    (void)fflush(stdout);
    (void)fprintf(stderr,"%s \"%s\", line %ld: %s\tNext token = \"%s\"\n",
		  ERROR_PREFIX, the_filename, line_number, s, yytext);
    (void)fflush(stderr);
}


int
yylex (VOID)
{
    int v;

    v = (*pyylex) ();

    /* xxlex() (== yylex() in biblex.c) biases token values by 1000, but
       the token streams produced by biblex and "bibclean --no-prettyprint"
       exclude that bias, for compact output. */

    return ((pyylex == zzlex) ? v : (v - 1000));
}


#if NEW_STYLE
static void
yywarning(const char *s)
#else
static void
yywarning(s)
const char *s;
#endif
{
    (void)fflush(stdout);
    (void)fprintf(stderr,"%s %s\tNext token = \"%s\"\n",
		  WARNING_PREFIX, s, yytext);
    (void)fflush(stderr);
}


int
zzlex (VOID)
{
    char buffer[BUFSIZ];	/* only needs space for a single number token */
    char *limit;		/* how far we can store into buffer[] */
    char *p;			/* pointer into buffer[] */
    int c;			/* current input character */

    limit = &buffer[sizeof(buffer) - 1]; /* address of last slot in buffer[] */

    for (;;)			/* `infinite' loop for ignoring comments and empty lines */
    {
	while (((c = nextchar ()) > 0) && isspace (c))
	    ;			/* skip leading whitespace */

	/* Collect first non-blank token on line, truncating if too big for buffer[] */
	p = &buffer[0];
	*p++ = c;
	while (((c = nextchar ()) > 0) && !isspace (c))
	{
	    if (p < limit)
		*p++ = c;
	}
	*p = '\0';

	while ((c != '\n') && ((c = nextchar ()) > 0))
	    ;			/* skip rest of line */

	if (c == '\n')		/* should always be true */
	    line_number++;

	if (buffer[0] == '#')	/* comment: pseudo return tail-recursively */
	    continue;
	else if (isdigit ((int) buffer[0]))	/* token number */
	    return ((int) strtol ((const char *) &buffer[0], &limit, 10));
	else if (c == '\n')	/* empty line: pseudo return tail-recursively */
	    continue;
	else if (feof (stdin))	/* assume end of file */
	    return (0);		/* standard lex end-of-file signal */
	else
	    return (-1);	/* should never happen */
    }
}
static const yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 73,
	16, 23,
	-2, 31,
	};
# define YYNPROD 41
# define YYLAST 253
static const yytabelem yyact[]={

    22,    27,     2,    57,    24,    56,    32,    74,    59,    35,
    25,    12,     6,    13,    26,    34,     7,    71,    35,    42,
     5,    69,     9,    53,    34,    29,    58,    36,    37,    38,
    39,    41,    31,    28,    44,    14,    43,    40,    63,    47,
    46,    45,    49,    72,    10,    48,     3,    62,    50,    51,
    52,    35,    55,    64,    33,    54,     4,    34,    60,    65,
    11,    76,    70,    66,    67,    61,    30,    23,    20,    19,
    68,    73,    18,    17,    16,    75,    15,     8,     1,    77,
     0,    78,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,    21 };
static const yytabelem yypact[]={

     3,-10000000,    42,     3,-10000000,-10000000,-10000000,-10000000,     3,-10000000,
     3,-10000000,    42,    -4,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,    18,     3,    17,     3,     3,     3,     3,-10000000,    25,
    16,-10000000,-10000000,     3,-10000000,-10000000,    22,    30,    29,    28,
-10000000,-10000000,     3,    36,-10000000,     3,     3,     3,     8,     3,
     7,    50,    37,-10000000,-10000000,-10000000,     3,-10000000,-10000000,-10000000,
     3,     3,-10000000,-10000000,     7,     6,     2,    40,     3,-10000000,
    -9,-10000000,     3,-10000000,-10000000,-10000000,     3,     7,-10000000 };
static const yytabelem yypgo[]={

     0,    78,     2,    77,    22,    76,    74,    73,    72,    69,
    68,    67,    66,    65,     5,     6,     3,    62,    61,    54,
    53,    46,    56 };
static const yytabelem yyr1[]={

     0,     1,     1,     3,     3,     4,     5,     5,     5,     5,
     5,     5,     6,     7,     7,     7,    11,    13,    13,     8,
     9,    10,    14,    17,    18,    14,    16,    16,    12,    12,
    20,    15,    19,    19,     2,     2,    21,    21,    22,    22,
    22 };
static const yytabelem yyr2[]={

     0,     3,     7,     3,     7,     7,     3,     3,     3,     3,
     3,     5,     7,     7,    11,     5,    17,     3,     3,     7,
    15,    15,     3,     1,     1,    15,     3,     3,     3,     9,
     1,    15,     3,     3,     1,     3,     3,     5,     2,     2,
     2 };
static const yytabelem yychk[]={

-10000000,    -1,    -2,   -21,   -22,    17,     9,    13,    -3,    -4,
     2,   -22,    -2,    -2,    -4,    -5,    -6,    -7,    -8,    -9,
   -10,   256,     4,   -11,     8,    14,    18,     5,    15,    -2,
   -12,    15,   -15,   -19,     7,     1,    -2,    -2,    -2,    -2,
    12,    15,     3,    -2,    12,    11,    11,    11,    -2,     6,
    -2,    -2,    -2,    15,   -15,    -2,   -14,   -16,    19,     1,
   -15,   -13,    10,     1,   -20,    -2,    -2,    -2,   -14,    15,
   -17,    15,     3,    -2,    16,    -2,   -18,    -2,   -16 };
static const yytabelem yydef[]={

    34,    -2,     1,    35,    36,    38,    39,    40,    34,     3,
    34,    37,     2,     0,     4,     5,     6,     7,     8,     9,
    10,     0,    34,     0,    34,    34,    34,    34,    11,     0,
     0,    15,    28,    34,    32,    33,     0,     0,     0,     0,
    12,    13,    34,     0,    19,    34,    34,    34,     0,    34,
     0,     0,     0,    14,    29,    30,    34,    22,    26,    27,
    34,    34,    17,    18,     0,    23,     0,     0,    34,    20,
     0,    21,    34,    -2,    24,    16,    34,     0,    25 };
typedef struct
#ifdef __cplusplus
	yytoktype
#endif
{ char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"TOKEN_ABBREV",	1,
	"TOKEN_AT",	2,
	"TOKEN_COMMA",	3,
	"TOKEN_COMMENT",	4,
	"TOKEN_ENTRY",	5,
	"TOKEN_EQUALS",	6,
	"TOKEN_FIELD",	7,
	"TOKEN_INCLUDE",	8,
	"TOKEN_INLINE",	9,
	"TOKEN_KEY",	10,
	"TOKEN_LBRACE",	11,
	"TOKEN_LITERAL",	12,
	"TOKEN_NEWLINE",	13,
	"TOKEN_PREAMBLE",	14,
	"TOKEN_RBRACE",	15,
	"TOKEN_SHARP",	16,
	"TOKEN_SPACE",	17,
	"TOKEN_STRING",	18,
	"TOKEN_VALUE",	19,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"file : opt_space",
	"file : opt_space object_list opt_space",
	"object_list : object",
	"object_list : object_list opt_space object",
	"object : TOKEN_AT opt_space at_object",
	"at_object : comment",
	"at_object : entry",
	"at_object : include",
	"at_object : preamble",
	"at_object : string",
	"at_object : error TOKEN_RBRACE",
	"comment : TOKEN_COMMENT opt_space TOKEN_LITERAL",
	"entry : entry_head assignment_list TOKEN_RBRACE",
	"entry : entry_head assignment_list TOKEN_COMMA opt_space TOKEN_RBRACE",
	"entry : entry_head TOKEN_RBRACE",
	"entry_head : TOKEN_ENTRY opt_space TOKEN_LBRACE opt_space key_name opt_space TOKEN_COMMA opt_space",
	"key_name : TOKEN_KEY",
	"key_name : TOKEN_ABBREV",
	"include : TOKEN_INCLUDE opt_space TOKEN_LITERAL",
	"preamble : TOKEN_PREAMBLE opt_space TOKEN_LBRACE opt_space value opt_space TOKEN_RBRACE",
	"string : TOKEN_STRING opt_space TOKEN_LBRACE opt_space assignment opt_space TOKEN_RBRACE",
	"value : simple_value",
	"value : value opt_space",
	"value : value opt_space TOKEN_SHARP",
	"value : value opt_space TOKEN_SHARP opt_space simple_value",
	"simple_value : TOKEN_VALUE",
	"simple_value : TOKEN_ABBREV",
	"assignment_list : assignment",
	"assignment_list : assignment_list TOKEN_COMMA opt_space assignment",
	"assignment : assignment_lhs opt_space TOKEN_EQUALS opt_space",
	"assignment : assignment_lhs opt_space TOKEN_EQUALS opt_space value opt_space",
	"assignment_lhs : TOKEN_FIELD",
	"assignment_lhs : TOKEN_ABBREV",
	"opt_space : /* empty */",
	"opt_space : space",
	"space : single_space",
	"space : space single_space",
	"single_space : TOKEN_SPACE",
	"single_space : TOKEN_INLINE",
	"single_space : TOKEN_NEWLINE",
};
#endif /* YYDEBUG */
# line	1 "/usr/ccs/bin/yaccpar"
/*
 * Copyright (c) 1993 by Sun Microsystems, Inc.
 */

#pragma ident	"@(#)yaccpar	6.14	97/01/16 SMI"

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#define YYNEW(type)	malloc(sizeof(type) * yynewmax)
#define YYCOPY(to, from, type) \
	(type *) memcpy(to, (char *) from, yymaxdepth * sizeof (type))
#define YYENLARGE( from, type) \
	(type *) realloc((char *) from, yynewmax * sizeof(type))
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-10000000)

/*
** global variables used by the parser
*/
YYSTYPE *yypv;			/* top of value stack */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



#ifdef YYNMBCHARS
#define YYLEX()		yycvtok(yylex())
/*
** yycvtok - return a token if i is a wchar_t value that exceeds 255.
**	If i<255, i itself is the token.  If i>255 but the neither 
**	of the 30th or 31st bit is on, i is already a token.
*/
#if defined(__STDC__) || defined(__cplusplus)
int yycvtok(int i)
#else
int yycvtok(i) int i;
#endif
{
	int first = 0;
	int last = YYNMBCHARS - 1;
	int mid;
	wchar_t j;

	if(i&0x60000000){/*Must convert to a token. */
		if( yymbchars[last].character < i ){
			return i;/*Giving up*/
		}
		while ((last>=first)&&(first>=0)) {/*Binary search loop*/
			mid = (first+last)/2;
			j = yymbchars[mid].character;
			if( j==i ){/*Found*/ 
				return yymbchars[mid].tvalue;
			}else if( j<i ){
				first = mid + 1;
			}else{
				last = mid -1;
			}
		}
		/*No entry in the table.*/
		return i;/* Giving up.*/
	}else{/* i is already a token. */
		return i;
	}
}
#else/*!YYNMBCHARS*/
#define YYLEX()		yylex()
#endif/*!YYNMBCHARS*/

/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
#if defined(__STDC__) || defined(__cplusplus)
int yyparse(void)
#else
int yyparse()
#endif
{
	register YYSTYPE *yypvt = 0;	/* top of value stack for $vars */

#if defined(__cplusplus) || defined(lint)
/*
	hacks to please C++ and lint - goto's inside
	switch should never be executed
*/
	static int __yaccpar_lint_hack__ = 0;
	switch (__yaccpar_lint_hack__)
	{
		case 1: goto yyerrlab;
		case 2: goto yynewstate;
	}
#endif

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

#if YYMAXDEPTH <= 0
	if (yymaxdepth <= 0)
	{
		if ((yymaxdepth = YYEXPAND(0)) <= 0)
		{
			yyerror("yacc initialization error");
			YYABORT;
		}
	}
#endif

	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */
	goto yystack;	/* moved from 6 lines above to here to please C++ */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			int yynewmax;
#ifdef YYEXPAND
			yynewmax = YYEXPAND(yymaxdepth);
#else
			yynewmax = 2 * yymaxdepth;	/* double table size */
			if (yymaxdepth == YYMAXDEPTH)	/* first time growth */
			{
				char *newyys = (char *)YYNEW(int);
				char *newyyv = (char *)YYNEW(YYSTYPE);
				if (newyys != 0 && newyyv != 0)
				{
					yys = YYCOPY(newyys, yys, int);
					yyv = YYCOPY(newyyv, yyv, YYSTYPE);
				}
				else
					yynewmax = 0;	/* failed */
			}
			else				/* not first time */
			{
				yys = YYENLARGE(yys, int);
				yyv = YYENLARGE(yyv, YYSTYPE);
				if (yys == 0 || yyv == 0)
					yynewmax = 0;	/* failed */
			}
#endif
			if (yynewmax <= yymaxdepth)	/* tables not expanded */
			{
				yyerror( "yacc stack overflow" );
				YYABORT;
			}
			yymaxdepth = yynewmax;

			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register const int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
			skip_init:
				yynerrs++;
				/* FALLTHRU */
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 1:
# line 221 "bibparse.y"
{RECOGNIZE("file-1");} break;
case 2:
# line 223 "bibparse.y"
{RECOGNIZE("file-2");} break;
case 3:
# line 227 "bibparse.y"
{RECOGNIZE("object-1");} break;
case 4:
# line 229 "bibparse.y"
{RECOGNIZE("object-2");} break;
case 5:
# line 233 "bibparse.y"
{RECOGNIZE("object");} break;
case 6:
# line 237 "bibparse.y"
{RECOGNIZE("comment");} break;
case 7:
# line 239 "bibparse.y"
{RECOGNIZE("entry");} break;
case 8:
# line 241 "bibparse.y"
{RECOGNIZE("include");} break;
case 9:
# line 243 "bibparse.y"
{RECOGNIZE("preamble");} break;
case 10:
# line 245 "bibparse.y"
{RECOGNIZE("string");} break;
case 11:
# line 247 "bibparse.y"
{RECOGNIZE("error");} break;
case 12:
# line 252 "bibparse.y"
{RECOGNIZE("comment");} break;
case 13:
# line 258 "bibparse.y"
{RECOGNIZE("entry-1");} break;
case 14:
# line 263 "bibparse.y"
{RECOGNIZE("entry-2");} break;
case 15:
# line 265 "bibparse.y"
{RECOGNIZE("entry-3");} break;
case 16:
# line 272 "bibparse.y"
{RECOGNIZE("entry_head");} break;
case 17:
# line 276 "bibparse.y"
{RECOGNIZE("key_name-1");} break;
case 18:
# line 278 "bibparse.y"
{RECOGNIZE("key_name-2");} break;
case 19:
# line 283 "bibparse.y"
{RECOGNIZE("include");} break;
case 20:
# line 290 "bibparse.y"
{RECOGNIZE("preamble");} break;
case 21:
# line 297 "bibparse.y"
{RECOGNIZE("string");} break;
case 22:
# line 301 "bibparse.y"
{RECOGNIZE("value-1");} break;
case 23:
# line 303 "bibparse.y"
{RECOGNIZE("value-1-1");} break;
case 24:
# line 305 "bibparse.y"
{RECOGNIZE("value-1-2");} break;
case 25:
# line 307 "bibparse.y"
{RECOGNIZE("value-2");} break;
case 26:
# line 311 "bibparse.y"
{RECOGNIZE("simple_value-1");} break;
case 27:
# line 313 "bibparse.y"
{RECOGNIZE("simple_value-2");} break;
case 28:
# line 317 "bibparse.y"
{RECOGNIZE("single assignment");} break;
case 29:
# line 321 "bibparse.y"
{RECOGNIZE("assignment-list");} break;
case 30:
# line 326 "bibparse.y"
{RECOGNIZE("assignment-0");} break;
case 31:
# line 328 "bibparse.y"
{RECOGNIZE("assignment");} break;
case 32:
# line 332 "bibparse.y"
{RECOGNIZE("assignment_lhs-1");} break;
case 33:
# line 334 "bibparse.y"
{RECOGNIZE("assignment_lhs-2");} break;
case 34:
# line 338 "bibparse.y"
{RECOGNIZE("opt_space-1");} break;
case 35:
# line 340 "bibparse.y"
{RECOGNIZE("opt_space-2");} break;
case 36:
# line 344 "bibparse.y"
{RECOGNIZE("single space");} break;
case 37:
# line 346 "bibparse.y"
{RECOGNIZE("multiple spaces");} break;
# line	531 "/usr/ccs/bin/yaccpar"
	}
	goto yystack;		/* reset registers in driver code */
}

