.\" -*-nroff-*-
.\" ====================================================================
.\"  @Troff-man-file{
.\"     author          = "Nelson H. F. Beebe",
.\"     version         = "1.00",
.\"     date            = "11 November 1999",
.\"     time            = "11:00:00 CET",
.\"     filename        = "bibsplit.man",
.\"     copyright       = "Copyright (C) 1999 Nelson H. F. Beebe",
.\"     address         = "Center for Scientific Computing
.\"                        University of Utah
.\"                        Department of Mathematics, 322 INSCC
.\"                        155 S 1400 E RM 233
.\"                        Salt Lake City, UT 84112-0090
.\"                        USA",
.\"     telephone       = "+1 801 581 5254",
.\"     FAX             = "+1 801 585 1640, +1 801 581 4148",
.\"     URL             = "http://www.math.utah.edu/~beebe",
.\"     checksum        = "03270 1083 4326 31612",
.\"     email           = "beebe@math.utah.edu, beebe@acm.org,
.\"                        beebe@ieee.org (Internet)",
.\"     codetable       = "ISO/ASCII",
.\"     keywords        = "bibliography, BibTeX, splitting",
.\"     supported       = "yes",
.\"     docstring       = "This file contains the UNIX manual pages
.\"                        for the bibsplit utility, a program for
.\"                        splitting large bibliographic database
.\"                        files into smaller parts.
.\"
.\"                        The first version of this program was written
.\"                        mostly on the last Veteran's/Remembrance Day
.\"                        of the Twentieth Century, and is dedicated
.\"                        to the memory of those we lost in wars.
.\"
.\"                        The checksum field above contains a CRC-16
.\"                        checksum as the first value, followed by the
.\"                        equivalent of the standard UNIX wc (word
.\"                        count) utility output of lines, words, and
.\"                        characters.  This is produced by Robert
.\"                        Solovay's checksum utility.",
.\"  }
.\" ====================================================================
.\"
.if n .ds Bi BibTeX
.if t .ds Bi B\s-2IB\s+2T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.\"
.if n .ds La LaTeX
.if t .ds La L\\h'-0.24m'\\v'-0.15v'\\s-2A\\s+2\\h'-0.15m'\\v'0.15v'T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.\"
.if n .ds Te TeX
.if t .ds Te T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.\"
.\" ====================================================================
.TH BIBSPLIT 1 "11 November 1999 11:00:00 CET" "Version 1.00"
.\"=====================================================================
.SH NAME
bibsplit \- split large BibTeX bibliography files into independent parts
.\"=====================================================================
.SH SYNOPSIS
.B bibsplit
[
.B \-?
]
[
.B \-author
]
[
.B \-bycentury
]
[
.B \-bydecade
]
.if n .ti +\w'\fBbibsplit\fP\ 'u
[
.B \-byhalfcentury
]
[
.B \-bylabel
]
.if t .ti +\w'\fBbibsplit\fP\ 'u
[
.BI \-bynumber " nnnn"
]
.if n .ti +\w'\fBbibsplit\fP\ 'u
[
.B \-bypentad
]
[
.BI \-byrange " range-list"
]
[
.B \-byscore
]
.if n .ti +\w'\fBbibsplit\fP\ 'u
[
.B \-byyear
]
.if t .ti +\w'\fBbibsplit\fP\ 'u
[
.B \-copyright
]
[
.BI \-filter " command"
]
.if n .ti +\w'\fBbibsplit\fP\ 'u
[
.B \-help
]
[
.BI \-logfile " filename"
]
[
.BI \-maxopen " nnnn"
]
.if n .ti +\w'\fBbibsplit\fP\ 'u
.if t .ti +\w'\fBbibsplit\fP\ 'u
[
.BI \-outfile " filename"
]
[
.BI \-prefix " xxx"
]
[
.B \-quick
]
.if n .ti +\w'\fBbibsplit\fP\ 'u
[
.B \-silent
]
[
.BI \-tmpdir " dirname"
]
[
.B \-version
]
.if n .ti +\w'\fBbibsplit\fP\ 'u
.if t .ti +\w'\fBbibsplit\fP\ 'u
.IR "<infile" " or " " bibfile1 bibfile2 bibfile3 .\|.\|."
.if n .ti +\w'\fBbibsplit\fP\ 'u
.if t .ti +\w'\fBbibsplit\fP\ 'u
.I ">outfile"
.\"=====================================================================
.SH DESCRIPTION
.B bibsplit
splits large bibliographic database files into
smaller independent parts, selecting destination
files according to requests made by
.BI \-by xxx
command-line options, which allow selection by
citation labels, by count of entries, and by
groups of publication years.
.PP
If you want to select entries by more complex
criteria, such as author names, keywords, subject
classifications, title words, etc., then
.B bibsplit
is not the tool you need: use
.BR bibextract (1)
instead.
.PP
As long as \*(Bi\& is asked to retrieve only a
limited number of citations from database files,
it does not matter how many citations there are,
or how big the database files are.  \*(Bi\& simply
processes each file in sequential order, and since
the files are read only once, and internal
processing of string lookups uses a fast
constant-time algorithm, access time is strictly
proportional to the amount of data read and
written.
.PP
However, it is frequently desirable to be able to
typeset a complete bibliography file, so that one
can verify that each entry can be correctly
processed by \*(Bi\&, and correctly typeset by
\*(Te\&.
.PP
This is readily done with a simple \*(Te\& file
that looks like this:
.RS
.nf
\fC\einput btxmac
\ebibliographystyle{plain}
\enocite{*}
\ebibliography{\fImybib\fP}
\ebye\fP
.fi
.RE
.\" NB: apparent groff bug: this paragraph comes
.\" out in italics, unless we wrap it in a roman
.\" font!
\fRor a corresponding \*(La2e\& file that looks
like this:\fP
.RS
.nf
\fC\edocumentclass{article}
\ebibliographystyle{plain}
\ebegin{document}
  \enocite{*}
  \ebibliography{\fImybib\fP}
\eend{document}\fP
.fi
.RE
.PP
Splitting large bibliographic files is sometimes
necessary, because
.RS
.\"-----------------------------------------------
.TP \w'\(bu'u+1n
\(bu
internal table sizes in most \*(Te\& and \*(Bi\&
implementations limit the number of entries
actually extracted from one or more \*(Bi\&
database files to about 4000;
.\"-----------------------------------------------
.TP
\(bu
large database files are undesirable for
World-Wide Web and FTP file transfers across slow
network connections;
.\"-----------------------------------------------
.TP
\(bu
large database files are slower to edit;
.\"-----------------------------------------------
.TP
\(bu
large database files are more prone to massive
editing disasters.
.\"-----------------------------------------------
.RE
.PP
.B bibsplit
provides the needed solution to this problem, and
does so with at most two or three passes over the
input data.
.PP
In the first pass,
.B bibsplit
writes temporary files containing all
.RI non- @String
entries, partitioned according to the command-line
options chosen.  It saves all
.I @String
definitions in memory, and it builds up a list in
memory of which definitions are needed by each of
the temporary files.
.PP
In the second pass,
.B bibsplit
writes the required
.I @String
definitions into the final files, sorted in
ascending lexicographic order, followed by the
contents of their corresponding temporary files,
and then deletes the temporary files.  No further
parsing is needed for the second pass, so it is
relatively fast.
.PP
For user feedback,
.B bibsplit
writes a brief progress report to
.I stdout
at important stages of its work.  If you do not
want to see this, then simply redirect
.I stdout
to the null device: on UNIX,
.BI "bibsplit .\|.\|. >" " /dev/null"
or else use the
.B \-silent
option.
.PP
At the time of writing,
.B bibsplit
processes \*(Bi\& data at about 1MB/sec on a fast
modern UNIX workstation, so practical applications
should never take more than a few seconds.
.\"=====================================================================
.SH OPTIONS
Command-line options may be abbreviated to a
unique leading prefix, and letter case is ignored.
.PP
To avoid confusion with options, if a filename
begins with a hyphen, it must be disguised by a
leading absolute or relative directory path, e.g.,
.I /tmp/-foo.bib
or
.IR ./-foo.bib .
.PP
GNU- and POSIX-style options of the form
.B \-\|\-name
are also recognized: they begin with two option
prefix characters.
.PP
In the event of conflicting
.BI \-by xxx
options, the last one specified takes precedence.
.\"-----------------------------------------------
.TP \w'\fB\-maxopen\fP\fI\ nnnn\fP'u+3n
.B \-?
Display brief usage information on
.I stderr
and exit with a success status code before
processing any input files.
.IP
This is a synonym for
.BR \-help .
.\"-----------------------------------------------
.TP
.B \-author
Show author information on
.I stderr
and exit with a success status code before
processing any input files.
.\"-----------------------------------------------
.TP
.B \-bycentury
Split the input bibliography stream into output
files suffixed by a four-digit century.
.\"-----------------------------------------------
.TP
.B \-bydecade
Split the input bibliography stream into output
files suffixed by a four-digit year identifying
the starting year of the decade.
.\"-----------------------------------------------
.TP
.B \-byhalfcentury
Split the input bibliography stream into output
files suffixed by a four-digit year identifying
the starting year of the half century.
.\"-----------------------------------------------
.TP
.B \-bylabel
Split the input bibliography stream into 26 output
files suffixed by a single lowercase letter
identifying the initial letter of the citation
labels.
.IP
This option is equivalent to, and shorthand for,
.nf
.BR \-byrange "\ a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z."
.fi
.\"-----------------------------------------------
.TP
.BI \-bynumber " nnnn"
Split the input bibliography stream into output
files with no more than
.I nnnn
.RI non- @String
entries.
.IP
As a special case, a zero number is interpreted as
infinity; see the end of this section for a
practical application.
.IP
This option creates output files suffixed by a
four-digit entry count reflecting the input order
of the first entry in that file, and entries are
written to those output files in strict input
order.
.\"-----------------------------------------------
.TP
.B \-bypentad
Split the input bibliography stream into output
files suffixed by a four-digit year identifying
the starting year of the pentad (a five-year
interval).
.\"-----------------------------------------------
.TP
.BI \-byrange " a-e,f-h,i-l,m-p,q-r,s-w,x-z"
Split the input bibliography stream into output
files suffixed by a letter range taken from the
comma-separated range list, identifying the
initial letters of the citation labels.  Ranges
can be indicated by either hyphen or underscore,
and that character will also be used in the output
\*(Bi\& file names.
.TP
The list shown above is only illustrative; you can
choose any sensible letter grouping.
.IP
Lettercase is ignored in the range list.
.IP
Use this option when you want coarser grouping,
and larger output files, than provided by
.BR \-bylabel .
.\"-----------------------------------------------
.TP
.B \-byscore
Split the input bibliography stream into output
files suffixed by a four-digit year identifying
the starting year of each score (twenty) of years.
.\"-----------------------------------------------
.TP
.B \-byyear
Split the input bibliography stream into output
files suffixed by a four-digit year, one year per
output file.
.\"-----------------------------------------------
.TP
.B \-copyright
Show copyright information on
.I stderr
and exit with a success status code before
processing any input files.
.\"-----------------------------------------------
.TP
.BI \-filter " command"
On completion of splitting, apply
.I command
to each output split file, producing a temporary
output file, and if that succeeds, replace the
original output split file by that temporary file.
If
.I command
fails, silently delete the temporary file.
.IP
If
.I command
contains spaces or other characters that are
significant to the shell, then of course it needs
to be surrounded by protecting quotes, or the
special characters need to be prefixed by a
backslash.
.B bibsplit
will surround
.I command
with apostrophes (single quotes), so they cannot
be used in
.IR command .
Should you require apostrophes, then you must
embed your commands inside a short executable
script file, and use that for
.IR command .
.IP
This option is most useful for applying
.BR bibsort (1)
to the output files, because even if the input
bibliography was already sorted, resolution of
citations and cross-references will have destroyed
that order.
.\"-----------------------------------------------
.TP
.B \-help
Display brief usage information on
.I stderr
and exit with a success status code before
processing any input files.
.IP
This is a synonym for
.BR \-? .
.\"-----------------------------------------------
.TP
.BI \-logfile " filename"
Redirect warning and error messages from
.I stderr
to the indicated filename.  This option is
provided for user convenience on poorly-designed
operating systems (e.g., IBM PC DOS) that fail to
provide for redirection of
.I stderr
to a specified file.
.IP
This option can also be used for discarding
messages, with, e.g., on UNIX systems,
.BI \-logfile " /dev/null."
.\"-----------------------------------------------
.TP
.BI \-maxopen " nnnn"
All operating systems have limits, sometimes
Draconian, on the number of simultaneously open
files, and
.BR bibsplit ,
particularly with the
.B \-bylabel
or
.B \-byyear
options, may hit them.
.IP
To avoid the need for
multiple applications of
.BR bibsplit ,
this option limits the number of simultaneously
open files to
.IR nnnn .
This does not increase the number of passes made
over the input stream, but may cause additional
file closing and opening.
.IP
On most modern UNIX systems, and in real
applications, this option should rarely be needed.
.IP
Benchmarks show no noticeable effect on runtime
when small values of
.I nnnn
are chosen, but because
.BR bibsplit 's
implementation language offers no way to test for
an open-file limit-exceeded condition, and because
that limit varies between operating systems and
installations, and on some, even depends on other
current user processes and resource quotas, no
sensible default value for
.I nnnn
can be chosen that is guaranteed to work
everywhere.
.\"-----------------------------------------------
.TP
.BI \-outfile " filename"
Redirect output from
.I stdout
to the indicated filename.  This option is
provided for user convenience on operating systems
that fail to provide for redirection of
.I stdout
to a specified file.
.IP
.B bibsplit
uses
.I stdout
only for a brief progress report, so there is
never much data written to it.
.\"-----------------------------------------------
.TP
.BI \-prefix " xxx"
Supply a prefix for the output file names.  If
this option is omitted, then the basename of the
current input filename
.RI ( including
any leading directory path) is used.  When no
input filename is available, then
.I stdin
is used.
.IP
The suffixes attached to the output filenames
contain no leading separator character, so, for
example, the command
.BI "bibsplit \-byscore " gnats.bib
for a bibliography containing entries from 1941 to
2001 would produce output files
.IR gnats1940.bib ,
.IR gnats1960.bib ,
.IR gnats1980.bib ,
and
.IR gnats2000.bib .
.IP
If you prefer a separator, do it like this:
.BI "bibsplit \-byscore \-prefix " gnats- " " gnats.bib
to get output files named
.IR gnats-1940.bib ,
etc.
.IP
The
.BI \-prefix " xxx"
option may include a directory path, so
.BI "bibsplit \-byscore \-prefix " /usr/tmp/gnats- " " gnats.bib
would write the split files in the directory
.IR /usr/tmp .
.IP
In the interests of maximal filename portability,
.B bibsplit
assumes that slash, backslash, and colon are
directory component separators, and legal
characters in filenames are letters, digits,
hyphen, underscore, and dot; all others will be
removed.
.\"-----------------------------------------------
.TP
.B \-quick
Suppress reading of the initialization files,
.IR $LIBDIR/.bibsplitrc ,
.IR $HOME/.bibsplitrc ,
and
.IR ./.bibsplitrc .
.I LIBDIR
represents the name of the
.B bibsplit
installation directory; it is not a user-definable
environment variable.
.IP
Normally, the contents of those files, if they
exist, are implicitly inserted at the beginning of
the command line, with comments removed and
newlines replaced by spaces.  Thus, those files
can contain any
.B bibsplit
options defined in this documentation, either one
option, or option/value pair, per line, or with
multiple options per line.  Empty lines, and lines
that begin with optional whitespace followed by a
sharp (#) are comment lines that are discarded.
.IP
If the initialization file contains backslashes,
they must be doubled because the text is
interpreted by the shell before
.B bibsplit
sees it.
.\"-----------------------------------------------
.TP
.B \-silent
Suppress output of progress reports to
.IR stdout .
.\"-----------------------------------------------
.TP
.BI \-tmpdir " dirname"
Use the file directory
.I dirname
for temporary files.  Otherwise, following the
common UNIX practice,
.B bibsplit
will use the directory specified by the
environment variable
.IR TMPDIR ,
or if that is not set, then
.IR /tmp .
.IP
This option may also be spelled
.BR \-tempdir .
.\"-----------------------------------------------
.TP
.B \-version
Show version information on
.I stderr
and exit with a success status code before
processing any input files.
.\"-----------------------------------------------
.PP
If no
.BI \-by xxx
options are given,
.B bibsplit
defaults to
.BI \-bynumber " 2000,"
producing a split into files about half the
maximum practical size, with ample room for future
additions.
.PP
In the event that bibliography entries are
encountered that cannot be assigned to a
suitable output file according to the
particular
.BI \-by xxx
option chosen (or assumed by default), they will
be written to a file whose basename is suffixed by
the uppercase string
.IR UNKNOWN .
.PP
Similarly,
.I @String
definitions that are not used in any input
bibliography entry will not be written to the
normal split files, so they are collected, sorted,
and written to a separate file whose basename is
suffixed by the uppercase string
.IR UNUSED .
The basename of that file is determined by that of
the
.I last
input \*(Bi\& file.
.PP
You could use this feature to find and remove
unused
.I @String
definitions, like this:
.RS
.nf
.BI "bibsplit -bynumber" " 0 mybib.bib"
.BI "mv" " mybib.bib mybib.bib-old"
.BI "mv" " mybib-000001.bib mybib.bib"
.fi
.RE
.PP
If a duplicate
.I @String
definition is encountered, then a warning is
issued if the definitions differ, except possibly
at whitespace.  Multiple differing definitions are
collected and later output together in the same
order they were read, so as not to lose
information.
.\"=====================================================================
.SH "COMMENT HANDLING"
The original \*(Bi\& specification did not have a
clearly-defined comment syntax, but the \*(Bi\&
grammar defined by the author in the lengthy
article
.IR "Bibliography prettyprinting and syntax checking" ,
TUGboat,
.BR 14 (3)
222--222,
.BR 14 (4)
395--419, (1993) does: as in \*(Te\&, comments
begin with percent, and run to end-of-line.  That
article is included in the
.BR bibclean (1)
distribution.
.PP
.BR bibclean (1)
and
.B bibsplit
assume that an input file takes the form
.RS
.nf
\fC% FILE HEADER COMMENTS
@Preamble{.\|.\|.}
% preamble comments
@Preamble{.\|.\|.}
% preamble comments
@Preamble{.\|.\|.}
\&.\|.\|.
% STRING BLOCK COMMENTS
@String{.\|.\|.}
% string comments
@String{.\|.\|.}
% string comments
@String{.\|.\|.}
\&.\|.\|.
% ENTRY BLOCK COMMENTS
@Book{.\|.\|.}
% entry comment
@Article{.\|.\|.}
% entry comment
@TechReport{.\|.\|.}
\&.\|.\|.
% FILE TRAILER COMMENTS\fP
.fi
.RE
Blank or empty lines may appear anywhere, and are
thus not shown in this sketch.
.PP
This organization has been found to be the most
useful in many hundreds of \*(Bi\& files
containing hundreds of thousands of document
entries, and is very similar to that commonly
found in well-written computer software for
several decades.  In particular, comments always
.I precede
the code or data that they refer to; they never
follow.
.PP
Any of the comment regions may be empty, and after
the
.I @String
definitions, \*(Bi\& entries for any supported
document type may appear, and in any order.
.PP
The comment blocks in UPPERCASE take precedence
over other comment blocks, and will be transferred
verbatim to
.I every
output file containing \*(Bi\& entries, preserving
the order shown above.
.PP
All other comments are assumed to refer to the
nearest following
.I @Name{...}
group, and will be attached to those groups, and
output when they are output, preserving that
order.
.PP
All input lines that are blank or empty are
discarded.  However, for readability and editing
convenience,
.B bibsplit
takes care to incorporate blank lines around all
bibliographic entries, just as
.BR bibclean (1)
does.
.PP
Any other text which does not conform to the
\*(Bi\& grammar is converted to a comment, and
thus preserved in at least one of the output
files.
.\"=====================================================================
.SH "CROSS-REFERENCE HANDLING"
In most cases, \*(Bi\& file entries are completely
independent of one another, except for use of
abbreviations from
.I @String
definitions, which
.B bibsplit
already handles nicely.
.PP
However, in some types of bibliographies, entries
use the \*(Bi\& \fIcrossref = "label"\fP facility
to include additional data from another entry; the
commonest such case is an
.I @InProceedings
entry that cross references a following
.I @Proceedings
entry.
.PP
Sometimes, an entry may contain a note with a
citation of another entry, such as an article
series where part I cites part II, or an article
citing a subsequent erratum.  For closely-related
articles, it is useful to include such citations
in the \*(Bi\& files, so that an author who
remembers to cite only one of a series of related
publications will automatically get bibliography
entries for all of them.
.PP
In both these cases, the cross-referenced or cited
entry follows the one that references it, so
.BR bibsplit ,
after reading the original entry, is able to
examine it, and prepare a list of entries that it
refers to.  When
.B bibsplit
later encounters those entries, it outputs them
not only to their normal split file, but also to
all of the other files that contain earlier
entries that refer to them.
.PP
Backward references are, however, more
challenging.  For example, an article erratum
might contain a citation of the original paper,
which appears earlier in a bibliography ordered by
publication time.  In this case,
.B bibsplit
will have already output the original entry
without knowing that it will later be cited, and
because it makes no attempt to hold all entries in
memory (a strategy that would routinely fail on
small systems), the cross reference has arrived
too late for it to act.  \*(Bi\& itself would
require a following \*(La\& or \*(Te\& run to
deposit the citation into the auxiliary file, in
which a second \*(Bi\& run would find it, and
finally correctly incorporate the cross reference
in the typeset bibliography.
.PP
To deal with this important case of backward
references, while still being frugal with memory,
.B bibsplit
takes a different approach.  As each entry is
output to a split file,
.B bibsplit
augments a list with entries (citation-label,
\*(Bi\&-filename), so that it knows in which file
each entry has been written.  It also records the
citation labels of any embedded references in a
to-be-found list, with entries of the form
(citation-label, \*(Bi\&-filename-1,
\*(Bi\&-filename-2, .\|.\|.,
\*(Bi\&-filename-\fIn\fP).  It then looks in the
to-be-found list to see if this entry is needed by
earlier entries already written to other files as
well, and if so, outputs it to those.
.PP
On completion of processing of all of the input
stream, and generation of any unused-labels file,
it then re-examines the to-be-found list, sorts it
by filename, and then steps through these files in
order, reading entries, and writing each one found
out to all of the \*(Bi\& file(s) in which it has
been referenced, but does not yet appear.  Any
citation label from the to-be-found list which is
not in the original (citation-label,
\*(Bi\&-filename) list is diagnosed as an
unsatisfied reference, since its absence is
definitely an error in the bibliography.
.PP
In the worst case, this algorithm will result in
.BR bibsplit 's
reading the input data a total of three times, but
in most cases, only a few of the split files, and
sometimes, none, need to be read again.
.\"=====================================================================
.SH CAVEATS
\*(Bi\& has loose syntactical requirements that
the current simple implementation of
.B bibsplit
does not support.  In particular, outer
parentheses may
.I not
be used in place of braces following ``@keyword''
patterns.  If you have such a file, you can use
.BR bibclean (1)
to prettyprint it into a form that
.B bibsplit
can handle successfully.
.PP
Because all
.I @String
definitions are saved in memory, and all citation
labels as well, very large jobs may exceed the
memory requirements of very small systems. About
two megabytes of memory should suffice for the
vast majority of practical applications.
.\"=====================================================================
.SH "ENVIRONMENT VARIABLES"
.\"-----------------------------------------------
.TP \w'\fITMPDIR\fP'u+2n
.I TMPDIR
Name of directory where
.B bibsplit
writes its temporary files.  Its value is ignored
if a command-line
.BI \-tmpdir " dirname"
option is given.
.RI [default: " /tmp" ]
.\"-----------------------------------------------
.\"=====================================================================
.SH FILES
In the following,
.I LIBDIR
represents the name of the
.B bibsplit
installation directory; it is not a user-definable
environment variable.  If
.B bibsplit
has been installed properly at your site,
the value of
.I LIBDIR
is
.RS
.nf
\fC@LIBDIR@\fP
.fi
.RE
.\"-----------------------------------------------
.TP \w'\fC$LIBDIR/bibsplit.awk\fP'u+2n
\&\fC$LIBDIR/.bibsplitrc\fP
System-specific initialization file containing
customized
.B bibsplit
command-line options.
.\"-----------------------------------------------
.TP
\&\fC$HOME/.bibsplitrc\fP
User-specific initialization file containing
customized
.B bibsplit
command-line options.
.\"-----------------------------------------------
.TP
\&\fC./.bibsplitrc\fP
Current-directory-specific initialization file
containing customized
.B bibsplit
command-line options.
.\"-----------------------------------------------
.TP
\&\fC$LIBDIR/bibsplit.awk\fP
.BR awk (1)
program
invoked by
.BR bibsplit .
.\"-----------------------------------------------
.\"=====================================================================
.SH "SEE ALSO"
.BR awk (1),
.BR bawk (1),
.BR bibcheck (1),
.BR bibclean (1),
.BR bibdup (1),
.BR bibextract (1),
.BR bibjoin (1),
.BR biblabel (1),
.BR biblex (1),
.BR biborder (1),
.BR bibparse (1),
.BR bibsearch (1),
.BR bibsort (1),
.BR bibtex (1),
.BR bibunlex (1),
.BR bstpretty (1),
.BR citesub (1),
.BR emacs (1),
.BR gawk (1),
.BR lacheck (1),
.BR latex (1),
.BR mawk (1),
.BR nawk (1),
.BR tex (1).
.\"=====================================================================
.SH AUTHOR
.nf
Nelson H. F. Beebe
Center for Scientific Computing
University of Utah
Department of Mathematics, 322 INSCC
155 S 1400 E RM 233
Salt Lake City, UT 84112-0090
USA
Email: \fCbeebe@math.utah.edu\fP, \fCbeebe@acm.org\fP, \fCbeebe@ieee.org\fP (Internet)
WWW URL: \fChttp://www.math.utah.edu/~beebe\fP
Telephone: +1 801 581 5254
FAX: +1 801 585 1640, +1 801 581 4148
.fi
.\"=====================================================================
.SH AVAILABILITY
.B bibsplit
is freely available; its master distribution can
be found at
.PP
.RS
.nf
\&\fCftp://ftp.math.utah.edu/pub/tex/bib/\fP
\&\fChttp://www.math.utah.edu/pub/tex/bib/\fP
.fi
.RE
.PP
in the file
.I bibsplit-x.yy.tar.gz
where
.I x.yy
is the current version.  Other distribution
formats are usually available at the same
location.
.PP
That site is mirrored to several other Internet
archives, so you may also be able to find it
elsewhere on the Internet; try searching for the
string
.I bibsplit
at one or more of the popular Web search sites,
such as
.PP
.RS
.nf
\&\fChttp://altavista.digital.com/
http://search.microsoft.com/us/default.asp
http://www.dejanews.com/
http://www.dogpile.com/index.html
http://www.euroseek.net/page?ifl=uk
http://www.excite.com/
http://www.go2net.com/search.html
http://www.google.com/
http://www.hotbot.com/
http://www.infoseek.com/
http://www.inktomi.com/
http://www.lycos.com/
http://www.northernlight.com/
http://www.snap.com/
http://www.stpt.com/
http://www.yahoo.com/\fP
.fi
.RE
.\"=====================================================================
.SH COPYRIGHT
.nf
\fC########################################################################
########################################################################
########################################################################
###                                                                  ###
### bibsplit: split BibTeX bibliography files into independent parts ###
###                                                                  ###
###              Copyright (C) 1999 Nelson H. F. Beebe               ###
###                                                                  ###
### This program is covered by the GNU General Public License (GPL), ###
### version 2 or later, available as the file COPYING in the program ###
### source distribution, and on the Internet at                      ###
###                                                                  ###
###               ftp://ftp.gnu.org/gnu/GPL                          ###
###                                                                  ###
###               http://www.gnu.org/copyleft/gpl.html               ###
###                                                                  ###
### This program is free software; you can redistribute it and/or    ###
### modify it under the terms of the GNU General Public License as   ###
### published by the Free Software Foundation; either version 2 of   ###
### the License, or (at your option) any later version.              ###
###                                                                  ###
### This program is distributed in the hope that it will be useful,  ###
### but WITHOUT ANY WARRANTY; without even the implied warranty of   ###
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    ###
### GNU General Public License for more details.                     ###
###                                                                  ###
### You should have received a copy of the GNU General Public        ###
### License along with this program; if not, write to the Free       ###
### Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   ###
### MA 02111-1307 USA                                                ###
########################################################################
########################################################################
########################################################################\fP
.fi
.\"==============================[The End]==============================
.\" This is for GNU Emacs file-specific customization:
.\" Local Variables:
.\" fill-column: 50
.\" End:
