dnl Adds R6 stuff to the Autoconf 1.11 version.
dnl Everything will change for Autoconf 2.0. 
undef(AC_FIND_XTRA)
define(AC_FIND_XTRA, [AC_REQUIRE([AC_ISC_POSIX])AC_REQUIRE([AC_FIND_X])
AC_CHECKING(for additional X libraries and flags)
if test -n "$x_includes"; then
  X_CFLAGS="$X_CFLAGS -I$x_includes"
elif test -n "$no_x"; then 
  # Not all programs may use this symbol, but it won't hurt to define it.
  X_CFLAGS="$X_CFLAGS -DX_DISPLAY_MISSING"
fi

# It would be nice to have a more robust check for the -R ld option than
# just checking for Solaris.
# It would also be nice to do this for all -L options, not just this one.
if test -n "$x_libraries"; then
  X_LIBS="$X_LIBS -L$x_libraries"
  if test "`(uname) 2>/dev/null`" = SunOS \
     && uname -r | grep '^5' >/dev/null; then
    X_LIBS="$X_LIBS -R$x_libraries"
  fi
fi

# Check for libraries that X11R6 Xt/Xaw programs need.
save_ldflags=$LDFLAGS
LDFLAGS="$LDFLAGS -L$x_libraries"
# Unfortunately, SM needs ICE to (dynamically) link under SunOS 4.x (so
# we have to check for ICE first), but we must link in the order -lSM
# -lICE or we get undefined symbols.  Resolution is just to assume we
# have SM if we have ICE.  Why not?  Furthermore, these have to be
# linked with before -lX11, in contrast to the other libraries we check
# for below, so use a different variable.
#  --interran@uluru.Stanford.EDU, kb@cs.umb.edu.
AC_HAVE_LIBRARY(ICE, [X_R6_LIBS="$X_EXTRA_LIBS -lSM -lICE"])
LDFLAGS=$save_ldflags

# Check for system-dependent libraries X programs must link with.
if test -n "$ISC"; then
  X_EXTRA_LIBS="$X_EXTRA_LIBS -lnsl_s -linet"
else
  # Martyn.Johnson@cl.cam.ac.uk says this is needed for Ultrix, if the X
  # libraries were built with DECnet support.  And karl@cs.umb.edu's Alpha
  # needs dnet_stub (dnet doesn't exist).
  AC_HAVE_LIBRARY(dnet,
    [X_EXTRA_LIBS="$X_EXTRA_LIBS -ldnet"
     ac_have_dnet=t])
  if test -z "$ac_have_dnet"; then
    AC_HAVE_LIBRARY(dnet_stub, [X_EXTRA_LIBS="$X_EXTRA_LIBS -ldnet_stub"])
  fi
  #
  # msh@cis.ufl.edu says -lnsl (and -lsocket) are needed for his 386/AT.
  # Not sure which flavor of 386 Unix this is, but it seems harmless to
  # check for it.
  AC_HAVE_LIBRARY(nsl, [X_EXTRA_LIBS="$X_EXTRA_LIBS -lnsl"])
  #
  # lieder@skyler.mavd.honeywell.com says without -lsocket,
  # socket/setsockopt and other routines are undefined under SCO ODT 2.0.
  # But -lsocket is broken on IRIX, according to simon@lia.di.epfl.ch.
  if test "`(uname) 2>/dev/null`" != IRIX; then
    AC_HAVE_LIBRARY(socket, [X_EXTRA_LIBS="$X_EXTRA_LIBS -lsocket"])
  fi
fi
#
AC_VERBOSE(X compiler flags: $X_CFLAGS)
AC_VERBOSE(X library flags: $X_LIBS)
AC_VERBOSE(R6 libraries: $X_R6_LIBS)
AC_VERBOSE(extra X libraries: $X_EXTRA_LIBS)
AC_SUBST(X_CFLAGS)dnl
AC_SUBST(X_LIBS)dnl
AC_SUBST(X_R6_LIBS)dnl
AC_SUBST(X_EXTRA_LIBS)dnl
])dnl
